package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

import jp.kirikiri.tvp2.TVP;

public class WindowList {
	public ArrayList<WindowNI> mWindowVector;

	public WindowList() {
		mWindowVector = new ArrayList<WindowNI>();
	}
	public void registerWindowToList( WindowNI window ) {
		if(TVP.MainWindow == null && mWindowVector.size() == 0) {
			// first time the window is registered
			TVP.MainWindow = window; // set as main window
		}
		mWindowVector.add(window);

		// notify that the layer must lost capture state
		final int count = mWindowVector.size();
		for( int i = 0; i < count; i++ ) {
			WindowNI ni = mWindowVector.get(i);
			ni.postReleaseCaptureEvent();
		}
	}

	public void unregisterWindowToList( WindowNI window ) {
		final int count = mWindowVector.size();
		for( int i = 0; i < count; i++ ) {
			WindowNI ni = mWindowVector.get(i);
			if( ni == window ) {
				boolean flag = false;
				if( ni == TVP.MainWindow ) flag = true;
				mWindowVector.remove(i);
				if( flag ) {
					TVP.mainWindowClose(); // MainWindow had been closed
					TVP.MainWindow = null;
				}
				break;
			}
		}
	}

	public WindowNI getWindowListAt( int idx ) { return mWindowVector.get(idx); }

	public int getWindowCount() { return mWindowVector.size(); }

	public void clearAllWindowInputEvents() {
		final int count = mWindowVector.size();
		for( int i = 0; i < count; i++ ) {
			WindowNI ni = mWindowVector.get(i);
			ni.clearInputEvents();
		}
	}

	public void deliverDrawDeviceShow() {
		final int count = mWindowVector.size();
		for( int i = 0; i < count; i++ ) {
			WindowNI ni = mWindowVector.get(i);
			ni.deliverDrawDeviceShow();
		}
	}
}
