package jp.kirikiri.tvp2.base;

import java.io.IOException;
import java.io.OutputStream;

import jp.kirikiri.tjs2.BinaryStream;

public class BinaryOutputStream extends OutputStream {

	private BinaryStream mStream;

	public BinaryOutputStream( BinaryStream stream ) {
		super();
		mStream = stream;
	}

	/** 出力ストリームを閉じ、このストリームに関連するすべてのシステムリソースを解放します。*/
	@Override
	public void close() {
		mStream.close();
	}

	/** 出力ストリームをフラッシュして、バッファリングされていたすべての出力バイトを強制的に書き込みます。 */
	@Override
	public void flush() {
	}

	/**指定されたバイト配列の b.length バイトをこの出力ストリームに書き込みます。*/
	@Override
	public void write(byte[] b) {
		mStream.write(b);

	}
	/** 指定されたバイト配列の、オフセット位置 off から始まる len バイトをこの出力ストリームに書き込みます。 */
	@Override
	public void write(byte[] b, int off, int len) {
		mStream.write(b,off,len);
	}
	/** 指定されたバイトをこの出力ストリームに書き込みます。
	 * */
	@Override
	public void write(int b) throws IOException {
		mStream.write(b);
	}
}
