package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.env.FileSelector;

public class StorageClass extends NativeClass {
	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		MEMBERMUSTEXIST     = 0x00000400, // member *must* exist ( for Dictionary/Array )
		IGNOREPROP			= 0x00000800, // ignore property invoking
		HIDDENMEMBER		= 0x00001000, // member is hidden
		STATICMEMBER		= 0x00010000, // member is not registered to the
										  // object (internal use)
		ENUM_NO_VALUE		= 0x00100000; // values are not retrieved
										  // (for EnumMembers)
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final String CLASS_NAME = "Storage";
	static private final int nitMethod	= 1;

	public StorageClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "addAutoPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if(param.length < 1) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				TVP.AutoPath.addAutoPath(path);
				if( result != null ) result.clear();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "removeAutoPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if(param.length < 1) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				TVP.AutoPath.removeAutoPath(path);
				if( result != null ) result.clear();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getFullPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if(param.length < 1) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( TVP.StorageMediaManager.normalizeStorageName(path,null) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getPlacedPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.getPlacedPath(path) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "isExistentStorage", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.isExistentStorage(path) ? 1 : 0 );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStorageExt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.extractStorageExt(path) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStorageName", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.extractStorageName(path) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStoragePath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.extractStoragePath(path) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "chopStorageExt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					result.set( Storage.chopStorageExt(path) );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "clearArchiveCache", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				TVP.ArchiveCache.clear();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "searchCD", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( result != null ) {
					result.set( 0 ); // Alway false
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getLocalName", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				String path = param[0].asString();
				if( result != null ) {
					String str = TVP.StorageMediaManager.normalizeStorageName(path,null);
					str = TVP.StorageMediaManager.getLocalName(str);
					result.set( str );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "selectFile", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				Dispatch2 dsp =  param[0].asObject();
				boolean res = FileSelector.selectFile(dsp);
				if( result != null ) {
					result.set( res ? 1 : 0 );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );
	}
}
