package jp.kirikiri.tvp2.base;

import java.io.File;
import java.util.UUID;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.Random;

public class SystemInitializer {

	static public void systemInitialize() throws TJSException {
		beforeSystemInitialize();

		//ScriptsClass.initScriptEnging();

		System.gc(); // TODO

		// TVPInitTVPGL(); // TODO

		// TVPAfterSystemInit(); // TODO
	}
	static private void initializeRandomGenerator() {
		// initialize random generator
		Random.updateEnvironNoiseForTick();

		UUID uuid = UUID.randomUUID();
		long l = uuid.getLeastSignificantBits();
        Random.pushEnvironNoise(l);
        long m = uuid.getMostSignificantBits();
		Random.pushEnvironNoise(m);

		// プロセスIDの取得は飛ばす

		long id = Thread.currentThread().getId();
		Random.pushEnvironNoise(id);

		Random.updateEnvironNoiseForTick();

		// カーソル位置からの取得は飛ばす

		// ウィンドウ情報からの取得は飛ばす
	}
	static private void beforeSystemInitialize() throws TJSException {

		//RegisterDllLoadHook(); // register DLL delayed import hook to support _inmm.dll

		//TVPInitProgramArgumentsAndDataPath(false); // ensure command line

		/*
		Application->HintHidePause = 24*60*60*1000; // not to hide tool tip hint immediately
		Application->ShowHint = false;
		Application->ShowHint = true; // to ensure assigning new HintWindow Class defined in HintWindow.cpp
		*/


		// randomize
		initializeRandomGenerator();

		// memory usage
		{
			Runtime runtime = Runtime.getRuntime();
			long totalMem = runtime.totalMemory();
			long maxMem = runtime.maxMemory();
			long freeMem = runtime.freeMemory();
			Random.pushEnvironNoise(totalMem);
			Random.pushEnvironNoise(maxMem);
			Random.pushEnvironNoise(freeMem);

			TVP.MaxMemory = maxMem;

			DebugClass.addImportantLog( "(info) Max memory : " + maxMem );

			/*
			Variant opt = new Variant();
			if(TVPGetCommandLine( "-memusage", opt) ) {
				String str = opt.asString();
				if( str == "low") TVP.MaxMemory = 0; // assumes zero
			}
			*/

			if( TVP.MaxMemory <= 36*1024*1024 ) {
				// very very low memory, forcing to assume zero memory
				TVP.MaxMemory = 0;
			}

			/*
			if( TVP.MaxMemory < 48*1024*1024 ) {
				// extra low memory
				if( TJSObjectHashBitsLimit > 0) TJSObjectHashBitsLimit = 0;
				TVPSegmentCacheLimit = 0;
				TVPFreeUnusedLayerCache = true; // in LayerIntf.cpp
			} else if( TVP.MaxMemory < 64*1024*1024) {
				// low memory
				if(TJSObjectHashBitsLimit > 4)
					TJSObjectHashBitsLimit = 4;
			}
			*/
		}


		String buf = null;
		boolean bufset = false;
		boolean nosel = false;
		boolean forcesel = false;
		boolean forcedataxp3 = false;
		boolean acceptfilenameargument = false;

		String currentDir = System.getProperty("user.dir"); // TODO Android で大丈夫かチェックというか、カレントディレクトリ意味ないか

		if( currentDir.charAt(currentDir.length()-1) != File.separatorChar ) {
			currentDir += File.separatorChar;
		}
		/*

		char buf[MAX_PATH];
		bool forcedataxp3 = GetSystemSecurityOption("forcedataxp3") != 0;
		bool acceptfilenameargument = GetSystemSecurityOption("acceptfilenameargument") != 0;

		if(!forcedataxp3 && !acceptfilenameargument)
		{
			if(TVPGetCommandLine(TJS_W("-nosel")) || TVPGetCommandLine(TJS_W("-about")))
			{
				nosel = true;
			}
			else
			{
				for(tjs_int i = 1; i<_argc; i++)
				{
					if(_argv[i][0] == '-' &&
						_argv[i][1] == '-' && _argv[i][2] == 0)
						break;

					if(_argv[i][0] != '-')
					{
						// TODO: set the current directory
						strncpy(buf, _argv[i], MAX_PATH-1);
						buf[MAX_PATH-1] = '\0';
						if(DirectoryExists(buf)) // is directory?
							strcat(buf, "\\");

						TVPProjectDirSelected = true;
						bufset = true;
						nosel = true;
					}
				}
			}
		}

		// check "-sel" option, to force show folder selection window
		if(!forcedataxp3 && TVPGetCommandLine(TJS_W("-sel")))
		{
			// sel option was set
			if(bufset)
			{
				char path[MAX_PATH];
				char *dum = 0;
				GetFullPathName(buf, MAX_PATH-1, path, &dum);
				strcpy(buf, path);
				TVPProjectDirSelected = false;
				bufset = true;
			}
			nosel = true;
			forcesel = true;
		}

		// check "content-data" directory
		if(!forcedataxp3 && !nosel)
		{
			char tmp[MAX_PATH];
			strcpy(tmp, IncludeTrailingBackslash(ExtractFileDir(ParamStr(0))).c_str());
			strcat(tmp, "content-data");
			if(DirectoryExists(tmp))
			{
				strcat(tmp, "\\");
				strcpy(buf, tmp);
				TVPProjectDirSelected = true;
				bufset = true;
				nosel = true;
			}
		}
		*/

		// check "data.xp3" archive
	 	if( !nosel ) {
			String dataXP3 = currentDir + "data.xp3";
			File file = new File(dataXP3);
			if( file.exists() && file.isFile() ) {
				buf = dataXP3;
				TVP.ProjectDirSelected = true;
				bufset = true;
				nosel = true;
			}
		}

	 	/*
		// check "data.exe" archive
	 	if(!nosel)
		{
			char tmp[MAX_PATH];
			strcpy(tmp, IncludeTrailingBackslash(ExtractFileDir(ParamStr(0))).c_str());
			strcat(tmp, "data.exe");
			if(FileExists(tmp))
			{
				strcpy(buf, tmp);
				TVPProjectDirSelected = true;
				bufset = true;
				nosel = true;
			}
		}

		// check self combined xpk archive
		if(!nosel)
		{
			if(TVPIsXP3Archive(TVPNormalizeStorageName(ParamStr(0))))
			{
				strcpy(buf, ParamStr(0).c_str());
				TVPProjectDirSelected = true;
				bufset = true;
				nosel = true;
			}
		}
		*/


		// check "data" directory
		if( !forcedataxp3 && !nosel ) {
			String dataDir = currentDir + "data";
			File dir = new File(dataDir);
			if( dir.exists() && dir.isDirectory( ) ) {
				buf = dataDir + File.separatorChar;
				TVP.ProjectDirSelected = true;
				bufset = true;
				nosel = true;
			}
		}

		// decide a directory to execute or to show folder selection
		/*
		if( !bufset ) {
			if(forcedataxp3) throw EAbort("Aborted");
			strcpy(buf, ExtractFileDir(ParamStr(0)).c_str());
			int curdirlen = strlen(buf);
			if(buf[curdirlen-1] != '\\') buf[curdirlen] = '\\', buf[curdirlen+1] = 0;
		}
		*/

		/*
		 * 選択ダイアログを出す
		if(!forcedataxp3 && (!nosel || forcesel)) {
			// load krdevui.dll ( TVP[KiRikiri] Development User Interface )
			HMODULE krdevui = LoadLibrary("krdevui.dll");
			if(!krdevui)
			{
				AnsiString toolspath = (IncludeTrailingBackslash(
						ExtractFilePath(ParamStr(0))) + "tools\\krdevui.dll");
				krdevui = LoadLibrary(toolspath.c_str());
			}

			if(!krdevui)
			{
				// cannot locate the dll
				throw Exception(
					ttstr(TVPCannnotLocateUIDLLForFolderSelection).AsAnsiString());
			}

			typedef int PASCAL (*UIShowFolderSelectorForm_t)(void *reserved, char *buf);
			typedef void PASCAL (*UIGetVersion_t)(DWORD *hi, DWORD *low);

			UIShowFolderSelectorForm_t	UIShowFolderSelectorForm;
			UIGetVersion_t				UIGetVersion;

			UIShowFolderSelectorForm =
				(UIShowFolderSelectorForm_t)GetProcAddress(krdevui, "UIShowFolderSelectorForm");
			UIGetVersion =
				(UIGetVersion_t)GetProcAddress(krdevui, "UIGetVersion");

			if(!UIShowFolderSelectorForm || !UIGetVersion)
			{
				FreeLibrary(krdevui);
				throw Exception(ttstr(TVPInvalidUIDLL).AsAnsiString());
			}

			DWORD h, l;
			UIGetVersion(&h, &l);
			if(h != TVP_NEED_UI_VERSION)
			{
				FreeLibrary(krdevui);
				throw Exception(ttstr(TVPInvalidUIDLL).AsAnsiString());
			}


			int result = UIShowFolderSelectorForm(Application->Handle, buf);

//			FreeLibrary(krdevui);
			// FIXME: the library should be freed as soon as finishing to use it.

			if(result == mrAbort)
			{
				// display the main window
			}
			else
			if(result == mrCancel)
			{
				// cancel
				throw EAbort("Canceled");
			}
			else
			if(result == mrOk)
			{
				// ok, prepare to execute the script
				TVPProjectDirSelected = true;
			}
		}
		*/

		// check project dir and store some environmental variables
		if( TVP.ProjectDirSelected ) {
			//Application->ShowMainForm = false;
		}

		if( buf != null  ) {
			if( buf.charAt(buf.length()-1) != File.separatorChar ) {
				buf += Storage.ArchiveDelimiter;
			}
		} else {
			throw new TJSException();
		}

		TVP.ProjectDir = TVP.StorageMediaManager.normalizeStorageName(buf,null);
		Storage.setCurrentDirectory(TVP.ProjectDir);
		TVP.NativeProjectDir = buf;

		if( TVP.ProjectDirSelected ) {
			DebugClass.addImportantLog( "(info) Selected project directory : " + TVP.ProjectDir );
		}
	}
}
