package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class DebugClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitClass	= 0,
		nitMethod	= 1,
		nitProperty = 2;

	public static void addLog( String mes ) {
		Logger.log( mes );
	}
	public static void addImportantLog( String mes ) {
		Logger.log( mes );
	}
	protected NativeInstance createNativeInstance() {
		return null;
	}

	public DebugClass() throws VariantException, TJSException {
		super("Debug");
		final String __classname = "Debug";
		final int NCM_CLASSID = TJS.registerNativeClass(__classname);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		Class<? extends DebugClass> c = getClass();
		registerMethods( c, __classname );
	}
	public static int constructor( Variant result, Variant[] param, Dispatch2 objthis ) {
		return S_OK;
	}
	public static int finalize( Variant result, Variant[] param, Dispatch2 objthis ) {
		return S_OK;
	}
	public static int message( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( param.length == 1 ) {
			addLog( param[0].asString() );
		} else {
			// display the arguments separated with ", "
			StringBuilder builder = new StringBuilder(512);
			for( int i = 0; i < param.length; i++ ) {
				if( i != 0 ) builder.append(", ");
				builder.append( param[i].asString() );
			}
			addLog( builder.toString() );
		}
		return S_OK;
	}
	public static int notice( Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;
		if( param.length == 1 ) {
			addImportantLog( param[0].asString() );
		} else {
			// display the arguments separated with ", "
			StringBuilder builder = new StringBuilder(512);
			for( int i = 0; i < param.length; i++ ) {
				if( i != 0 ) builder.append(", ");
				builder.append( param[i].asString() );
			}
			addImportantLog( builder.toString() );
		}
		return S_OK;
	}

}
