package jp.kirikiri.tvp2.base;

import java.util.HashMap;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.msg.Message;

public class ArchiveCache {
	static private final int DEFAULT_ARCHIVE_CACHE_NUM = 64;

	private HashMap<String,Archive> mArchiveCache;

	public ArchiveCache() {
		mArchiveCache = new HashMap<String,Archive>(DEFAULT_ARCHIVE_CACHE_NUM);
	}

	/*
	public void setMaxCount( int maxcount ) {
		//ArchiveCache.setMaxCount(maxcount);
	}
	*/

	void clear() {
		// releases all elements
		mArchiveCache.clear();
	}

	Archive get( final String name ) throws TJSException {
		String nname = TVP.StorageMediaManager.normalizeStorageName(name,null);
		synchronized (this) {
			Archive ptr = mArchiveCache.get(nname);
			if( ptr != null ) {
				// exist in the cache
				return ptr;
			}

			if( !Storage.isExistentStorageNoSearch(nname) )
			{
				// storage not found
				Message.throwExceptionMessage( Message.CannotFindStorage, nname );
			}

			// not exist in the cache
			Archive arc = TVP.openArchive(nname);
			mArchiveCache.put(nname,arc);
			return arc;
		}
	}
}
