/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

import java.util.HashMap;

public class ScriptCache {
	private static final int SCRIPT_CACHE_MAX = 64;

	static class ScriptCacheData {
		public String mScript;
		public boolean mExpressionMode;
		public boolean mMustReturnResult;

		public boolean equals( Object o ) {
			if( o instanceof ScriptCacheData && o != null ) {
				ScriptCacheData rhs = (ScriptCacheData)o;
				return( mScript.equals(rhs.mScript) && mExpressionMode == rhs.mExpressionMode &&
						mMustReturnResult == rhs.mMustReturnResult );
			} else {
				return false;
			}
		}
		public int hashCode() {
			int v = mScript.hashCode();
			v ^= mExpressionMode ? 1 : 0;
			v ^= mMustReturnResult ? 1 : 0;
			return v;
		}
	}

	private TJS mOwner;
	private HashMap<ScriptCacheData,ScriptBlock> mCache;

	public ScriptCache( TJS owner) {
		mOwner = owner;
		mCache = new HashMap<ScriptCacheData,ScriptBlock>(SCRIPT_CACHE_MAX);
	}

	public void execScript( final String script, Variant result, Dispatch2 context, final String name, int lineofs ) throws VariantException, TJSException, CompileException {

		Compiler compiler = new Compiler(mOwner);
		if( name != null ) compiler.setName(name, lineofs);
		ScriptBlock blk = compiler.doCompile(script, false, result!=null);
		if( blk == null ) return;
		compiler = null;
		blk.executeTopLevel(result, context);

		/*
		ScriptBlock blk = new ScriptBlock(mOwner);
		if( name != null ) blk.setName(name, lineofs);
		blk.setText(result, script, context, false);
		*/
		if( blk.getContextCount() == 0 ) {
			mOwner.removeScriptBlock(blk);
		}
		blk.compact();
		blk = null;
	}

	public void evalExpression(String expression, Variant result, Dispatch2 context, String name, int lineofs) throws VariantException, TJSException, CompileException {
		// currently this works only with anonymous script blocks.
		// note that this function is basically the same as function above.
		if( name != null && name.length() > 0 ) {
			Compiler compiler = new Compiler(mOwner);
			compiler.setName(name, lineofs);
			ScriptBlock blk = compiler.doCompile(expression, true, result!=null);
			compiler = null;
			if( blk != null ) {
				blk.executeTopLevel(result, context);
				/*
				ScriptBlock blk = new ScriptBlock(mOwner);
				blk.setName( name, lineofs);
				blk.setText( result, expression, context, true );
				 */
				if( blk.getContextCount() == 0 ) {
					mOwner.removeScriptBlock(blk);
				}
				blk.compact();
				blk = null;
			}
			return;
		}

		// search through script block cache
		ScriptCacheData data = new ScriptCacheData();
		data.mScript = expression;
		data.mExpressionMode = true;
		data.mMustReturnResult = result != null;

		ScriptBlock block = mCache.get(data);
		if( block != null ) {
			// found in cache
			// execute script block in cache
			block.executeTopLevelScript(result, context);
			return;
		}

		// not found in cache
		Compiler compiler = new Compiler(mOwner);
		compiler.setName(name, lineofs);
		ScriptBlock blk = compiler.doCompile(expression, true, result!=null);
		blk.executeTopLevel(result, context);
		boolean preprocess = compiler.isUsingPreProcessor();
		compiler = null;

		//ScriptBlock blk = new ScriptBlock(mOwner);
		//blk.setText( result, expression, context, true);
		// add to cache
		if( blk.isReusable() && !preprocess ) {
			// currently only single-context script block is cached
			mCache.put(data, blk);
		} else {
			if( blk.getContextCount() == 0 ) {
				mOwner.removeScriptBlock(blk);
			}
		}
		blk.compact();
		blk = null;
		return;
	}
}
