package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.visual.BaseWindowNI;
import jp.kirikiri.tvp2.visual.MenuItemNI;

public class WindowEvents {
	public static class OnCloseInputEvent extends BaseInputEvent {
		public OnCloseInputEvent( BaseWindowNI win ) {
			super( win, ++InputEventTagMax );
		}
		public void deliver() {
			((BaseWindowNI)getSource()).onClose();
		}
	}

	public static class OnResizeInputEvent extends BaseInputEvent {
		public OnResizeInputEvent( BaseWindowNI win ) {
			super(win, ++InputEventTagMax);
		}
		public void deliver() {
			((BaseWindowNI)getSource()).onResize();
		}
	}

	public static class OnClickInputEvent extends BaseInputEvent {
		private int X;
		private int Y;
		public OnClickInputEvent(BaseWindowNI win, int x, int y) {
			super(win, ++InputEventTagMax);
			X = x;
			Y = y;
		}
		public void deliver() throws TJSException {
			((BaseWindowNI)getSource()).onClick(X, Y);
		}
	}

	public static class OnDoubleClickInputEvent extends BaseInputEvent {
		private int X;
		private int Y;
		public OnDoubleClickInputEvent(BaseWindowNI win, int x, int y) {
			super(win, ++InputEventTagMax);
			X = x;
			Y = y;
		}
		public void deliver() throws TJSException {
			((BaseWindowNI)getSource()).onDoubleClick(X, Y);
		}
	}

	public static class OnMouseDownInputEvent extends BaseInputEvent {
		private int X;
		private int Y;
		//MouseButton Buttons;
		private int Buttons;
		private int Flags;
		public OnMouseDownInputEvent(BaseWindowNI win, int x, int y, int buttons, int flags ) {
			super(win, ++InputEventTagMax);
			X = x;
			Y = y;
			Buttons = buttons;
			Flags = flags;
		}
		public void deliver() throws TJSException {
			((BaseWindowNI)getSource()).onMouseDown(X, Y, Buttons, Flags);
		}
	}

	public static class OnMouseUpInputEvent extends BaseInputEvent {
		private int X;
		private int Y;
		//MouseButton Buttons;
		private int Buttons;
		private int Flags;
		public OnMouseUpInputEvent(BaseWindowNI win, int x, int y, int buttons, int flags) {
			super(win, ++InputEventTagMax);
			X = x;
			Y = y;
			Buttons = buttons;
			Flags = flags;
		}
		public void deliver() throws TJSException {
			((BaseWindowNI)getSource()).onMouseUp(X, Y, Buttons, Flags);
		}
	}

	public static class OnMouseMoveInputEvent extends BaseInputEvent {
		int X;
		int Y;
		int Flags;
		public OnMouseMoveInputEvent(BaseWindowNI win, int x, int y, int flags) {
			super(win, ++InputEventTagMax);
			X = x;
			Y = y;
			Flags = flags;
		}
		public void deliver() throws TJSException
		{ ((BaseWindowNI)getSource()).onMouseMove(X, Y, Flags); }
	}

	public static class OnReleaseCaptureInputEvent extends BaseInputEvent {
		public OnReleaseCaptureInputEvent(BaseWindowNI win) {
			super(win, ++InputEventTagMax);
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onReleaseCapture(); }
	}

	public static class OnMouseOutOfWindowInputEvent extends BaseInputEvent {
		public OnMouseOutOfWindowInputEvent(BaseWindowNI win) {
			super(win, ++InputEventTagMax);
		}
		public void deliver() throws TJSException
		{ ((BaseWindowNI)getSource()).onMouseOutOfWindow(); }
	}

	public static class OnMouseEnterInputEvent extends BaseInputEvent {
		public OnMouseEnterInputEvent(BaseWindowNI win) {
			super(win, ++InputEventTagMax);
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onMouseEnter(); }
	}

	public static class OnMouseLeaveInputEvent extends BaseInputEvent {
		public OnMouseLeaveInputEvent(BaseWindowNI win) {
			super(win, ++InputEventTagMax);
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onMouseLeave(); }
	}

	public static class OnKeyDownInputEvent extends BaseInputEvent {
		int Key;
		int Shift;
		public OnKeyDownInputEvent(BaseWindowNI win, int key, int shift) {
			super(win, ++InputEventTagMax);
			Key = key;
			Shift = shift;
		}
		public void deliver() throws TJSException
		{ ((BaseWindowNI)getSource()).onKeyDown(Key, Shift); }
	}

	public static class OnKeyUpInputEvent extends BaseInputEvent {
		int Key;
		int Shift;
		public OnKeyUpInputEvent(BaseWindowNI win, int key, int shift) {
			super(win, ++InputEventTagMax);
			Key = key;
			Shift = shift;
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onKeyUp(Key, Shift); }
	}

	public static class OnKeyPressInputEvent extends BaseInputEvent {
		char Key;
		public OnKeyPressInputEvent(BaseWindowNI win, char key) {
			super(win, ++InputEventTagMax);
			Key = key;
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onKeyPress(Key); }
	}

	public static class OnFileDropInputEvent extends BaseInputEvent {
		Variant Array;
		public OnFileDropInputEvent(BaseWindowNI win, final Variant val) {
			super(win, ++InputEventTagMax);
			Array = new Variant(val);
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onFileDrop(Array); }
	}

	public static class OnMouseWheelInputEvent extends BaseInputEvent {
		int Shift;
		int WheelDelta;
		int X;
		int Y;
		public OnMouseWheelInputEvent(BaseWindowNI win, int shift, int wheeldelta, int x, int y) {
			super(win, ++InputEventTagMax);
			Shift = shift;
			WheelDelta = wheeldelta;
			X = x;
			Y = y;
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onMouseWheel(Shift, WheelDelta, X, Y); }
	}

	public static class OnPopupHideInputEvent extends BaseInputEvent {
		public OnPopupHideInputEvent(BaseWindowNI win) {
			super(win, ++InputEventTagMax);
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onPopupHide(); }
	}

	public static class OnWindowActivateEvent extends BaseInputEvent {
		boolean ActivateOrDeactivate;
		public OnWindowActivateEvent(BaseWindowNI win, boolean activate_or_deactivate) {
			super(win, ++InputEventTagMax);
			ActivateOrDeactivate = activate_or_deactivate;
		}
		public void deliver()
		{ ((BaseWindowNI)getSource()).onActivate(ActivateOrDeactivate); }
	}



	public static class OnMenuItemClickInputEvent extends BaseInputEvent {
		public OnMenuItemClickInputEvent( MenuItemNI menu ) {
			super(menu, ++InputEventTagMax);
		}
		public void deliver() {
			((MenuItemNI)getSource()).onClick();
		}
	}
}
