package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;

public class PluginsClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "Plugins";

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public PluginsClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "link", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "unlink", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getList", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );
	}

}
