package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.base.EventManager;

public class MenuItemClass extends NativeClass {

	static public int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "MenuItem";

	private static MenuItemNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (MenuItemNI) holder.mValue;
	}

	protected NativeInstance createNativeInstance() {
		return new MenuItemNI();
	}

	public MenuItemClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "add", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1) return E_BADPARAMCOUNT;
				MenuItemNI item = MenuItemNI.castFromVariant(param[0]);
				_this.add(item);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "insert", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 2) return E_BADPARAMCOUNT;
				MenuItemNI item = MenuItemNI.castFromVariant(param[0]);
				int index = param[1].asInteger();
				_this.insert(item, index);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "remove", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				MenuItemNI item = MenuItemNI.castFromVariant(param[0]);
				_this.remove(item);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "popup", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 3 ) return E_BADPARAMCOUNT;
				int flags = param[0].asInteger();
				int x = param[1].asInteger();
				int y = param[2].asInteger();
				int rv = _this.trackPopup(flags, x, y);
				if( result != null ) result.set( rv );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		// event
		registerNCM( "onClick", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				VariantClosure obj = _this.getActionOwner();
				Dispatch2 evobj = EventManager.createEventObject( "onClick", objthis, objthis );
				Variant[] pevval = new Variant[1];
				pevval[0] = new Variant(evobj, evobj);
				obj.funcCall( 0, EventManager.ActionName, result, pevval, null );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "caption", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCaption() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setCaption( param.asString() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "checked", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getChecked() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setChecked( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "enabled", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getEnabled() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setEnabled( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "group", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getGroup() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setGroup( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "radio", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getRadio() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setRadio( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "shortcut", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getShortcut() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setShortcut( param.asString() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "visible", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getVisible() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setVisible( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "parent", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				MenuItemNI parent = _this.getParent();
				if(parent!=null) {
					Dispatch2 dsp = parent.getOwner();
					result.set( dsp, dsp );
				} else {
					result.set(null,null);
				}
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "children", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) throws VariantException, TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.getChildrenArray();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "root", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				MenuItemNI root = _this.getRootMenuItem();
				if(root!=null) {
					Dispatch2 dsp = root.getOwner();
					result.set( dsp, dsp );
				} else {
					result.set(null,null);
				}
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "window", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				WindowNI window = _this.getWindow();
				if(window!=null) {
					Dispatch2 dsp = window.getOwner();
					result.set( dsp, dsp );
				} else {
					result.set(null,null);
				}
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "index", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getIndex() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws TJSException {
				MenuItemNI _this = (MenuItemNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setIndex( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "HMENU", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( -1 ); // 常に無効ハンドル
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );
	}

}
