﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;

namespace fusen
{
    public interface IFusenStore
    {
        IList<Fusen> Load();
        void Save(IList<Fusen> fusens);
    }

    class FusenStore : IFusenStore
    {
        private IFusenPath fusenPath;

        public FusenStore(IFusenPath fusenPath)
        {
            this.fusenPath = fusenPath;
        }

        public IList<Fusen> Load()
        {
            string filename = fusenPath.FusenFilename;
            if (!File.Exists(filename))
                return new Fusen[0];
            using (Stream stream = File.OpenRead(filename)) {
                var bf = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                return (List<Fusen>)bf.Deserialize(stream);
            }
        }

        public void Save(IList<Fusen> fusens)
        {
            string folder = fusenPath.DataFolder;
            if (!Directory.Exists(folder)) {
                Directory.CreateDirectory(folder);
            }
            string filename = fusenPath.FusenFilename;
            using (Stream stream = File.Create(filename)) {
                var bf = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                bf.Serialize(stream, fusens);
            }
        }
    }

    [Serializable]
    public class Fusen
    {
        public string Text { get; set; }
        public int Left { get; set; }
        public int Top { get; set; }
        public int Width { get; set; }
        public int Height { get; set; }
    }
}
