﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace fusen
{
    public partial class FusenForm : Form
    {
        private IFusenLog common;
        private System.Action saveText;
        private bool textChanged;

        public FusenForm(IFusenLog common, System.Action saveText)
        {
            InitializeComponent();
            this.common = common;
            this.saveText += saveText;
            this.textChanged = false;
        }

        public string getMemo()
        {
            return textBox.Text;
        }
        public void setMemo(string text)
        {
            textBox.Text = text;
        }

        private void FusenForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing) {
                if (textBox.Text != "")
                    common.OutputLog(textBox.Text);
            }
        }

        private void FusenForm_Deactivate(object sender, EventArgs e)
        {
            if (textChanged) {
                saveText();
                textChanged = false;
            }
        }

        private void textBox_TextChanged(object sender, EventArgs e)
        {
            textChanged = true;
        }
    }
}
