﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace fusen
{
    public interface IFusenLog
    {
        void OutputLog(string memo);
        void ShowLog();
    }

    class FusenLog : IFusenLog
    {
        private IFusenPath fusenPath;

        public FusenLog(IFusenPath fusenPath)
        {
            this.fusenPath = fusenPath;
        }

        public void OutputLog(string memo)
        {
            string folder = fusenPath.DataFolder;
            if (!Directory.Exists(folder)) {
                Directory.CreateDirectory(folder);
            }
            string filename = fusenPath.FusenLogFilename;
            string[] lines = memo.Split('\n');
            using (StreamWriter write = File.AppendText(filename)) {
                write.WriteLine(DateTime.Now.ToString());
                write.WriteLine(lines.Length);
                write.WriteLine(string.Join(Environment.NewLine, lines));
                write.WriteLine("--");
            }
        }

        public void ShowLog()
        {
            string filename = fusenPath.FusenLogFilename;
            if (File.Exists(filename))
                System.Diagnostics.Process.Start(filename);
        }
    }
}
