﻿#!/usr/bin/perl

#┌─────────────────────────────────
#│ wforum.cgi - 2006/01/03
#│ Copyright (c) KentWeb
#│ webmaster@kent-web.com
#│ http://www.kent-web.com/
#└─────────────────────────────────

# 外部ファイル取込み
require './jcode.pl';
require './fold.pl';
require './wf_init.cgi';

# 基本処理を定義
&decode;
&axsCheck;
if ($mode eq "msgview") { &msgview; }
elsif ($mode eq "allread") { &allread; }
elsif ($mode eq "newsort") { &newsort; }
elsif ($mode eq "find") { &find; }
elsif ($mode eq "note") { &note; }
elsif ($mode eq "past") { &past_view; }
elsif ($mode eq "check") { &check; }
&list_view;

#---------------------------------------
#  リスト表示
#---------------------------------------
sub list_view {
	&HEADER;
	print "<div align=\"center\">\n";

	# タイトル部
	if ($t_img) {
		print "<img src=\"$t_img\" alt=\"$title\" width=\"$t_w\" height=\"$t_h\">\n";
	} else {
		print "<b style=\"font-size:$t_point;color:$t_color\">$title</b>\n";
	}

	print <<EOM;
<hr width="90%">
[<a href="$home" target="_top">トップに戻る</a>]
[<a href="$script?mode=note">留意事項</a>]
[<a href="#msg">新規投稿</a>]
EOM

	if ($in{'list'} ne "new") {
		print "[<a href=\"$script?list=new\">新規順表\示</a>]\n";
	} else {
		print "[<a href=\"$script?list=tree\">ツリー表\示</a>]\n";
	}
	$in{'list'} ||= 'tree';

	print <<EOM;
[<a href="$script?mode=newsort&page=$page">新着記事</a>]
[<a href="$script?mode=find&page=$page&list=$in{'list'}">ワード検索</a>]
EOM

	print "[<a href=\"$script?mode=past\">過去ログ</a>]\n" if ($pastkey);

	print <<EOM;
[<a href="$admin">管理用</a>]
<hr width="90%">
<table><tr><td>
<li>～$new_time時間→ $newmark ～$new_time2時間→ $newmark2 ～$new_time3時間→ $newmark3</li><br>
<li>スパム防止のため三国志NET KMY Version登録者しか投稿できません。</li><br>
EOM

	if ($in{'list'} eq "new") {
		print "<li>以下は新規投稿順のリスト表\示です。</li><br>\n";
	} else {
		print "<li>ツリー先頭部の $treehead をクリックすると関連記事を一括表\示します。</li><br>\n";
	}
	print "</td></tr></table></div>\n";

	# ログを開く
	if ($in{'list'} eq "new") { &ListNewOpen; }
	else { &ListTreeOpen; }

	# ページ移動フォーム
	&move_list;

	# メッセージ投稿フォ－ムを表示
	&msg_form;

	# 著作権表示（削除禁止）
	print <<EOM;
<p><!-- $ver -->
<div align="center" style="font-size:10px; font-family:Verdana,Helvetica,Arial">
- <a href="http://www.kent-web.com/" target="_top">Web Forum</a> -
</div>
EOM
	&FOOTER;
	exit;
}

#---------------------------------------
#  リストツリー表示
#---------------------------------------
sub ListTreeOpen {
	local($no,$reno,$lx,$sub,$email,$url,$name,$dat,$msg,$t,$h,$pw,$w,$oya);

	# 時間取得
	$time = time;

	if ($mode ne "past") { print "<DL>\n"; }
	print "<ul>\n";

	$i = 0;
	$x = 0;
	open(IN,"$logfile") || &error("Open Error: $logfile");
	if ($mode ne "past") { $top = <IN>; }
	while (<IN>) {
		($no,$reno,$lx,$sub,$email,$url,$name,$dat,$msg,$t,$h,$pw,$w,$oya) = split(/<>/);

		if ($reno == 0) { $i++; }
		if ($i < $page + 1) { next; }
		if ($i > $page + $p_tree) { next; }

		while ($x > $lx) { print "</ul>\n"; $x--; }
		while ($x < $lx) { print "<ul>\n"; $x++; }

		if ($reno == 0) { while ($x > 0) { print "</ul>\n"; $x--; } }

		# 所定時間以内の投稿は[NEWマーク]表示
		if ($time - $t < $new_time * 3600) { $newsign = $newmark; }
		elsif ($time - $t < $new_time2 * 3600) { $newsign = $newmark2; }
		elsif ($time - $t < $new_time3 * 3600) { $newsign = $newmark3; }
		else { $newsign = ""; }

		# 記事タイトル長調整
		$sub = &cut_subject($sub);

		# 過去記事
		if ($mode eq "past") {
			print "<li><a href=\"$script?mode=allread&pastlog=$in{'pastlog'}&no=$oya&page=$page&act=past\#$no\"><font color=brown>$sub</font></a> - $newsign<b>$name</b> $dat <font color=\"$no_color\">No\.$no</font>\n";
		# 削除記事
		} elsif ($pw eq 'DEL') {
			if ($lx == 0) {
				print "<P><DT><a href=\"$script?mode=allread&no=$no&page=$page\">$treehead</a> - ";
				print "$sub - $dat <font color=\"$no_color\">No\.$no</font>\n";
			} else {
				print "<li>$sub - $dat <font color=\"$no_color\">No\.$no</font>\n";
			}
		# レス記事
		} elsif ($lx != 0) {
			print "<li><a href=\"$script?no=$no&reno=$reno&oya=$oya&mode=msgview&page=$page\"><font color=brown>$sub</font></a> - <b>$name</b> $dat <font color=\"$no_color\">No\.$no</font> $newsign\n";

		# 親記事
		} else {
			print "<P><DT><a href=\"$script?mode=allread&no=$no&page=$page\"><font color=red><b>$treehead</b></font></a> - ";
			print "<a href=\"$script?no=$no&reno=$reno&oya=$oya&mode=msgview&page=$page\"><font color=red><b>$sub</b></font></a> - <b>$name</b> $dat <font color=\"$no_color\">No\.$no</font> $newsign\n";
		}

	}
	close(IN);

	while ($x > 0) { print "</ul>\n"; $x--; }
	print "</ul>\n";
	if ($mode ne "past") { print "</DL>\n"; }
}

#---------------------------------------
#  リスト新着順
#---------------------------------------
sub ListNewOpen {
	local($no,$reno,$xl,$sub,$email,$url,$name,$date,$msg,$tim,$h,$pw,$wrap,$oya);

	# 時間取得
	$time = time;

	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		($no,$reno,$xl,$sub,$email,$url,$name,$date,$msg,$tim,$h,$pw,$wrap,$oya) = split(/<>/);
		$cnt{$no} = $tim;
		$rno{$no} = $reno;
		$dat{$no} = $date;
		$nam{$no} = $name;
		$sub{$no} = $sub;
		$oya{$no} = $oya;
	}
	close(IN);

	print "<ul>\n";

	# ソート処理
	$i=0;
	$x=0;
	$p_tree *= 3;
	foreach (sort { ($cnt{$b} <=> $cnt{$a}) } keys(%cnt)) {
		$i++;
		if ($i < $page + 1) { next; }
		if ($i > $page + $p_tree) { next; }

		# 所定時間以内の投稿は[NEWマーク]表示
		if ($time - $cnt{$_} > $new_time * 3600) { $newsign = ""; }
		else { $newsign = $newmark; }

		if ($sub{$_} eq '<s>投稿者削除</s>') {
			print "<li>$sub{$_} - $dat{$_} <font color=\"$no_color\">No\.$_</font> $newsign\n";
		} else {
			print "<li><a href=\"$script?no=$_&reno=$rno{$_}&oya=$oya{$_}&mode=msgview&list=new\">$sub{$_}</a> - <b>$nam{$_}</b> $dat{$_} <font color=\"$no_color\">No\.$_</font> $newsign\n";
		}
	}
	print "</ul>\n";
}

#---------------------------------------
#  記事閲覧
#---------------------------------------
sub msgview {
	local($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$lt,$ho,$pw,$wrap,$oya,$sml,$v_dat,$v_nam,$v_eml,$v_url,$v_msg,$v_tim,$v_sub,$v_wrp,$v_sml,$date);

	$flag = 0;
	@new = ();
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$lt,$ho,$pw,$wrap,$oya,$sml) = split(/<>/);
		if ($in{'oya'} == $oya) { push(@new,$_); }
		elsif ($flag && $in{'oya'} != $oya) { last; }
		if ($in{'no'} == $no) {
			$flag=1;
			$v_dat = $dat;
			$v_nam = $nam;
			$v_eml = $eml;
			$v_url = $url;
			$v_msg = $msg;
			$v_tim = $lt;
			$v_sub = $sub;
			$v_wrp = $wrap;
			$v_sml = $sml;
		}
	}
	close(IN);

	# レスメッセージ
	$res_msg = "\n&gt; $v_msg";
	$res_msg =~ s/"/&quot;/g;
	$res_msg =~ s/<br>/\r&gt; /g;

	# レスタイトル
	$res_sub = $v_sub;
	if ($res_sub =~ /^Re\^(\d+)\:(.*)/) {
		$renum = $1 + 1;
		$res_sub = "Re\^$renum\:$2";
	}
	elsif ($res_sub =~ /^Re\:(.*)/) { $res_sub = "Re\^2:$1"; }
	else { $res_sub = "Re: $res_sub"; }

	# HTMLを出力
	&HEADER;
	print "<div align=\"center\">\n";
	if ($t_img) {
		print "<img src=\"$t_img\" alt=\"$title\" width=\"$t_w\" height=\"$t_h\">\n";
	} else {
		print "<b style=\"font-size:$t_point;color:$t_color\">$title</b>\n";
	}

	print <<EOM;
<hr width="90%">
[<a href="$script?page=$page&list=$in{'list'}">記事リスト</a>]
[<a href="$script?mode=newsort">新着記事</a>]
[<a href="$script?mode=find">ワード検索</a>]
EOM

	print "[<a href=\"$script?mode=past\">過去ログ</a>]\n" if ($pastkey);
	print "[<a href=\"$admin\">管理用</a>]<hr width=\"90%\"></div>\n";

	# 自動リンク
	if ($autolink) { $v_msg = &auto_link($v_msg); }
#	$v_msg =~ s/"/&quot;/g;

	# 引用部色変更
	if ($refcol) {
		$v_msg =~ s/([\>]|^)(&gt;[^<]*)/$1<font color=\"$refcol\">$2<\/font>/g;
	}

	# PREタグ
	if ($v_wrp eq 'pre') {
		$v_msg =~ s/<br>/\n/g;
		$v_msg = "<pre>$v_msg</pre>";
	}

	# 投稿日時
	$date = &get_time($v_tim);

	print <<EOM;
<p><table cellspacing=0>
<tr>
  <td>タイトル</td>
  <td>： <b><font color="$sub_color">$v_sub</font></b></td>
</tr>
<tr>
  <td>投稿日</td><td>： $date</td>
</tr>
<tr>
  <td>投稿者</td><td>： <b>$v_nam</b>
EOM

	if ($v_eml && $v_sml eq '0') {
		print "&nbsp; &lt;<a href=\"mailto:$v_eml\" class=num>$v_eml</a>&gt;";
	}
	print "</td></tr>\n";
	if ($v_url) {
		unless ($v_url =~ m|https?://|) { $v_url = "http://$v_url"; }
		print "<tr><td>参照先</td><td>： ";
		print "<a href=\"$v_url\" target=\"_blank\">$v_url</a></td></tr>\n";
	}
	print "</table><blockquote>$v_msg</blockquote><p>\n";

	if (@new > 1) {
		print "<hr width='95%'><b style='text-indent:18'>- 関連一覧ツリー</b>\n";
		print "（$treehead をクリックするとツリー全体を一括表\示します）<br>\n";

		$x=0;
		print "<ul>\n";
		foreach (@new) {
			($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$lt,$ho,$pw,$wrap,$oya,$sml) = split(/<>/);
			while ($x > $lx) { print "</ul>\n"; $x--; }
			while ($x < $lx) { print "<ul>\n"; $x++; }

			# 記事タイトル長調整
			$sub = &cut_subject($sub);

			if ($lx != 0) {
				print "<li><a href=\"$script?no=$no&reno=$re&oya=$oya&mode=msgview&page=$page\"><font color=brown>$sub</font></a> - <B>$nam</B> $dat ";
			} else {
				print "<a href=\"$script?mode=allread&no=$no&page=$page\"><font color=red><b>$treehead</b></font></a> - <a href=\"$script?no=$no&reno=$re&oya=$oya&mode=msgview&page=$page\"><font color=red><b>$sub</b></font></a> - <B>$nam</B> $dat";
			}

			if ($in{'no'} == $no) {
				print "<font color=\"$sub_color\"><B>No\.$no</B></font>\n";
			} else {
				print "<font color=\"$no_color\">No\.$no</font>\n";
			}
		}
		while ($x > 0) { print "</ul>\n"; $x--; }
		print "</ul>\n";
	}

	# 返信フォーム
	&msg_form;
	&FOOTER;
	exit;
}

#---------------------------------------
#  一括表示
#---------------------------------------
sub allread {
	local($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wrap,$oya,$sml,$date);

	# HTMLを出力
	&HEADER;
	print <<EOM;
[<a href="$script?page=$page&mode=$in{'act'}">リストへもどる</a>]<br>
<table width="100%"><tr>
<th class="obi">一括表\示</th>
</tr></table>
EOM

	# 過去ログの場合
	if ($in{'act'} eq "past") {
		# ログファイルを定義
		if ($in{'pastlog'}) {
			$count = $in{'pastlog'};
		} else {
			open(NO,"$nofile") || &error("Open Error: $nofile");
			$count = <NO>;
			close(NO);
		}
		$logfile = sprintf("%s%04d\.cgi", $pastdir,$count);
	}

	# 親記事を出力
	$x=0;
	$atfirst=0;
	print "<ul>\n";
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN> if ($in{'act'} ne "past");
	$flag = 0;
	while (<IN>) {
		($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wrap,$oya) = split(/<>/);
		if ($in{'no'} == $oya) {
			$flag=1;
			push(@new,$_);

			while ($x > $lx) { print "</ul>\n"; $x--; }
			while ($x < $lx) { print "<ul>\n"; $x++; }

			# 記事タイトル長調整
			$sub = &cut_subject($sub);

			if ($pw eq 'DEL') {
				print "<li>$sub - $dat <font color=\"$no_color\">No\.$no</font>\n";
			} elsif ($atfirst==0) {
				print "<li><a href=\"#$no\"><font color=red><b>$sub</b></font></a> - <B>$nam</B> $dat <font color=\"$no_color\">No\.$no</font>\n";
				$atfirst = 1;
			} else {
				print "<li><a href=\"#$no\"><font color=brown>$sub</font></a> - <B>$nam</B> $dat <font color=\"$no_color\">No\.$no</font>\n";
			}
		}
		elsif ($flag && $in{'no'} != $oya) { last; }
	}
	close(IN);

	while ($x > 0) { print "</ul>\n"; $x--; }
	print "</ul><div align='center'>\n";

	foreach (@new) {
		($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wrap,$oya,$sml) = split(/<>/);
		if ($pw eq 'DEL') { next; }

		# 自動リンク
		if ($autolink) { $msg = &auto_link($msg); }
#		$msg =~ s/"/&quot;/g;

		# 引用部色変更
		if ($refcol) {
			$msg =~ s/([\>]|^)(&gt;[^<]*)/$1<font color=\"$refcol\">$2<\/font>/g;
		}
		# 図表モード
		if ($wrap eq 'pre') {
			$msg =~ s/<br>/\n/g;
			$msg = "<pre>$msg</pre>";
		}

		$date = &get_time($t);
		print "<a name=\"$no\"></a>\n";
		print "<table width=\"95%\" cellpadding=\"5\">\n";
		print "<tr><td><table cellspacing=\"0\">";
		print "<tr><td>タイトル</td><td>： ";
		print "<b style=\"color:$sub_color\">$sub</b></td></tr>\n";
		print "<tr><td>記事No</td><td>： <b>$no</b></td></tr>\n";
		print "<tr><td>投稿日</td><td>： $date</td></tr>\n";
		print "<tr><td>投稿者</td><td>： <b>$nam</b>";

		if ($eml && $sml eq '0') {
			print "&nbsp; &lt;<a href=\"mailto:$eml\" class=num>$eml</a>&gt;";
		}

		print "</td></tr>\n";
		if ($url) {
			unless ($url =~ m|https?://|) { $url = "http://$url"; }
			print "<tr><td>参照先</td><td>： ";
			print "<a href=\"$url\" target=\"_blank\">";
			print "$url</a></td></tr>\n";
		}
		print "</table><blockquote>$msg</blockquote>\n";
		if ($in{'act'} ne "past") {
			print "<div>\n";
			print "<form action=\"$script\#msg\" method=\"post\">\n";
			print "<input type=\"hidden\" name=\"mode\" value=msgview>\n";
			print "<input type=\"hidden\" name=\"reno\" value=\"$re\">\n";
			print "<input type=\"hidden\" name=\"no\" value=\"$no\">\n";
			print "<input type=\"hidden\" name=\"oya\" value=\"$oya\">\n";
			print "<input type=\"hidden\" name=\"page\" value=\"$page\">\n";
			print "<input type=\"submit\" value=\"返信する\"></form></div>\n";
		}
		print "</td></tr></table><hr>\n";
	}
	print "</div>\n";
	&FOOTER;
	exit;
}

#---------------------------------------
#  新着順ソート表示
#---------------------------------------
sub newsort {
	local($no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$tim,$ho,$pw,$wrp,$oya,$sml,$date);

	&HEADER;
	print <<EOM;
[<a href="$script?page=$page">リストへもどる</a>]
<table width="100%"><tr>
<th class="obi">新着記事</th>
</tr></table>
<br><div align="center">
EOM

	# 記事展開
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		($no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$tim,$ho,$pw,$wrp,$oya,$sml) = split(/<>/);
		if ($pw eq 'DEL') { next; }

		# 連想配列化
		$cnt{$no} = $tim;
		$nam{$no} = $nam;
		$eml{$no} = $eml;
		$url{$no} = $url;
		$rno{$no} = $re;
		$sub{$no} = $sub;
		$oya{$no} = $oya;
		$msg{$no} = $msg;
		$wrp{$no} = $wrp;
		$sml{$no} = $sml;
	}
	close(IN);

	# ソート処理
	$i=0;
	foreach (sort { ($cnt{$b} <=> $cnt{$a}) } keys(%cnt)) {
		$i++;
		if ($i > $sortcnt) { last; } # ループを抜ける

		if ($autolink) { $msg{$_} = &auto_link($msg{$_}); }
#		$msg{$_} =~ s/"/&quot;/g;
		if ($refcol) {
			$msg{$_} =~ s/([\>]|^)(&gt;[^<]*)/$1<font color=\"$refcol\">$2<\/font>/g;
		}
		# PRE機能
		if ($wrp{$_} eq "pre") {
			$msg{$_} =~ s/<br>/\n/g;
			$msg{$_} = "<pre>$msg{$_}</pre>";
		}

		$date = &get_time($cnt{$_});

		print "<table border=\"1\" width=\"95%\" cellpadding=\"5\">\n";
		print "<tr><td bgcolor=\"$tbl_color\">\n";
		print "<table cellspacing=\"0\">";
		print "<tr><td>タイトル</td><td>： ";
		print "<font color=\"$sub_color\"><b>$sub{$_}</b></font></td></tr>";
		print "<tr><td>記事No</td><td>： <b>$_</b> &nbsp;&nbsp;";
		print "[<a href=\"$script?mode=allread&no=$oya{$_}\">関連記事</a>]</td></tr>\n";
		print "<tr><td>投稿日</td><td>： $date</td></tr>\n";
		print "<tr><td>投稿者</td><td>： <b>$nam{$_}</b> ";

		if ($eml{$_} && $sml{$_} eq '0') {
			print "&nbsp; &lt;<a href=\"mailto:$eml{$_}\" class=num>";
			print "$eml{$_}</a>&gt;";
		}
		print "</td></tr>\n";

		if ($url{$_}) {
			unless ($url{$_} =~ m|https?://|) { $url{$_} = "http://$url{$_}"; }
			print "<tr><td>参照先</td><td>： ";
			print "<a href=\"$url{$_}\" target=\"_blank\">";
			print "$url{$_}</a></td></tr>\n";
		}

		print "</table><blockquote>$msg{$_}</blockquote>\n";
		print "<div align=\"right\">\n";
		print "<form action=\"$script\#msg\" method=\"post\">\n";
		print "<input type=\"hidden\" name=\"mode\" value=msgview>\n";
		print "<input type=\"hidden\" name=\"reno\" value=\"$rno{$_}\">\n";
		print "<input type=\"hidden\" name=\"no\" value=\"$_\">\n";
		print "<input type=\"hidden\" name=\"oya\" value=\"$oya{$_}\">\n";
		print "<input type=\"hidden\" name=\"page\" value=\"$page\">\n";
		print "<input type=\"submit\" value=\"返信する\"></div></form>\n";
		print "</td></tr></table><br>\n";
	}
	print "</div>\n";
	&FOOTER;
	exit;
}

#---------------------------------------
#  留意事項
#---------------------------------------
sub note {
	&HEADER;
	print <<EOM;
<table width="100%"><tr>
<th class="obi">留意事項</th>
</tr></table>
<P>
<b style="text-indent:10">- 投稿する上での注意事項 -</b>
<P>
<ul>
<li>投稿する上での必須入力項目は<b>「ログインＩＤ」「ログインパス」「タイトル」「メッセージ」</b>です。その他の項目は任意となります。
<li>投稿記事の最大保持件数は <b>$max</b>件で、それを超えると古い記事から削除されます。
<li>投稿メッセージでは、<b>HTMLタグの使用はできません。</b>
<li>管理者が著しく不利益と判断する記事や他人を誹謗中傷する記事は予\告なく削除することがあります。
<li>スパム防止のため三国志NET KMY Version登録者しか投稿できません。
<li>登録していない人で管理者に何か言いたい時は、<a href="http://tukimi.ddo.jp/~kmy/" target="_blank">KMYpage</a>のメールより。
</ul>
<P>
<b style="text-indent:10">- 掲示板の使い方 -</b>
<P>
<ul>
<li>この掲示板はツリー式掲示板です。どなたかが投稿した記事に対し、簡単に返信メッセージを付けることができます。
<li>新規の記事投稿はリスト下の「投稿フォーム」から送信して下さい。
<li>記事を読むには、リスト部にある<b>「題名」</b>をクリックすると内容が表\示されます。またその記事に<b>レス</b>を付けるには、「メッセージ表\示画面」下部の返信用投稿フォームから送信して下さい。
<li>投稿された記事は、$new_time時間以内はリスト部に $newmark で表\示されます。
<li>リスト部にて、ツリー先頭部の ★ をクリックすると関連記事も同時に一括表\示されます。
<li>メッセージフォーム内の投稿書式には以下の3方法があり、それぞれに適応するラジオボタンを選択します。
  <DL>
  <DT><b>「手動改行」</b>
  <DD>フォーム内の改行位置は、ご自分で適宜改行します。
  <DT><b>「強制改行」</b>
  <DD>フォーム内の改行位置は、フォーム枠の右端で強制的に改行処理します。
  <DT><b>「図表\モード」</b>
  <DD>フォーム内の改行位置や半角スペース位置などをそのままの状態で表\示します。罫線等を使って簡易的な図表\を記述するのに便利です。（HTMLでの&lt;PRE&gt;タグで囲む機能\）
  </DL>
</ul>
</OL>
<hr>
<P>
<center>
<form>
<input type="button" value="記事リストに戻る" onclick="history.back()">
</form>
</center>
EOM
	&FOOTER;
	exit;
}

#---------------------------------------
#  検索フォーム
#---------------------------------------
sub find {
	&HEADER;
	print <<EOM;
[<a href="$script?page=$page&list=$in{'list'}">リストへもどる</a>]
<table width="100%"><tr>
<th class="obi">ワード検索</th>
</tr></table>
<p><a name="SEARCH"></a>
<ul>
<li>検索したいキーワードを入力し、検索条件を選択して「検索」を押してください。
<li>複数のキーワードを入力するときはスペースで区切って下さい。
<form action="$script" method="get">
<input type="hidden" name="mode" value="find">
<input type="hidden" name="list" value="$in{'list'}">
キーワード：<input type="text" name="word" size="35" value="$in{'word'}">
条件：<select name="cond">
EOM

	foreach ('AND', 'OR') {
		if ($in{'cond'} eq $_) {
			print "<option value=\"$_\" selected>$_\n";
		} else {
			print "<option value=\"$_\">$_\n";
		}
	}
	print "</select> 表\示：<select name=\"view\">\n";
	foreach (10,15,20,25,30) {
		if ($in{'view'} == $_) {
			print "<option value=\"$_\" selected>$_件\n";
		} else {
			print "<option value=\"$_\">$_件\n";
		}
	}

	print "</select>\n<input type=\"submit\" value=\" 検索 \"></form>\n</ul>\n";

	# ワード検索の実行と結果表示
	if ($in{'word'} ne "") { &search; }

	&FOOTER;
	exit;
}

#---------------------------------------
#  検索実行
#---------------------------------------
sub search {
	local($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya,$sml,$back,$next);

	# 入力内容を整理
	$in{'word'} =~ s/\x81\x40/ /g;
	@wd = split(/\s+/, $in{'word'});

	# ロック処理：サーバ負荷を考慮し多重起動回避のため
	&lock if ($lockkey);

	# ファイルを読み込み
	$i = 0;
	@new = ();
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN> if ($mode ne "past");
	while (<IN>) {
		$flag = 0;
		foreach $wd (@wd) {
			if (index($_,$wd) >= 0) {
				$flag = 1;
				if ($in{'cond'} eq 'OR') { last; }
			} else {
				if ($in{'cond'} eq 'AND') { $flag=0; last; }
			}
		}
		if ($flag) {
			$i++;
			next if ($i < $page + 1);
			next if ($i > $page + $in{'view'});

			($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya,$sml) = split(/<>/);

			if ($w eq "pre") {
				$msg =~ s/<br>/\r/g;
				$msg = "<pre>$msg</pre>";
			}
			if ($autolink) { $msg = &auto_link($msg); }
#			$msg =~ s/"/&quot;/g;
			if ($refcol) {
				$msg =~ s/([\>]|^)(&gt;[^<]*)/$1<font color=\"$refcol\">$2<\/font>/g;
			}
			$date = &get_time($t);
			print "<hr><table cellspacing=\"0\">\n";
			print "<tr><td>タイトル</td><td>： ";
			print "<font color=\"$sub_color\"><b>$sub</b></font></td></tr>\n";
			print "<tr><td>記事No</td><td>： <b>$no</b> &nbsp;&nbsp;";
			if ($in{'pastlog'}) {
				print "[<a href=\"$script?mode=allread&no=$oya&pastlog=$in{'pastlog'}&act=past\">関連記事</a>]</td></tr>\n";
			} else {
				print "[<a href=\"$script?mode=allread&no=$oya\">関連記事</a>]</td></tr>\n";
			}
			print "<tr><td>投稿日</td><td>： $date</td></tr>\n";
			print "<tr><td>投稿者</td><td>： <b>$nam</b> ";
			if ($eml && $sml eq '0') {
				print "&nbsp; &lt;<a href=\"mailto:$eml\" class=num>$eml</a>&gt;";
			}
			print "</td></tr>\n";
			if ($url) {
				unless ($url =~ m|https?://|) { $url = "http://$url"; }
				print "<tr><td>参照先</td><td>： ";
				print "<a href=\"$url\" target=\"_blank\">$url</a></td></tr>\n";
			}
			print "</table><blockquote>$msg</blockquote>\n";
		}
	}
	close(IN);

	# 検索終了
	print "<hr>検索結果：<b>$i</b>件\n";
	$next = $page + $in{'view'};
	$back = $page - $in{'view'};
	$enwd = &url_enc($in{'word'});

	if ($back >= 0) {
		print "[<a href=\"$script?mode=$mode&page=$back&word=$enwd&view=$in{'view'}&cond=$in{'cond'}&pastlog=$in{'pastlog'}\">前の$in{'view'}件</a>]\n";
	}
	if ($next < $i) {
		print "[<a href=\"$script?mode=$mode&page=$next&word=$enwd&view=$in{'view'}&cond=$in{'cond'}&pastlog=$in{'pastlog'}\">次の$in{'view'}件</a>]\n";
	}

	if ($i) { print "<P><a href=\"#SEARCH\">▲TOP</a>\n"; }

	# ロック解除
	&unlock if ($lockkey);
}

#---------------------------------------
#  自動リンク
#---------------------------------------
sub auto_link {
	local($_) = @_;

	s/([^=^\"]|^)(https?\:\/\/[\w\.\~\-\/\?\&\=\;\#\:\%\+\@]+)/$1<a href="$2" target="_blank">$2<\/a>/g;
	$_;
}

#---------------------------------------
#  過去ログ表示
#---------------------------------------
sub past_view {
	open(IN,"$nofile") || &error("Open Error: $nofile");
	$pastno = <IN>;
	close(IN);

	$pastno = sprintf("%04d", $pastno);
	if (!$in{'pastlog'}) { $in{'pastlog'} = $pastno; }

	&HEADER;
	print <<"EOM";
[<a href="$script?">掲示板に戻る</a>]
<table width="100%"><tr>
<th class="obi">過去ログ [ $in{'pastlog'} ]</th>
</tr></table>
<p><a name="SEARCH"></a>
<form action="$script" method="post">
<input type="hidden" name="mode" value="past">
<table cellpadding="0" cellspacing="0">
<tr><td>過去ログ：<select name="pastlog">
EOM

	$pastkey = $pastno;
	while ( $pastkey > 0 ) {
		$pastkey = sprintf("%04d", $pastkey);
		if ($in{'pastlog'} eq "$pastkey") {
			print "<option value=\"$pastkey\" selected>P $pastkey\n";
		} else {
			print "<option value=\"$pastkey\">P $pastkey\n";
		}
		$pastkey--;
	}
	print "</select>\n<input type=submit value='移動'></td></form>\n";
	print "<td width=40></td><td>\n";
	print "<form action=\"$script\" method=\"get\">\n";
	print "<input type=\"hidden\" name=\"mode\" value=past>\n";
	print "<input type=\"hidden\" name=\"pastlog\" value=\"$in{'pastlog'}\">\n";
	print "ワード検索：<input type=\"text\" name=\"word\" size=\"30\" value=\"$in{'word'}\">\n";
	print "条件：<select name=\"cond\">\n";

	foreach ('AND', 'OR') {
		if ($in{'cond'} eq $_) {
			print "<option value=\"$_\" selected>$_\n";
		} else {
			print "<option value=\"$_\">$_\n";
		}
	}
	print "</select> 表\示：<select name=\"view\">\n";
	if ($in{'view'} eq "") { $in{'view'} = $p_tree; }
	foreach (10,15,20,25,30) {
		if ($in{'view'} == $_) {
			print "<option value=\"$_\" selected>$_件\n";
		} else {
			print "<option value=\"$_\">$_件\n";
		}
	}
	print "</select> <input type=submit value=\"検索\">";
	print "</td></form></tr></table>\n";

	# ファイルを定義
	$logfile = "$pastdir$in{'pastlog'}\.cgi";

	# ワード検索処理
	if ($in{'word'} ne "") {
		&search;
		&FOOTER;
		exit;
	}

	&ListTreeOpen('past');
	&move_list;
	&FOOTER;
	exit;
}

#---------------------------------------
#  記事タイトル長調整
#---------------------------------------
sub cut_subject {
	# 制限長に満たないものは戻す
	if (length($_[0]) <= $sub_length) { return $_[0]; }

	# カット処理
	($_[0], $folded) = &fold($_[0], $sub_length);
	$_[0] .= '..';

	return $_[0];
}

#---------------------------------------
#  ページ移動フォーム
#---------------------------------------
sub move_list {
	local($x,$y,$next,$back);

	$in{'list'} ||= 'tree';

	$next = $page + $p_tree;
	$back = $page - $p_tree;
	print "<p><table><tr>\n";
	if ($back >= 0) {
		print "<td><form action=\"$script\" method=\"get\">\n";
		print "<input type=\"hidden\" name=\"pastlog\" value=\"$in{'pastlog'}\">\n" if ($in{'pastlog'} ne "");
		print "<input type=\"hidden\" name=\"page\" value=\"$back\">\n";
		print "<input type=\"hidden\" name=\"mode\" value=\"past\">\n" if ($mode eq 'past');
		print "<input type=\"hidden\" name=\"list\" value=\"$in{'list'}\">\n";
		print "<input type=\"submit\" value=\"前ページ\"></td></form>\n";
	}
	if ($next < $i) {
		print "<td><form action=\"$script\" method=\"get\">\n";
		print "<input type=\"hidden\" name=\"pastlog\" value=\"$in{'pastlog'}\">\n" if ($in{'pastlog'} ne "");
		print "<input type=\"hidden\" name=\"page\" value=\"$next\">\n";
		print "<input type=\"hidden\" name=\"mode\" value=\"$mode\">\n" if ($mode eq 'past');
		print "<input type=\"hidden\" name=\"list\" value=\"$in{'list'}\">\n";
		print "<input type=\"submit\" value=\"次ページ\"></td></form>\n";
	}
	print "<td width=\"10\"></td><td class=\"num\">";

	# ページ移動ボタン表示
	$x=1;
	$y=0;
	$z=0;
	while ($i > 0) {
		if ($page eq $y) {
			$z++;
			print "| <b style=\"color:red\">$x</b>\n";
		} elsif ($in{'pastlog'} ne "") {
			$z++;
			print "| <a href=\"$script?page=$y&list=$in{'list'}&mode=past&pastlog=$in{'pastlog'}\">$x</a>\n";
		} else {
			$z++;
			print "| <a href=\"$script?page=$y&list=$in{'list'}\">$x</a>\n";
		}
		$x++;
		$y += $p_tree;
		$i -= $p_tree;
	}
	print "|" if ($z);
	print "</td></tr></table><br>\n";
}

#---------------------------------------
#  URLエンコード
#---------------------------------------
sub url_enc {
	local($_) = @_;

	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

#---------------------------------------
#  チェックモード
#---------------------------------------
sub check {
	&HEADER;
	print <<EOM;
<h2>Check Mode</h2>
<ul>
EOM

	# ログ
	print "<li>ログパス：";
	if (-e $logfile) {
		print "OK\n";
		# パーミッション
		print "<li>ログパーミッション：";
		if (-r $logfile && -w $logfile) { print "OK\n"; }
		else { print "NG → $logfile\n"; }
	} else {
		print "NG → $logfile\n";
	}

	# ロックディレクトリ
	print "<li>ロック形式：";
	if ($lockkey == 0) { print "設定なし\n"; }
	else {
		if ($lockkey == 1) { print "symlink\n"; }
		else { print "mkdir\n"; }

		($lockdir) = $lockfile =~ /(.*)[\\\/].*$/;
		print "<li>ロックディレクトリ：$lockdir\n";

		if (-d $lockdir) { print "<li>ロックディレクトリのパス：OK\n"; }
		else { print "<li>ロックディレクトリのパス：NG → $lockdir\n"; }

		if (-r $lockdir && -w $lockdir && -x $lockdir) {
			print "<li>ロックディレクトリのパーミッション：OK\n";
		} else {
			print "<li>ロックディレクトリのパーミッション：NG → $lockdir\n";
		}
	}

	# 過去ログ
	print "<li>過去ログ：";
	if ($pastkey == 0) { print "設定なし\n"; }
	else {
		print "設定あり\n";

		# NOファイル
		if (-e $nofile) {
			print "<li>NOファイルパス：OK\n";
			if (-r $nofile && -w $nofile) { print "<li>NOファイルパーミッション：OK\n"; }
			else { print "<li>NOファイルパーミッション：NG → $nofile\n"; }
		} else { print "<li>NOファイルのパス：NG → $nofile\n"; }

		# ディレクトリ
		if (-d $pastdir) {
			print "<li>過去ログディレクトリパス：OK\n";
			if (-r $pastdir && -w $pastdir && -x $pastdir) {
				print "<li>過去ログディレクトリパーミッション：OK\n";
			} else {
				print "<li>過去ログディレクトリパーミッション：NG → $pastdir\n";
			}
		} else { print "<li>過去ログディレクトリのパス：NG → $pastdir\n"; }
	}

	&FOOTER;
	exit;
}

