#include "browsehandler.h"

// Constructor
BrowseHandler::BrowseHandler(QList<videoInfo*>	*videoList)
{
	list = videoList;
	rowCount = list->count();
}

bool	BrowseHandler::startElement(const QString &, const QString &, const QString	&qName, const QXmlAttributes	&attr)
{
//	qDebug() << " qName=" << qName;
	for(int i = 0; i < attr.count(); i++)
	{
//		qDebug() << " attr=" << attr.qName(i);
	}
	
	if(qName == "item")
	{
		item = new videoInfo;
		item->id = attr.value("id");
	}
	if(qName == "dc:title")
	{
		target = &(item->title);
	}
	else if(qName == "av:dateTime")
	{
		target = &(item->datetime);
	}
	else if(qName == "res")
	{
		target = &(item->url);
		item->duration = attr.value("duration");
		item->bitrate = attr.value("bitrate");
		item->size = attr.value("size");
	}
	else if(qName == "upnp:channelName")
	{
		target = &(item->channel);
	}
	else
	{
		target = NULL;
	}
	return	true;
}

bool	BrowseHandler::endElement(const QString &, const QString &, const QString	&qName)
{
	if(qName == "item")
	{
		list->append(item);
	}
	return	true;
}

bool	BrowseHandler::characters(const QString	&str)
{
//	qDebug() << "str=" << str;
	if(target != NULL)
	{
		*target = str;
		target = NULL;
	}
	return	true;
}

bool	BrowseHandler::fatalError(const QXmlParseException	&exception)
{
	qDebug() << exception.columnNumber() << exception.lineNumber() << exception.message();
	return	false;
}
// place your code here
