#ifndef MAINWINDOWIMPL_H
#define MAINWINDOWIMPL_H
//
#include <QMainWindow>
#include "ui_mainwindow.h"

#include <QtCore>
#include <QtNetwork>
#include <QtXml>
#include <QtGui>

#include "globals.h"
#include "browsehandler.h"
#include "serverdialogimpl.h"
#include "videodetailimpl.h"
#include "progressdialog.h"

//

/*
	CoCoon channel server main window implementation
*/
class MainWindowImpl : public QMainWindow, public Ui::MainWindow
{
Q_OBJECT
public:
	MainWindowImpl( QWidget * parent = 0, Qt::WFlags f = 0 );
private slots:
	void	updateList();			// Video list update
	void	showVideoDetail();		// Video details
	
	void	serverDiscovered();		// Received UPnP message from server(s)
	void	selectServers();		// Select discovered servers
	void	serverSelected(const QModelIndex	index);	// Selected from server list dialog
	void	httpRequestFinished(int	id, bool	error);	// HTTP data receive handler
	void	discoverChannelServer();	// Discovering channel server(s)
	void	downloadVideo();		// Video download
	void	downloadRequest();		// Download process
	void	progressUpdate();		// Progress dialog update
	void	downloadCanceled();		// Stop download when cancel button clicked
	
private:
	QString	browseRequest;			// SOAP browse request string
	QUdpSocket	*uPnPSocket;		// UDP socket for broadcast
	QTimer	*timeoutTimer;			// SSDP discover timeout timer
	QList<serverInfo*>	*serverList;	// Server list
	QList<videoInfo*>	*videoList;	// Video list
	QList<videoInfo*>	*downloadQueue;	// Video download queue
	QString	downloadDir;			// Download directory
	QFile	*videoFile;				// Current downloading videofile
	ProgressDialog	*progressDialog;	// Download progress dialog
	QTimer	*progressTimer;			// Progressbar interval timer
	QStandardItemModel	*videoTableModel;	// Video list
	QString	serverAddress;			// Server IP address
	quint16	serverPort;				// Server port
	QHttp	*connection;			// HTTP connection
	QBuffer	*buf;					// Buffer of HTTP connection
	QString	resultText;				// Browse request result XML text
	int		descId;					// HTTP connection id of get server description file
	int		browseId;				// Connection ID of Browse video list
	int		downloadId;				// Connection ID of Download video
};
#endif




