        SUBROUTINE PROFIT_CALC(J)
        USE PROFIT_GLOBAL
        IMPLICIT NONE
C       J=DATE INDEX VALUE
        INTEGER J,IDATE,IYEAR,IMONTH,IDAY,JD
        CHARACTER ADATE*8,AYEAR*4,AMONTH*2,ADAY*2
C       INTERMEDIATE VARIABLES
        REAL*8 D1,D2,D3,D4,D5,D6
        INTEGER JULDAY
        EXTERNAL JULDAY
        INCLUDE 'DATMAI.INC'
C
C       SHORT_TIME, MEDIUM_TIME, LONG_TIME, BUY_DELAY AND
C       SELL_DELAY ARE HANDLED WITH THE PM AND PMP COMMANDS
C       SHORT,MEDIUM,LONG,SELDELAY,BUYDELAY
C

C       SHORT INTERMEDIATE VARIABLES
        D2=2.0/DBLE(SHORT_TIME+1)
        D2=(ANINT(D2*100))/100
        D1=1.0-D2
C       MEDIUM INTERMEDIATE VARIABLES
        D4=2.0/DBLE(MEDIUM_TIME+1)
        D4=(ANINT(D4*100))/100
        D3=1.0-D4
C       LONG INTERMEDIATE VARIABLES
        D6=2.0/DBLE(LONG_TIME+1)
        D6=(ANINT(D6*100))/100
        D5=1.0-D6
C
C       ITEMS 1,2,3 AND 13 ARE INPUT NUMBERS
C
C       PRICE HI
C       PROFITDATA(J,1)
C
C       PRICE LOW
C       PROFITDATA(J,2)
C
C       PRICE CLOSE
C       PROFITDATA(J,3)
C
C       VOLUME
C       PROFITDATA(J,12)
C
C       SHORT MOVING AVERAGE
        IF(J.GT.SHORT_TIME) THEN
C
        PROFITDATA(J,4)=
     1  ANINT((D1*PROFITDATA(J-1,4)+
     2  D2*PROFITDATA(J,3))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,4)=PROFITDATA(J,3)
                ELSE
        PROFITDATA(J,4)=((DBLE(J-1)*(PROFITDATA(J-1,4)))
     1  +PROFITDATA(J,3))/DBLE(J)
                END IF
                END IF
C
C       MEDIUM MOVING AVERAGE
        IF(J.GT.MEDIUM_TIME) THEN
        PROFITDATA(J,5)=
     1  ANINT((D3*PROFITDATA(J-1,5)+
     2  D4*PROFITDATA(J,3))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,5)=PROFITDATA(J,3)
                ELSE
        PROFITDATA(J,5)=((DBLE(J-1)*(PROFITDATA(J-1,5)))
     1  +PROFITDATA(J,3))/DBLE(J)
                END IF
                END IF
C
C       LONG MOVING AVERAGE
        IF(J.GT.LONG_TIME) THEN
        PROFITDATA(J,6)=
     1  ANINT((D5*PROFITDATA(J-1,6)+
     2  D6*PROFITDATA(J,3))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,6)=PROFITDATA(J,3)
                ELSE
        PROFITDATA(J,6)=((DBLE(J-1)*(PROFITDATA(J-1,6)))
     1  +PROFITDATA(J,3))/DBLE(J)
                END IF
                END IF
C
C       SHORT TREND
C       SHORT MOVING AVERAGE MINUS LONG MOVING AVERAGE
        PROFITDATA(J,9)=
     1  ANINT((PROFITDATA(J,4)-PROFITDATA(J,6))*100)
C
C       LONG TREND
C       MEDIUM MOVING AVERAGE MINUS LONG MOVING AVERAGE
        PROFITDATA(J,10)=
     1  ANINT((PROFITDATA(J,5)-PROFITDATA(J,6))*100)
C
C       SHORT AND LONG OSCILLATORS
        IF(J.EQ.1) THEN
C       SHORT OSCILLATOR
        PROFITDATA(J,7)=
     1  ANINT((PROFITDATA(J,9))*100)
C
C       LONG OSCILLATOR
        PROFITDATA(J,8)=
     1  ANINT((PROFITDATA(J,10))*100)
                        ELSE
C       SHORT OSCILLATOR
        PROFITDATA(J,7)=
     1  ANINT((PROFITDATA(J,9)-PROFITDATA(J-1,9))*100)
C
C       LONG OSCILLATOR
        PROFITDATA(J,8)=
     1  ANINT((PROFITDATA(J,10)-PROFITDATA(J-1,10))*100)
                        END IF
C
C       SPREAD
C       SHORT TREND MINUS LONG TREND
        PROFITDATA(J,11)=
     1  PROFITDATA(J,9)-PROFITDATA(J,10)
C
C       PAUL AND I ADDED THE SHORT, MEDIUM AND LONG MOVING AVERAGES
C       OF THE SPREAD TO GIVE US SOMETHING FOR AN APPLES TO APPLES
C       TYPE COMPARISON WITH THE SHORT, MEDIUM AND LONG MOVING AVERAGES
C
C
C       SHORT MOVING AVERAGE OF THE SPREAD
        IF(J.GT.SHORT_TIME) THEN
        PROFITDATA(J,51)=
     1  ANINT((D1*PROFITDATA(J-1,51)+
     2  D2*PROFITDATA(J,11))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,51)=PROFITDATA(J,11)
                ELSE
        PROFITDATA(J,51)=((DBLE(J-1)*(PROFITDATA(J-1,51)))
     1  +PROFITDATA(J,11))/DBLE(J)
                END IF
                END IF
C
C       MEDIUM MOVING AVERAGE
        IF(J.GT.MEDIUM_TIME) THEN
        PROFITDATA(J,52)=
     1  ANINT((D3*PROFITDATA(J-1,52)+
     2  D4*PROFITDATA(J,11))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,52)=PROFITDATA(J,11)
                ELSE
        PROFITDATA(J,52)=((DBLE(J-1)*(PROFITDATA(J-1,52)))
     1  +PROFITDATA(J,11))/DBLE(J)
                END IF
                END IF
C
C       LONG MOVING AVERAGE
        IF(J.GT.LONG_TIME) THEN
        PROFITDATA(J,53)=
     1  ANINT((D5*PROFITDATA(J-1,53)+
     2  D6*PROFITDATA(J,11))*100)/100
                ELSE
        IF(J.EQ.1) THEN
        PROFITDATA(J,53)=PROFITDATA(J,11)
                ELSE
        PROFITDATA(J,53)=((DBLE(J-1)*(PROFITDATA(J-1,53)))
     1  +PROFITDATA(J,11))/DBLE(J)
                END IF
                END IF
C
C       VOLUME STORED IN 12
C
C
C       JULIAN DAY IN 40
C
C       FIRST DELTA JULIAN DAY IN 41
C
C       DECOND DELTA JULAIN DAY IN 42
C
C       DATE STORED IN 13 AS YYYYMMDD
        IDATE=INT(PROFITDATA(J,13))
        WRITE(ADATE,10) IDATE
 10     FORMAT(I8)
        AYEAR=ADATE(1:4)
        AMONTH=ADATE(5:6)
        ADAY=ADATE(7:8)
        READ(AYEAR,11) IYEAR
        READ(AMONTH,12) IMONTH
        READ(ADAY,13) IDAY
  11    FORMAT(I4)
  12    FORMAT(I2)
  13    FORMAT(I2)
        JD=JULDAY(IMONTH,IDAY,IYEAR)
        PROFITDATA(J,40)=DBLE(JD)
        IF(J.LT.2) THEN
        PROFITDATA(J,41)=0.0D0
        ELSE
        PROFITDATA(J,41)=PROFITDATA(J,40)-PROFITDATA(J-1,40)
                        END IF
        IF(J.LT.3) THEN
        PROFITDATA(J,41)=0.0D0
        ELSE
        PROFITDATA(J,42)=PROFITDATA(J,41)-PROFITDATA(J-1,41)
                        END IF
C
C       FIRST DELTAS (SLOPES)
C
        IF(J.LT.2) THEN
        PROFITDATA(J,14:25)=0.0
                        ELSE
C       K=14, HI PRICE DELTA
        PROFITDATA(J,14)=PROFITDATA(J,1)-PROFITDATA(J-1,1)
C       K=15, LO PRICE DELTA
        PROFITDATA(J,15)=PROFITDATA(J,2)-PROFITDATA(J-1,2)
C       K=16, CLOSING PRICE DELTA
        PROFITDATA(J,16)=PROFITDATA(J,3)-PROFITDATA(J-1,3)
C       K=17, SHORT MOVING AVERAGE DELTA
        PROFITDATA(J,17)=PROFITDATA(J,4)-PROFITDATA(J-1,4)
C       K=18, MEDIUM MOVING AVERAGE DELTA
        PROFITDATA(J,18)=PROFITDATA(J,5)-PROFITDATA(J-1,5)
C       K=19, LONG MOVING AVERAGE DELTA
        PROFITDATA(J,19)=PROFITDATA(J,6)-PROFITDATA(J-1,6)
C       K=20, SHORT OSCILLATOR DELTA
        PROFITDATA(J,20)=PROFITDATA(J,7)-PROFITDATA(J-1,7)
C       K=21, LONG OSCILLATOR DELTA
        PROFITDATA(J,21)=PROFITDATA(J,8)-PROFITDATA(J-1,8)
C       K=22, SHORT TREND DELTA
        PROFITDATA(J,22)=PROFITDATA(J,9)-PROFITDATA(J-1,9)
C       K=23, LONG TREND DELTA
        PROFITDATA(J,23)=PROFITDATA(J,10)-PROFITDATA(J-1,10)
C       K=24, SPREAD DELTA
        PROFITDATA(J,24)=PROFITDATA(J,11)-PROFITDATA(J-1,11)
C       K=25, VOLUME DELTA
        PROFITDATA(J,25)=PROFITDATA(J,12)-PROFITDATA(J-1,12)
C       K=26, NOT USED
                        END IF
C
C
C       SECOND DELTAS (SLOPES OF SLOPES)
C
        IF(J.LT.3) THEN
        PROFITDATA(J,27:39)=0.0
                        ELSE
C       K=27, HI PRICE DELTA
        PROFITDATA(J,27)=PROFITDATA(J,14)-PROFITDATA(J-1,14)
C       K=28, LO PRICE DELTA
        PROFITDATA(J,28)=PROFITDATA(J,15)-PROFITDATA(J-1,15)
C       K=29, CLOSING PRICE DELTA
        PROFITDATA(J,29)=PROFITDATA(J,16)-PROFITDATA(J-1,16)
C       K=30, SHORT MOVING AVERAGE DELTA
        PROFITDATA(J,30)=PROFITDATA(J,17)-PROFITDATA(J-1,17)
C       K=31, MEDIUM MOVING AVERAGE DELTA
        PROFITDATA(J,31)=PROFITDATA(J,18)-PROFITDATA(J-1,18)
C       K=32, LONG MOVING AVERAGE DELTA
        PROFITDATA(J,32)=PROFITDATA(J,19)-PROFITDATA(J-1,19)
C       K=33, SHORT OSCILLATOR DELTA
        PROFITDATA(J,33)=PROFITDATA(J,20)-PROFITDATA(J-1,20)
C       K=34, LONG OSCILLATOR DELTA
        PROFITDATA(J,34)=PROFITDATA(J,21)-PROFITDATA(J-1,21)
C       K=35, SHORT TREND DELTA
        PROFITDATA(J,35)=PROFITDATA(J,22)-PROFITDATA(J-1,22)
C       K=36, LONG TREND DELTA
        PROFITDATA(J,36)=PROFITDATA(J,23)-PROFITDATA(J-1,23)
C       K=37, SPREAD DELTA
        PROFITDATA(J,37)=PROFITDATA(J,24)-PROFITDATA(J-1,24)
C       K=38, VOLUME DELTA
        PROFITDATA(J,38)=PROFITDATA(J,25)-PROFITDATA(J-1,25)
C       K=39, NOT USED
                        END IF
C
C        K=43 TO 45 NOT YET USED
C
C        K=46 : OPENING PRICE
C        K=47 : SREC (THE ISSUE NUMBER IN THE PROFIT.DAT FILE)
C        K=48 : IREC (SEQUENTIAL ENTRY NUMBER IN THE PROFIT.DAT FILE)
C        K=49 : JREC (SEQUENTIAL ENTRY FOR THE PARTICULAR ISSUE)
C        K=50 : TOTAL NUMBER OF VALID RECORDS FOR STOCK ITEM I, UPDATED EACH TIME A NEW DAY IS PROCESSED
C        K=51 TO 100 NOT YET USED
                        RETURN
                        END
        SUBROUTINE LISTPROF
        USE PROFIT_GLOBAL
        IMPLICIT NONE
        LOGICAL OPEN108,EXIST108

        INTEGER ALLOERR,I,J,K
        INCLUDE 'DATMAI.INC'
        EXIST108=.FALSE.
C
        IF(STI.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LISTPROF" LISTS THE PROFIT DIRECTORY'
        CALL SHOWIT(1)
                        RETURN
                        END IF
        IF(SQ.EQ.1.OR.SN.EQ.1.OR.SST.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LISTPROF" TAKES NO ADDITIONAL INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
C
        INQUIRE(FILE=trim(HOME)//'PROLIB.PRF',EXIST=EXIST108)
                IF(EXIST108) THEN
C       PROFIT.DAT FILE EXISTS
C
        INQUIRE(FILE=trim(HOME)//'PROLIB.PRF',OPENED=OPEN108)
        IF(OPEN108) CALL CLOSE_FILE(108,1)
C       FILE WAS OPEN, CLOSE IT
C
                                ELSE
C       NO FILE EXISTS
        WRITE(OUTLYNE,*) 'NO PROFIT DIRECTORY FILE EXISTS'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*) 'NO LISTING IS POSSIBLE'
        CALL SHOWIT(1)
                        CALL MACFAL
                             RETURN
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,PROFITDATA,
     1  STAT=ALLOERR)
                                END IF
C       OPEN PROLIB.PRF

        OPEN(UNIT=108,ACCESS='DIRECT',FILE=trim(HOME)//'PROLIB.PRF',
     1  FORM='UNFORMATTED',RECL=(132*NRECL),STATUS='UNKNOWN')
C       READ THE NUMBER OF ISSUES PRESENT
        READ(UNIT=108,REC=1) K
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,STAT=ALLOERR)
        ALLOCATE(PROFITNAMES(1:K),PROFITTICKER(1:K),STAT=ALLOERR)
        ALLOCATE(PROFITENTRIES(1:K,1:2),STAT=ALLOERR)
C
                        DO I=1,K
        READ(UNIT=108,REC=I+1) J,PROFITTICKER(I),PROFITENTRIES(I,1)
     2  ,PROFITENTRIES(I,2),PROFITNAMES(I)
                        END DO
        CALL CLOSE_FILE(108,1)
  5     FORMAT(
     1  'ISSUE#',3X,'FILE NAME',1X,'COMPANY NAME',15X,
     2  'NUMBER OF ENTRIES')
 10     FORMAT(1X,I5,1X,A12,1X,A30,I8)
        WRITE(OUTLYNE,5)
        CALL SHOWIT(0)
                       DO I=1,K
        WRITE(OUTLYNE,10) I,TRIM(PROFITTICKER(I))//'.PRF',
     1  PROFITNAMES(I)(1:30),INT(PROFITENTRIES(I,2)-PROFITENTRIES(I,1))
     2  +1
                        CALL SHOWIT(0)
                        END DO
        CALL CLOSE_FILE(108,1)
C       LEAVE PROFIT LIBRARY ARRAYS ALLOCATED, THEY WILL
C       BE DEALLOCATED AT PROGRAM EXIT
C
                        RETURN
                        END

        SUBROUTINE LOADISSU
        USE PROFIT_GLOBAL
        IMPLICIT NONE
        LOGICAL OPEN108,EXIST108
!        REAL*8 OPEN,HI,LO,CLOSE
        INTEGER ALLOERR,I,J,K,N
        CHARACTER*12 FNAME
        INCLUDE 'DATMAI.INC'
        EXIST108=.FALSE.
        ISSUE_LOADED=.FALSE.
C
        IF(STI.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LOADISSU" LOADS AN ISSUE FOR ANALYSIS'
        CALL SHOWIT(1)
                        RETURN
                        END IF
        IF(SST.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LOADISSU" TAKES NO STRING INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
        IF(S2.EQ.1.OR.S3.EQ.1.OR.S4.EQ.1.OR.S5.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LOADISSU" ONLY TAKES NUMERIC WORD #1 INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
C
        IF(SQ.EQ.1.AND.S1.EQ.1) THEN
        WRITE(OUTLYNE,*)
     1  '"LOADISSU" TAKES EITHER NUMERIC WORD #1 OR QUALIFIER INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
C
        INQUIRE(FILE=trim(HOME)//'PROLIB.PRF',EXIST=EXIST108)
                IF(EXIST108) THEN
C       PROFIT.DAT FILE EXISTS
C
        INQUIRE(FILE=trim(HOME)//'PROLIB.PRF',OPENED=OPEN108)
        IF(OPEN108) CALL CLOSE_FILE(108,1)
C       FILE WAS OPEN, CLOSE IT
C
                                ELSE
C       NO FILE EXISTS
        WRITE(OUTLYNE,*) 'NO PROFIT DIRECTORY FILE EXISTS'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*) 'NO LISTING IS POSSIBLE'
        CALL SHOWIT(1)
                        CALL MACFAL
                             RETURN
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,PROFITDATA,
     1  STAT=ALLOERR)
                                END IF
C       OPEN PROLIB.PRF

        OPEN(UNIT=108,ACCESS='DIRECT',FILE=trim(HOME)//'PROLIB.PRF',
     1  FORM='UNFORMATTED',RECL=(132*NRECL),STATUS='UNKNOWN')
C       READ THE NUMBER OF ISSUES PRESENT
        READ(UNIT=108,REC=1) K
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,STAT=ALLOERR)
        DEALLOCATE(PROFITDATA,STAT=ALLOERR)
        ALLOCATE(PROFITNAMES(1:K),PROFITTICKER(1:K),STAT=ALLOERR)
        ALLOCATE(PROFITENTRIES(1:K,1:2),STAT=ALLOERR)
C
                        DO I=1,K
        READ(UNIT=108,REC=I+1) J,PROFITTICKER(I),PROFITENTRIES(I,1)
     2  ,PROFITENTRIES(I,2),PROFITNAMES(I)
                        END DO
      IF(SQ.EQ.0) THEN
C     ISSUE NUMBER WAS ENTERED
        IF(INT(W1).LT.1.OR.INT(W1).GT.K) THEN
        WRITE(OUTLYNE,*)'NUMERIC WORD #1 BEYOND LEGAL RANGE'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'ISSUE NUMBERS RANGE FROM 1 TO ',K
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
C
C       LOAD ISSUE K INTO THE PROFITDATA ARRAY
        SYM=TRIM(PROFITTICKER(INT(W1)))
        FNAME=TRIM(PROFITTICKER(INT(W1)))//'.PRF'
        N=INT(PROFITENTRIES(INT(W1),2)-PROFITENTRIES(INT(W1),1))+1
        ALLOCATE(PROFITDATA(1:N,1:100),STAT=ALLOERR)
        PROFITDATA(1:N,1:100)=0.0D0
                        GO TO 901
                        ELSE
C     QUALIFIER TICKER WAS ENTERED
C     FIND THE CORRESPONDING INTERMAL ISSUE NUMBER
                        DO I=1,K
        READ(UNIT=108,REC=I+1) J,PROFITTICKER(I),PROFITENTRIES(I,1)
     2  ,PROFITENTRIES(I,2),PROFITNAMES(I)
      IF(WQ(1:8).EQ.PROFITTICKER(I)) GO TO 900
                        END DO
                        END IF
C     SYMBOL WAS NOT FOUND
        WRITE(OUTLYNE,*)'REQUESTED SYMBOL WAS NOT FOUND'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'NO ISSUE WAS LOADED'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
 900                    CONTINUE
C     LOAD ISSUE I FROM THE FILE
        SYM=TRIM(PROFITTICKER(I))
        FNAME=TRIM(PROFITTICKER(I))//'.PRF'
        N=INT(PROFITENTRIES(I,2)-PROFITENTRIES(I,1))+1
        ALLOCATE(PROFITDATA(1:N,1:100),STAT=ALLOERR)
        PROFITDATA(1:N,1:100)=0.0D0
        W1=DBLE(I)
 901                    CONTINUE
C
        OPEN(UNIT=109,ACCESS='DIRECT',FILE=FNAME,
     1  FORM='UNFORMATTED',RECL=(200*NRECL),STATUS='UNKNOWN')
        LASTDAY=N
        FIRSTDAY=1
                        DO I=1,N
        READ(UNIT=109,REC=I) PROFITDATA(I,1:100)
                        END DO
        WRITE(OUTLYNE,*)'ISSUE#: ',INT(W1)
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'SYMBOL: ',TRIM(PROFITTICKER(INT(W1)))
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'NAME: ',TRIM(PROFITNAMES(INT(W1)))
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*) 'HAS BEEN LOADED INTO MEMORY FOR ANAYLIS'
        CALL SHOWIT(1)
        ISSUE_LOADED=.TRUE.
                        CALL CLOSE_FILE(107,1)
                        CALL CLOSE_FILE(108,1)
                        CALL CLOSE_FILE(109,1)
C     AUTO PLOT THE SELECTED ISSUE
        SAVE_KDP(36)=SAVEINPT(36)
                  INPUT='PLOTISSU'
                  CALL PROCES
        REST_KDP(36)=RESTINPT(36)
C
                        RETURN
                        END


        SUBROUTINE PLOTISSU
        USE PROFIT_GLOBAL
        IMPLICIT NONE
        INTEGER I,DAYS,NDIV,IDELTA
        REAL*8 PMAX,SMAX,PMIN,SMIN
        CHARACTER AN(1:5)*23,ADIV*8
        INTEGER IM1,ID1,IY1,IM2,ID2,IY2,NDAYS,J
        CHARACTER AIM1*2,AID1*2,AIY1*4,AIM2*2,AID2*2,AIY2*4
        INCLUDE 'DATMAI.INC'
C
        IF(STI.EQ.1) THEN
        WRITE(OUTLYNE,*)'"PLOTISSU" PLOTS ISSUE DATA'
        CALL SHOWIT(1)
                        RETURN
                        END IF
        IF(SQ.EQ.1.OR.SST.EQ.1) THEN
        WRITE(OUTLYNE,*)'"PLOTISSU" TAKES NO QUALIFIER OR STRING INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
        IF(S2.EQ.1.OR.S3.EQ.1.OR.S4.EQ.1.OR.S5.EQ.1) THEN
        WRITE(OUTLYNE,*)
     1  '"PLOTISSU" ONLY TAKES OPTIONAL NUMERIC ONE INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
        IF(.NOT.ISSUE_LOADED) THEN
        WRITE(OUTLYNE,*)'NO ISSUES LOADED, SEE THE "LOADISSU" COMMAND'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'NO PLOT GENERATED'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
        IDELTA=INT(W1)
C       SPECIFIC NUMBER OF DAYS CHECK
                IF(PDAYS.GT.(LASTDAY-IDELTA-FIRSTDAY+1))THEN
                DAYS=LASTDAY-IDELTA-FIRSTDAY+1
                        ELSE
                DAYS=PDAYS
                        END IF
C       DETERMINE MAX PRICE TO BE PLOTTED
                        PMAX=-1.0D300
                        PMIN=+1.0D300
        STARTDAY=LASTDAY-IDELTA+1-DAYS
        ENDDAY=LASTDAY-IDELTA
        IF(ENDDAY.LE.STARTDAY) ENDDAY=STARTDAY+29
        IF(ENDDAY-STARTDAY+1.LT.30) ENDDAY=STARTDAY+29
                        DO I=STARTDAY,ENDDAY
        IF(PROFITDATA(I,1).GT.PMAX) PMAX=PROFITDATA(I,1)
        IF(PROFITDATA(I,1).LT.PMIN) PMIN=PROFITDATA(I,1)
        IF(PROFITDATA(I,2).GT.PMAX) PMAX=PROFITDATA(I,2)
        IF(PROFITDATA(I,2).LT.PMIN) PMIN=PROFITDATA(I,2)
        IF(PROFITDATA(I,3).GT.PMAX) PMAX=PROFITDATA(I,3)
        IF(PROFITDATA(I,3).LT.PMIN) PMIN=PROFITDATA(I,3)
        IF(PROFITDATA(I,4).GT.PMAX) PMAX=PROFITDATA(I,4)
        IF(PROFITDATA(I,4).LT.PMIN) PMIN=PROFITDATA(I,4)
        IF(PROFITDATA(I,5).GT.PMAX) PMAX=PROFITDATA(I,5)
        IF(PROFITDATA(I,5).LT.PMIN) PMIN=PROFITDATA(I,5)
        IF(PROFITDATA(I,6).GT.PMAX) PMAX=PROFITDATA(I,6)
        IF(PROFITDATA(I,6).LT.PMIN) PMIN=PROFITDATA(I,6)
                        END DO
C       DETERMINE MAX SPREAD TO BE PLOTTED
                        SMAX=-1.0D300
                        SMIN=+1.0D300
                        DO I=STARTDAY,ENDDAY
        IF(PROFITDATA(I,11).GT.SMAX) SMAX=PROFITDATA(I,11)
        IF(PROFITDATA(I,51).GT.SMAX) SMAX=PROFITDATA(I,51)
        IF(PROFITDATA(I,52).GT.SMAX) SMAX=PROFITDATA(I,52)
        IF(PROFITDATA(I,53).GT.SMAX) SMAX=PROFITDATA(I,53)
        IF(PROFITDATA(I,11).LT.SMIN) SMIN=PROFITDATA(I,11)
        IF(PROFITDATA(I,51).LT.SMIN) SMIN=PROFITDATA(I,51)
        IF(PROFITDATA(I,52).LT.SMIN) SMIN=PROFITDATA(I,52)
        IF(PROFITDATA(I,53).LT.SMIN) SMIN=PROFITDATA(I,53)
                        END DO
        IF(DABS(SMAX).GT.DABS(SMIN)) THEN
                        SMIN=-SMAX
                        ELSE
                        SMAX=DABS(SMIN)
                        END IF
C       SAVEINPT AND RESTINPT AT LEVEL 32
        SAVE_KDP(32)=SAVEINPT(32)
        INPUT='PLOT NEW'
        CALL PROCES
C
C       SET LINE TO SOLID
        INPUT='PLOT LSTYLE,2'
C
C       CONVERT STARTING JULIAN DATE INTO A STRING
        CALL CALDAT
     1  (INT(PROFITDATA(STARTDAY,40)),IM1,ID1,IY1)
        WRITE(AIM1,5) IM1
        WRITE(AID1,5) ID1
        WRITE(AIY1,6) IY1

C       CONVERT ENDING JULIAN DATE INTO A STRING
        CALL CALDAT
     1  (INT(PROFITDATA(ENDDAY,40)),IM2,ID2,IY2)
        WRITE(AIM2,5) IM2
        WRITE(AID2,5) ID2
        WRITE(AIY2,6) IY2
  5     FORMAT(I2)
  6     FORMAT(I4)
        NDIV=1
        NDAYS=(ENDDAY)-(STARTDAY+1)
        IF(NDAYS.GT.90.AND.NDAYS.LT.180) NDIV=2
        IF(NDAYS.GT.180.AND.NDAYS.LT.360) NDIV=360/60
        IF(NDAYS.GT.360.AND.NDAYS.LT.720) NDIV=720/60
        IF(NDAYS.GT.720.AND.NDAYS.LT.1440) NDIV=1440/60
        IF(NDAYS.GT.1440.AND.NDAYS.LT.2880) NDIV=2880/60
        IF(NDAYS.GT.1440.AND.NDAYS.LT.2880) NDIV=2880/60
        IF(NDAYS.GT.2880) NDIV=60
C
C       PLOTTING FOR THE CLOSING PRICE AND IT'S THREE AVERAGES
C**********************************************************************
C
        INPUT='PLOT UXAXRNG,1.5,9.0'
        CALL PROCES
        INPUT='PLOT UYAXRNG,4.0,6.5'
        CALL PROCES
C
C       X-AXIS (FIFTH NW 1 SO NO END LABLES PLOTTED'
C
C       X-AXIS CAPTION LABLE
C
        WRITE(AN(3),12) (((ENDDAY)-STARTDAY+1))
        INPUT='PLOT UXAXISLB,,,,,,'//TRIM(AN(3))//
     1  ' TRADING  DAYS - '//SYM
        CALL PROCES
        WRITE(AN(1),10) DBLE(STARTDAY)
        WRITE(AN(2),10) DBLE(ENDDAY)
        WRITE(AN(3),10) DBLE((ENDDAY-STARTDAY)/NDIV)
        INPUT='PLOT UXAXIS,'//AN(1)//','//AN(2)//','//AN(3)//
     1  ',1.0,1.0,'
        CALL PROCES
C
C       DATES
C
        AN(1)=TRIM(AIM1//'/'//AID1//'/'//AIY1)
        AN(2)=TRIM(AIM2//'/'//AID2//'/'//AIY2)
C       X-AXIS FIRST LABLE
        INPUT='PNOTE '//TRIM(AN(1))
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 1100 3700'
        CALL PROCES
C
C
C       X-AXIS SECOND LABLE
        INPUT='PNOTE '//TRIM(AN(2))
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 8600 3700'
        CALL PROCES
C
C
C       Y-AXIS
C
        WRITE(AN(1),11) DBLE(PMAX)
        WRITE(AN(2),11) DBLE(PMIN)
        WRITE(AN(3),11) DBLE(PMAX)-DBLE(PMIN)
        AN(3)='10.0D0'
        INPUT='PLOT UYAXIS,'//AN(2)//','//AN(1)//','//AN(3)//',1.0,,'
        CALL PROCES
        INPUT='PLOT UYAXISLB,,,,,,$ PRICE/AVERAGES'
        CALL PROCES
C
C       NUNBER OF DAYS PER TICK
        WRITE(ADIV,12) INT(NDIV)
        INPUT='PNOTE '//TRIM(ADIV)//' DAY(S) PER TIME INTERVAL'
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 7000 250'
        CALL PROCES
C
C       COLOR OF PRICE/SPREAD
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
        INPUT='PLOT PEN 1500 550 3'
        CALL PROCES
        INPUT='PLOT PEN 2400 550 2'
        CALL PROCES
        INPUT='PNOTE CLOSING PRICE/SREAD IN BLACK'
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 2500 550'
        CALL PROCES
C       COLOR OF SHORT AVERAGES
        INPUT='COLORSET PEN 3.0'
        CALL PROCES
        INPUT='PLOT PEN 1500 400 3'
        CALL PROCES
        INPUT='PLOT PEN 2400 400 2'
        CALL PROCES
        INPUT='PNOTE SHORT AVERAGES IN RED'
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 2500 400'
        CALL PROCES
C       COLOR OF MEDIUM AVERAGES
        INPUT='COLORSET PEN 5.0'
        CALL PROCES
        INPUT='PLOT PEN 1500 250 3'
        CALL PROCES
        INPUT='PLOT PEN 2400 250 2'
        CALL PROCES
        INPUT='PNOTE MEDIUM AVERAGES IN GREEN'
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 2500 250'
        CALL PROCES
C       COLOR OF LONG AVERAGES
        INPUT='COLORSET PEN 6.0'
        CALL PROCES
        INPUT='PLOT PEN 1500 100 3'
        CALL PROCES
        INPUT='PLOT PEN 2400 100 2'
        CALL PROCES
        INPUT='PNOTE LONG AVERAGES IN BLUE'
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 2500 100'
        CALL PROCES
C
C       NOW PLOT CLOSING PRICE DATA
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,3)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
                        GO TO 100
C       NOW PLOT HI PRICE DATA
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,1)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C       NOW PLOT LOW PRICE DATA
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,2)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
 100                    CONTINUE
C
C
C
C       NOW PLOT SHORT MOVING AVERAGE
        INPUT='COLORSET PEN 3.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,4)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C
C       NOW PLOT MEDIUM MOVING AVERAGE
        INPUT='COLORSET PEN 5.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,5)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C
C       NOW PLOT LONG MOVING AVERAGE
        INPUT='COLORSET PEN 6.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,6)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C       PLOTTING FOR THE SPREAD AND IT'S THREE AVERAGES
C**********************************************************************
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
C
        INPUT='PLOT UXAXRNG,1.5,9.0'
        CALL PROCES
        INPUT='PLOT UYAXRNG,1.0,3.0'
        CALL PROCES
        INPUT='PLOT PEN,1500,2000,3'
        CALL PROCES
        INPUT='PLOT PEN,9000,2000,2'
        CALL PROCES
        INPUT='PLOT PEN,9000,2000,3'
        CALL PROCES
C
C       X-AXIS (FIFTH NW 1 SO NO END LABLES PLOTTED'
C
C
C       X-AXIS CAPTION LABLE
C
        WRITE(AN(3),12) (((ENDDAY)-STARTDAY+1))
        INPUT='PLOT UXAXISLB,,,,,,'//TRIM(AN(3))//
     1  ' TRADING  DAYS - '//SYM
        CALL PROCES
        WRITE(AN(1),10) DBLE(STARTDAY)
        WRITE(AN(2),10) DBLE(ENDDAY)
        WRITE(AN(3),10) DBLE((ENDDAY-STARTDAY)/NDIV)
        INPUT='PLOT UXAXIS,'//AN(1)//','//AN(2)//','//AN(3)//
     1  ',1.0,1.0,'
        CALL PROCES
C
C       DATES
C
        AN(1)=TRIM(AIM1//'/'//AID1//'/'//AIY1)
        AN(2)=TRIM(AIM2//'/'//AID2//'/'//AIY2)
C       X-AXIS FIRST LABLE
        INPUT='PNOTE '//TRIM(AN(1))
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 1100 700'
        CALL PROCES
C
C
C       X-AXIS SECOND LABLE
        INPUT='PNOTE '//TRIM(AN(2))
        CALL PROCES
        INPUT='PLOT CHNOTE 1'
        CALL PROCES
        INPUT='PLOT NOTE 8600 700'
        CALL PROCES
C
C
C       Y-AXIS
C
        WRITE(AN(1),11) DBLE(SMAX)
        WRITE(AN(2),11) DBLE(SMIN)
        WRITE(AN(3),11) DBLE(SMAX)-DBLE(SMIN)
        AN(3)='10.0D0'
        INPUT='PLOT UYAXIS,'//AN(2)//','//AN(1)//','//AN(3)//',1.0,,'
        CALL PROCES
        INPUT='PLOT UYAXISLB,,,,,,SPREAD/AVERAGES'
        CALL PROCES
C
C       NOW PLOT SPREAD DATA
        INPUT='COLORSET PEN 15.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,11)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C
C       NOW PLOT SPREAD SHORT MOVING AVERAGE
        INPUT='COLORSET PEN 3.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,51)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C
C       NOW PLOT SPREAQD MEDIUM MOVING AVERAGE
        INPUT='COLORSET PEN 5.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,52)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
C
C       NOW PLOT SPREAD LONG MOVING AVERAGE
        INPUT='COLORSET PEN 6.0'
        CALL PROCES
                        J=STARTDAY
                        DO I=1,ENDDAY-STARTDAY+1
                        GPREG(I)=J
                        GPREG(I+ENDDAY-STARTDAY+1)=
     1                  PROFITDATA(I+STARTDAY-1,53)
                        J=J+1
                        END DO
        WRITE(AN(1),10) 1.0
        WRITE(AN(2),10) DBLE(ENDDAY-STARTDAY+1)
        WRITE(AN(3),10) DBLE(ENDDAY-STARTDAY+1)+1.0D0
        WRITE(AN(4),10) 2.0D0*DBLE(ENDDAY-STARTDAY+1)
        INPUT='PLOT UPLOT,'
     1  //AN(1)//','//AN(2)//','//AN(3)//','//AN(4)//',,'
        CALL PROCES
C
C
        INPUT='DRAW'
        CALL PROCES
        REST_KDP(32)=RESTINPT(32)

 10     FORMAT(D23.15)
 11     FORMAT(D23.15)
 12     FORMAT(I8,I8)
                        RETURN
                        END


        SUBROUTINE LOADPROF
        USE PROFIT_GLOBAL
        IMPLICIT NONE
        LOGICAL OPEN107,EXIST107
        CHARACTER PNAME*80,OSYM*8,OPNAME*80,FNAME*12
        REAL*8 OPEN,HI,LO,CLOSE,VOLUME,DATE
        INTEGER ALLOERR,I,J,K,L
        INCLUDE 'DATMAI.INC'
        OSYM='        '
        EXIST107=.FALSE.
        PROFITFILE=.FALSE.
        PROFITLOADED=.FALSE.
        OSYM='        '
        OPNAME='                              '
        IF(STI.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LOADPROF" LOADS DATA FROM A PROFIT DATA FILE'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)
     1  'AND PREPARES BINARY FILES FOR FURTHER ANALYSIS'
        CALL SHOWIT(1)
                        RETURN
                        END IF
        IF(SQ.EQ.1.OR.SN.EQ.1) THEN
        WRITE(OUTLYNE,*)'"LOADPROF" TAKES NO NUMERIC OR QUALIFIER INPUT'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*)'RE-ENTER COMMAND'
        CALL SHOWIT(1)
                        CALL MACFAL
                        RETURN
                        END IF
      IF(SST.EQ.0) THEN
                  SST=1
                  WS='PROFIT.DAT'
                  END IF
                  FNAME=trim(HOME)//TRIM(WS)
C
        INQUIRE(FILE=FNAME,EXIST=EXIST107)
                IF(EXIST107) THEN
C       PROFIT.DAT FILE EXISTS
C
        INQUIRE(FILE=FNAME,OPENED=OPEN107)
        IF(OPEN107) CALL CLOSE_FILE(107,1)
C       FILE WAS OPEN, CLOSE IT
C
C     SET PROFIT DATA FILE EXISTENCE FLAG AND OPEN IT
      PROFITFILE=.TRUE.
      OPEN(UNIT=107,ACCESS='SEQUENTIAL',BLANK='NULL'
     1  ,FORM='FORMATTED',FILE=FNAME
     1  ,STATUS='UNKNOWN')
C       FIRST READ TO GET MAX NUMBER OF ENTRIES
        WRITE(OUTLYNE,*) 'PRE-READING FILE ',FNAME,' PLEASE WAIT...'
        CALL SHOWIT(1)
                        IREC=1
 1      READ(107,FMT=*,END=9998,ERR=9999)
     1  SYM,OPEN,HI,LO,CLOSE,VOLUME,DATE,PNAME
                        IREC=IREC+1
                        GO TO 1
                                ELSE
C       NO FILE EXISTS, FIX LOGICALS AND RETURN
        WRITE(OUTLYNE,*) 'PROFIT FILE ',FNAME,' DOES NOT EXIST'
        CALL SHOWIT(1)
        WRITE(OUTLYNE,*) 'NO PROFIT DATA FILE WAS LOADED'
        CALL SHOWIT(1)

                PROFITFILE=.FALSE.
                PROFITLOADED=.FALSE.
                             RETURN
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,PROFITDATA,
     1  STAT=ALLOERR)
                                END IF
 9998   CONTINUE
 9999   CONTINUE
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,STAT=ALLOERR)
        ALLOCATE(PROFITNAMES(1:IREC),PROFITTICKER(1:IREC),STAT=ALLOERR)
        ALLOCATE(PROFITENTRIES(1:IREC,1:2),STAT=ALLOERR)
                        REWIND(UNIT=107)
                        JREC1=0
                        JREC2=0
                        K=0
        WRITE(OUTLYNE,*) 'READING ',FNAME,' PLEASE WAIT...'
        CALL SHOWIT(1)
                        DO I=1,IREC
        READ(107,FMT=*,END=8888,ERR=8889)
     1  SYM,OPEN,HI,LO,CLOSE,VOLUME,DATE,PNAME
        IF(I.EQ.1) THEN
                        OPNAME=PNAME
                        OSYM=SYM
                        JREC1=1
                        K=K+1
                        END IF
        IF(OSYM.NE.SYM) THEN
C       HIT A NEW ISSUE
                        JREC2=I-1
        PROFITNAMES(K)=OPNAME
        PROFITTICKER(K)=OSYM
        PROFITENTRIES(K,1)=JREC1
        PROFITENTRIES(K,2)=JREC2
                        OSYM=SYM
                        OPNAME=PNAME
                        JREC1=I
                        JREC2=0
                        K=K+1
                        END IF
                        END DO
 8888   CONTINUE
 8889   CONTINUE
C       HIT A LAST ISSUE
                        JREC2=I-1
        PROFITNAMES(K)=OPNAME
        PROFITTICKER(K)=OSYM
        PROFITENTRIES(K,1)=JREC1
        PROFITENTRIES(K,2)=JREC2
                        OSYM=SYM
                        OPNAME=PNAME
                        JREC1=I
                        JREC2=0
C
        WRITE(OUTLYNE,*) 'WRITING PROFIT LIBRARY, PLEASE WAIT...'
        CALL SHOWIT(1)
C       WRITE THE NAMES, TICKER AND ENTRY VALUES TO PROLIB.PRF
        OPEN(UNIT=108,ACCESS='DIRECT',FILE=trim(HOME)//'PROLIB.PRF',
     1  FORM='UNFORMATTED',RECL=(132*NRECL),STATUS='UNKNOWN')
C       WRITE THE NUMBER OF STOCK ENTRIES
        WRITE(UNIT=108,REC=1) K
                        DO I=1,K
        WRITE(UNIT=108,REC=I+1) I,PROFITTICKER(I),PROFITENTRIES(I,1)
     2  ,PROFITENTRIES(I,2),PROFITNAMES(I)
                        END DO
        CALL CLOSE_FILE(108,1)
C
C
C       NOW PROCESS EACH ISSUE INTO A PROFITDATA ARRAY AND THEN WRITE THE DATA TO A BINARY
C       FILE USING THE ISSUE SYMBOL AS THE FILE NAME
                        REWIND(UNIT=107)
        WRITE(OUTLYNE,*) 'WRITING ',K,' PROFIT FILES, PLEASE WAIT...'
        CALL SHOWIT(1)
                        DO I=1,K
        FNAME=trim(HOME)//TRIM(PROFITTICKER(I))//'.PRF'
        OPEN(UNIT=109,ACCESS='DIRECT',FILE=FNAME,
     1  FORM='UNFORMATTED',RECL=(200*NRECL),STATUS='UNKNOWN')
        L=PROFITENTRIES(I,2)-PROFITENTRIES(I,1)+1
        DEALLOCATE(PROFITDATA,STAT=ALLOERR)
        ALLOCATE(PROFITDATA(1:L,1:100),STAT=ALLOERR)

C       READ THE APPROPRIATE DATA FROM THE ASCII FILE INTO A DATA ARRAY
                        DO J=1,L
        READ(107,FMT=*)
     1  SYM,OPEN,HI,LO,CLOSE,VOLUME,DATE,PNAME
        PROFITDATA(J,1)=HI
        PROFITDATA(J,2)=LO
        PROFITDATA(J,3)=CLOSE
        PROFITDATA(J,12)=VOLUME
        PROFITDATA(J,13)=DATE
        PROFITDATA(J,46)=OPEN
        CALL PROFIT_CALC(J)
                        END DO
C       WRITE THE DATA ARRAYS OUT TO THE APPROPRIATE BINARY FILE
                        DO J=1,L
        WRITE(UNIT=109,REC=J) PROFITDATA(J,1:100)
                        END DO
        CALL CLOSE_FILE(109,1)
                        END DO
        WRITE(OUTLYNE,*) 'FINISHED CREATING PROFIT DATA FILES'
        CALL SHOWIT(1)
        IF(WS.NE.'PROFIT.DAT') THEN
C     AN INDIVIDUAL ISSUE IN ITS OWN FILE WAS SUCCESSFULLY LOADED.

      SAVE_KDP(35)=SAVEINPT(35)
                  INPUT='LOADISSU '//PROFITTICKER(1)
      write(outlyne,*) input(1:70)
      call showit(1)
                  CALL PROCES
      REST_KDP(35)=RESTINPT(35)
                  END IF
C       CLOSE THE ASCII FILE
        CALL CLOSE_FILE(107,1)
        DEALLOCATE(PROFITNAMES,PROFITTICKER,PROFITENTRIES,PROFITDATA,
     1  STAT=ALLOERR)
                        RETURN
                        END
