/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.api;

import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.webkit.WebView;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.IPlugin;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

public class PluginManager {
    private HashMap<String, IPlugin> plugins = new HashMap();
    private HashMap<String, String> services = new HashMap();
    private final CordovaInterface ctx;
    private final WebView app;
    protected HashMap<String, String> urlMap = new HashMap();

    public PluginManager(WebView app, CordovaInterface ctx) {
        this.ctx = ctx;
        this.app = app;
        this.loadPlugins();
    }

    public void reinit() {
        this.onPause(false);
        this.onDestroy();
        this.plugins = new HashMap();
    }

    public void loadPlugins() {
        int id = this.ctx.getResources().getIdentifier("plugins", "xml", this.ctx.getPackageName());
        if (id == 0) {
            this.pluginConfigurationMissing();
        }
        XmlResourceParser xml = this.ctx.getResources().getXml(id);
        int eventType = -1;
        String pluginClass = "";
        String pluginName = "";
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("plugin")) {
                    pluginClass = xml.getAttributeValue(null, "value");
                    pluginName = xml.getAttributeValue(null, "name");
                    this.addService(pluginName, pluginClass);
                    if ("true".equals(xml.getAttributeValue(null, "onload"))) {
                        this.getPlugin(pluginName);
                    }
                } else if (strNode.equals("url-filter")) {
                    this.urlMap.put(xml.getAttributeValue(null, "value"), pluginName);
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String exec(String service, final String action, final String callbackId, String jsonArgs, boolean async) {
        PluginResult cr = null;
        boolean runAsync = async;
        try {
            final JSONArray args = new JSONArray(jsonArgs);
            final IPlugin plugin = this.getPlugin(service);
            final CordovaInterface ctx = this.ctx;
            if (plugin != null) {
                boolean bl = runAsync = async && !plugin.isSynch(action);
                if (runAsync) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                PluginResult cr = plugin.execute(action, args, callbackId);
                                int status = cr.getStatus();
                                if (status != PluginResult.Status.NO_RESULT.ordinal() || !cr.getKeepCallback()) {
                                    if (status == PluginResult.Status.OK.ordinal() || status == PluginResult.Status.NO_RESULT.ordinal()) {
                                        ctx.sendJavascript(cr.toSuccessCallbackString(callbackId));
                                    } else {
                                        ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
                                    }
                                }
                            }
                            catch (Exception e) {
                                PluginResult cr = new PluginResult(PluginResult.Status.ERROR, e.getMessage());
                                ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
                            }
                        }
                    });
                    thread.start();
                    return "";
                }
                cr = plugin.execute(action, args, callbackId);
                if (cr.getStatus() == PluginResult.Status.NO_RESULT.ordinal() && cr.getKeepCallback()) {
                    return "";
                }
            }
        }
        catch (JSONException e) {
            System.out.println("ERROR: " + e.toString());
            cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
        if (runAsync) {
            if (cr == null) {
                cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            }
            this.ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
        }
        return cr != null ? cr.getJSONString() : "{ status: 0, message: 'all good' }";
    }

    private Class getClassByName(String clazz) throws ClassNotFoundException {
        Class<?> c = null;
        if (clazz != null) {
            c = Class.forName(clazz);
        }
        return c;
    }

    private boolean isCordovaPlugin(Class c) {
        if (c != null) {
            return Plugin.class.isAssignableFrom(c) || IPlugin.class.isAssignableFrom(c);
        }
        return false;
    }

    private IPlugin addPlugin(String pluginName, String className) {
        try {
            Class c = this.getClassByName(className);
            if (this.isCordovaPlugin(c)) {
                IPlugin plugin = (IPlugin)c.newInstance();
                this.plugins.put(className, plugin);
                plugin.setContext(this.ctx);
                plugin.setView(this.app);
                return plugin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + className + ".");
        }
        return null;
    }

    private IPlugin getPlugin(String pluginName) {
        String className = this.services.get(pluginName);
        if (this.plugins.containsKey(className)) {
            return this.plugins.get(className);
        }
        return this.addPlugin(pluginName, className);
    }

    public void addService(String serviceType, String className) {
        this.services.put(serviceType, className);
    }

    public void onPause(boolean multitasking) {
        for (IPlugin plugin : this.plugins.values()) {
            plugin.onPause(multitasking);
        }
    }

    public void onResume(boolean multitasking) {
        for (IPlugin plugin : this.plugins.values()) {
            plugin.onResume(multitasking);
        }
    }

    public void onDestroy() {
        for (IPlugin plugin : this.plugins.values()) {
            plugin.onDestroy();
        }
    }

    public void postMessage(String id, Object data) {
        for (IPlugin plugin : this.plugins.values()) {
            plugin.onMessage(id, data);
        }
    }

    public void onNewIntent(Intent intent) {
        for (IPlugin plugin : this.plugins.values()) {
            plugin.onNewIntent(intent);
        }
    }

    public boolean onOverrideUrlLoading(String url) {
        for (Map.Entry<String, String> pairs : this.urlMap.entrySet()) {
            if (!url.startsWith(pairs.getKey())) continue;
            return this.getPlugin(pairs.getValue()).onOverrideUrlLoading(url);
        }
        return false;
    }

    private void pluginConfigurationMissing() {
        System.err.println("=====================================================================================");
        System.err.println("ERROR: plugin.xml is missing.  Add res/xml/plugins.xml to your project.");
        System.err.println("https://git-wip-us.apache.org/repos/asf?p=incubator-cordova-android.git;a=blob;f=framework/res/xml/plugins.xml");
        System.err.println("=====================================================================================");
    }
}

