/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.misc.AssertionUtil;

public abstract class WriterUtil {
    public static Writer create(OutputStream os, String encoding) {
        AssertionUtil.assertArgumentNotNull("os", os);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        try {
            return new OutputStreamWriter(os, encoding);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Writer create(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Writer create(File file, String encoding) {
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

