/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.exception;

import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.SRuntimeException;
import org.seasar.util.lang.MethodUtil;

public class NoSuchMethodRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = -5673845060079098617L;
    private final Class<?> targetClass;
    private final String methodName;
    private final Class<?>[] argTypes;

    public NoSuchMethodRuntimeException(Class<?> targetClass, String methodName, Class<?>[] argTypes, Throwable cause) {
        super("EUTL0057", ArrayUtil.asArray(targetClass.getName(), MethodUtil.getSignature(methodName, argTypes)), cause);
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.argTypes = argTypes;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getArgTypes() {
        return this.argTypes;
    }
}

