/*
 * Decompiled with CFR 0.152.
 */
package com.kurukurupapa.tryandroid.fw.apt;

import com.kurukurupapa.tryandroid.fw.apt.FieldData;
import com.kurukurupapa.tryandroid.fw.apt.MiniStringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;

public class TableData {
    private String srcPackageName;
    private String srcSimpleName;
    private String destPackageName;
    private String destSimpleName;
    private String tableName;
    private List<FieldData> fieldList = new ArrayList<FieldData>();
    private FieldData idField;

    public void addField(String type, String name, Element element) {
        FieldData fieldData = new FieldData(type, name, element);
        this.fieldList.add(fieldData);
        if (fieldData.getIdFlag()) {
            this.idField = fieldData;
        }
    }

    public String getSrcClassName() {
        return String.valueOf(this.srcPackageName) + "." + this.srcSimpleName;
    }

    public String getDestClassName() {
        return String.valueOf(this.destPackageName) + "." + this.destSimpleName;
    }

    public String getSrcPackageName() {
        return this.srcPackageName;
    }

    public void setSrcPackageName(String srcPackageName) {
        this.srcPackageName = srcPackageName;
    }

    public String getSrcSimpleName() {
        return this.srcSimpleName;
    }

    public void setSrcSimpleName(String srcSimpleName) {
        this.srcSimpleName = srcSimpleName;
        this.tableName = MiniStringUtil.decamelizeAsLowerCase(srcSimpleName);
    }

    public String getDestPackageName() {
        return this.destPackageName;
    }

    public void setDestPackageName(String destPackageName) {
        this.destPackageName = destPackageName;
    }

    public String getDestSimpleName() {
        return this.destSimpleName;
    }

    public void setDestSimpleName(String destSimpleName) {
        this.destSimpleName = destSimpleName;
    }

    public List<FieldData> getFieldList() {
        return this.fieldList;
    }

    public void addField(FieldData field) {
        this.fieldList.add(field);
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldData getIdField() {
        return this.idField;
    }
}

