package com.kurukurupapa.tryandroid.fw.battery;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.kurukurupapa.tryandroid.fw.util.ReflectionUtil;

import android.content.Intent;

/**
 * バッテリーデータクラス
 */
public class BatteryInfo implements Cloneable {
	private static DateFormat dateFormat = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm:ss");

	public Date date;
	public boolean present;
	public int level;
	public int scale;
	public int iconSmall;
	public int voltage;
	public int temperature;
	public int status;
	public int health;
	public int plugged;
	public String technology;

	public BatteryInfo() {
	}

	public BatteryInfo(Intent intent) {
		set(intent);
	}

	@Override
	public BatteryInfo clone() {
		try {
			BatteryInfo clone = (BatteryInfo) super.clone();
			clone.date = (Date) date.clone();
			return clone;
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}

	public void set(Intent intent) {
		if (Intent.ACTION_BATTERY_CHANGED.equals(intent.getAction())) {
			date = new Date();
			status = intent.getIntExtra("status", 0);
			health = intent.getIntExtra("health", 0);
			present = intent.getBooleanExtra("present", false);
			level = intent.getIntExtra("level", 0);
			scale = intent.getIntExtra("scale", 0);
			iconSmall = intent.getIntExtra("icon-small", 0);
			plugged = intent.getIntExtra("plugged", 0);
			voltage = intent.getIntExtra("voltage", 0);
			temperature = intent.getIntExtra("temperature", 0);
			technology = intent.getStringExtra("technology");
		}
	}

	public String getTimestamp() {
		return getDateFormat().format(date);
	}

	public long getMilliSecond() {
		return date.getTime();
	}

	public void setTimestamp(String timestamp) throws ParseException {
		date = getDateFormat().parse(timestamp);
	}

	private DateFormat getDateFormat() {
		return dateFormat;
	}

	public String getStatusString() {
		return BatteryUtil.getStatusString(status);
	}

	public String getHealthString() {
		return BatteryUtil.getHealthString(health);
	}

	public String getPluggedString() {
		return BatteryUtil.getPluggedString(plugged);
	}

	public float getRate() {
		return BatteryUtil.getRate(level, scale);
	}

	public int getPercentage() {
		return BatteryUtil.getPercentage(level, scale);
	}

	public String getPercentageString() {
		return BatteryUtil.getPercentageString(level, scale);
	}

	public String getVoltageString() {
		return BatteryUtil.getVoltageString(voltage);
	}

	public String getShortTemperatureString() {
		return BatteryUtil.getShortTemperatureString(temperature);
	}

	public String getTemperatureString() {
		return BatteryUtil.getTemperatureString(temperature);
	}

	public String toString() {
		return ReflectionUtil.toString(this);
	}
}
