package com.kurukurupapa.tryandroidui.draglist;

import com.kurukurupapa.tryandroidui.R;

import android.app.Activity;
import android.os.Bundle;

/**
 * ドラッグアンドドロップで並び替え可能なリストビューを表示するサンプル<br>
 * リストビューの項目を長押しするとドラッグが始まり、離すとドラッグが終わります。
 * リストビューの上部または下部にドラッグすると、リストビューがスクロールします。
 *
 * 元ネタ<br>
 * ドラッグ＆ドロップで並び替えできる ListView - へたれプログラマの備忘録
 * http://d.hatena.ne.jp/shogo0809/20110118/1295326773
 */
public class DragListActivity extends Activity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.drag_list_activity);

		DragListAdapter adapter = new DragListAdapter(this);
		DragListView listView = (DragListView) findViewById(R.id.list);
		listView.setAdapter(adapter);
	}

}
