/*
 * Decompiled with CFR 0.152.
 */
package com.kurukurupapa.tryandroid.fw.apt;

import com.kurukurupapa.tryandroid.fw.apt.ManyEntity;
import com.kurukurupapa.tryandroid.fw.apt.SimpleEntity;
import com.kurukurupapa.tryandroid.fw.apt.TryAndroidFwProcesser;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.processing.Processor;
import org.seasar.aptina.unit.AptinaTestCase;

public class DaoGeneraterTest
extends AptinaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.setLocale(Locale.JAPANESE);
        this.setCharset(Charset.forName("UTF-8"));
        this.addSourcePath(new String[]{"test"});
    }

    public void testSimple() throws Exception {
        TryAndroidFwProcesser processor = new TryAndroidFwProcesser();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(SimpleEntity.class);
        this.compile();
        this.assertEqualsGeneratedSourceWithFile(this.getExpectedFilePath("DaoGeneraterTest_Simple.txt"), "com.kurukurupapa.tryandroid.fw.apt.SimpleEntityDao");
    }

    public void testMany() throws Exception {
        TryAndroidFwProcesser processor = new TryAndroidFwProcesser();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ManyEntity.class);
        this.compile();
        this.assertEqualsGeneratedSourceWithFile(this.getExpectedFilePath("DaoGeneraterTest_Many.txt"), "com.kurukurupapa.tryandroid.fw.apt.ManyEntityDao");
    }

    private String getExpectedFilePath(String name) {
        String subPath = "/" + ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + name;
        return ((Object)((Object)this)).getClass().getResource(subPath).getPath();
    }
}

