package com.kurukurupapa.tryandroiddb.db003;

import com.kurukurupapa.tryandroid.fw.db.DbProcess;
import com.kurukurupapa.tryandroid.fw.db.DbTransaction;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroiddb.R;
import com.kurukurupapa.tryandroiddb.db003.db.DbHelper;
import com.kurukurupapa.tryandroiddb.db003.model.Record;
import com.kurukurupapa.tryandroiddb.db003.model.RecordDao;
import com.kurukurupapa.tryandroiddb.db003.model.RecordListAdapter;

import android.app.Activity;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

/**
 * 自作ライブラリを使ったDB操作用アクティビティ
 */
public class Db003Activity extends Activity {
	private EditText editText;
	private Button insertButton;
	private Button updateButton;
	private Button deleteButton;
	private Button createButton;
	private Button dropButton;
	private TextView textView;

	private Record record;

	private SQLiteOpenHelper helper;
	private RecordDao recordDao;

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		LogUtil.called();

		super.onCreate(savedInstanceState);
		setContentView(R.layout.db003_activity);

		editText = (EditText) findViewById(R.id.db_edit_text);
		insertButton = (Button) findViewById(R.id.db_insert_button);
		updateButton = (Button) findViewById(R.id.db_update_button);
		deleteButton = (Button) findViewById(R.id.db_delete_button);
		createButton = (Button) findViewById(R.id.db_create_button);
		dropButton = (Button) findViewById(R.id.db_drop_button);
		textView = (TextView) findViewById(R.id.db_text_view);

		helper = new DbHelper(this);
		recordDao = new RecordDao();

		updateButton.setEnabled(false);
		deleteButton.setEnabled(false);

		insertButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					Db003Activity.this.onInsertButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		updateButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					Db003Activity.this.onUpdateButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		deleteButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					Db003Activity.this.onDeleteButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		createButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					Db003Activity.this.onCreateButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		dropButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					Db003Activity.this.onDropButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		try {
			findData(false);
		} catch (Exception e) {
			LogUtil.e("Error", e);
		}
	}

	private void findData(final boolean dropFlag) {
		new DbTransaction().runForReading(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// DB操作
				String text = null;
				record = null;
				if (!dropFlag) {
					RecordListAdapter list = new RecordListAdapter(recordDao
							.query(db, null));
					text = list.getText();
					record = list.getLast();
				}

				// 画面表示
				textView.setText(text);
				insertButton.setEnabled(!dropFlag);
				updateButton.setEnabled(record != null);
				deleteButton.setEnabled(record != null);
				createButton.setEnabled(dropFlag);
				dropButton.setEnabled(!dropFlag);
				LogUtil.d(text);

				return null;
			}
		});
	}

	private void onInsertButtonClickListener() {
		LogUtil.called();

		new DbTransaction().runForWriting(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// DB操作
				record = new Record();
				record.text = editText.getText().toString();
				record.timestamp = System.currentTimeMillis();
				recordDao.insert(db, record);
				return null;
			}
		});

		// 再表示
		findData(false);
	}

	private void onUpdateButtonClickListener() {
		LogUtil.called();

		new DbTransaction().runForWriting(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// DB操作
				record.text = editText.getText().toString();
				record.timestamp = System.currentTimeMillis();
				recordDao.update(db, record);
				return null;
			}
		});

		// 再表示
		findData(false);
	}

	private void onDeleteButtonClickListener() {
		LogUtil.called();

		new DbTransaction().runForWriting(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// DB操作
				record.text = editText.getText().toString();
				recordDao.delete(db, record);
				return null;
			}
		});

		// 再表示
		findData(false);
	}

	private void onCreateButtonClickListener() {
		LogUtil.called();

		new DbTransaction().runForWriting(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// テーブル作成
				recordDao.create(db);
				return null;
			}
		});

		// 再表示
		findData(false);
	}

	private void onDropButtonClickListener() {
		LogUtil.called();

		new DbTransaction().runForWriting(helper, new DbProcess<Void>() {
			@Override
			public Void process(SQLiteDatabase db) {

				// テーブル作成
				recordDao.drop(db);
				return null;
			}
		});

		// 再表示
		findData(true);
	}

}
