package com.kurukurupapa.tryandroid.fw.apt;

import java.util.ArrayList;
import java.util.List;

import com.kurukurupapa.tryandroid.fw.db.BaseDao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class SimpleEntityDao extends BaseDao<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> {
	public SimpleEntityDao() {
	}

	@Override
	public String getTableName() {
		return "simple_entity";
	}

	/**
	 * テーブル作成
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 */
	public void create(SQLiteDatabase db) {
		db.execSQL("create table simple_entity ("
				+ "id integer primary key autoincrement"
				+ ")");
	}

	/**
	 * テーブル削除
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 */
	public void drop(SQLiteDatabase db) {
		db.execSQL("drop table if exists simple_entity");
	}

	/**
	 * テーブル更新
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 */
	public void upgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		drop(db);
		create(db);
	}

	/**
	 * レコード検索処理
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param sql
	 *            SQL文。パラメータ部分は"?"のように記述する。
	 * @param args
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @return エンティティのリスト
	 */
	public List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> rawQuery(
			SQLiteDatabase db, String sql, String[] args) {
		List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> result =
				new ArrayList<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity>();
		Cursor cursor = null;
		try {
			cursor = db.rawQuery(sql, args);
			while (cursor.moveToNext()) {
				result.add(getEntityFromCursor(cursor));
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return result;
	}

	/**
	 * SQL実行
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @param sql
	 *            SQL文。
	 */
	public void execSQL(SQLiteDatabase db, String sql) {
		db.execSQL(sql);
	}

	/**
	 * SQL実行
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @param sql
	 *            SQL文。パラメータ部分は"?"のように記述する。
	 * @param args
	 *            検索条件のパラメータ配列。不要な場合null。
	 */
	public void execSQL(SQLiteDatabase db, String sql, Object[] bindArgs) {
		db.execSQL(sql, bindArgs);
	}

	/**
	 * レコード検索処理
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @param groupBy
	 *            未指定の場合null。
	 * @param having
	 *            未指定の場合null。
	 * @param orderBy
	 *            ソート条件。未指定の場合null。
	 * @param limit
	 *            取得件数。未指定の場合null。指定するとパフォーマンスアップ。
	 * @return エンティティのリスト
	 */
	public List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> query(SQLiteDatabase db,
			String selection, String[] selectionArgs, String groupBy, String having,
			String orderBy, String limit) {
		List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> result =
			new ArrayList<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity>();
		Cursor cursor = null;
		try {
			cursor = db.query("simple_entity",
				new String[] {
					"id",
				},
				selection, selectionArgs, groupBy, having, orderBy, limit);
			while (cursor.moveToNext()) {
				result.add(getEntityFromCursor(cursor));
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return result;
	}

	/**
	 * レコード検索処理（簡易版）
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @param orderBy
	 *            ソート条件。未指定の場合null。
	 * @param limit
	 *            取得件数。未指定の場合null。指定するとパフォーマンスアップ。
	 * @return エンティティのリスト
	 */
	public List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> query(SQLiteDatabase db,
			String where, String[] whereArgs, String orderBy, String limit) {
		return query(db, where, whereArgs, null, null, orderBy, limit);
	}

	/**
	 * レコード検索処理（全件）
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param limit
	 *            取得件数。未指定の場合null。指定するとパフォーマンスアップ。
	 * @return エンティティのリスト
	 */
	public List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> query(SQLiteDatabase db, String limit) {
		return query(db, null, null, null, null, "id", limit);
	}

	/**
	 * 1レコード検索処理
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @param groupBy
	 *            未指定の場合null。
	 * @param having
	 *            未指定の場合null。
	 * @param orderBy
	 *            ソート条件。未指定の場合null。指定するとパフォーマンスアップ。
	 * @return エンティティ
	 */
	public com.kurukurupapa.tryandroid.fw.apt.SimpleEntity querySingle(SQLiteDatabase db,
			String where, String[] whereArgs, String groupBy, String having, String orderBy) {
		List<com.kurukurupapa.tryandroid.fw.apt.SimpleEntity> list =
			query(db, where, whereArgs, groupBy, having, orderBy, "1");
		if (list.size() == 0) {
			return null;
		} else {
			return list.get(0);
		}
	}

	/**
	 * 1レコード検索処理（簡易版）
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @param orderBy
	 *            ソート条件。未指定の場合null。
	 * @return エンティティ
	 */
	public com.kurukurupapa.tryandroid.fw.apt.SimpleEntity querySingle(SQLiteDatabase db,
			String where, String[] whereArgs, String orderBy) {
		return querySingle(db, where, whereArgs, null, null, orderBy);
	}

	/**
	 * レコード件数取得処理
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @param groupBy
	 *            未指定の場合null。
	 * @param having
	 *            未指定の場合null。
	 * @return 件数
	 */
	public int queryCount(SQLiteDatabase db,
			String where, String[] whereArgs, String groupBy, String having) {
		int count = 0;
		Cursor cursor = null;
		try {
			cursor = db.query("simple_entity",
					new String[]{"count(id)"},
					where, whereArgs, groupBy, having, null, "1");
			count = cursor.getInt(0);
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return count;
	}

	/**
	 * レコード件数取得処理（簡易版）
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @param where
	 *            検索条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            検索条件のパラメータ配列。不要な場合null。
	 * @return 件数
	 */
	public int queryCount(SQLiteDatabase db, String where, String[] whereArgs) {
		return queryCount(db, where, whereArgs, null, null);
	}

	/**
	 * レコード件数取得処理（全件）
	 *
	 * @param db
	 *            DB接続（書き込み権限不要）
	 * @return 件数
	 */
	public int queryCount(SQLiteDatabase db) {
		return queryCount(db, null, null, null, null);
	}

	/**
	 * レコード追加
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @return ID
	 */
	public long insert(SQLiteDatabase db, com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entity) {
		ContentValues values = getContentValuesForInsert(entity);
		long id = db.insert("simple_entity", null, values);
		return id;
	}

	/**
	 * レコード更新
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @return 件数
	 */
	public int update(SQLiteDatabase db, com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entity) {
		int count = db.update(
			"simple_entity",
			getContentValuesForUpdate(entity),
			"id=" + entity.getId(),
			null);
		return count;
	}

	/**
	 * レコード削除
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @param where
	 *            削除条件。パラメータ部分は"?"のように記述する。nullの場合、条件なし。
	 * @param whereArgs
	 *            削除条件のパラメータ配列。不要な場合null。
	 * @return 件数
	 */
	public int delete(SQLiteDatabase db, String where, String[] whereArgs) {
		return db.delete("simple_entity", where, whereArgs);
	}

	/**
	 * レコード削除
	 *
	 * @param db
	 *            書き込み権限付きDB接続
	 * @return 件数
	 */
	public int delete(SQLiteDatabase db, com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entity) {
		return delete(db, "id=" + entity.getId(), null);
	}

	/**
	 * カラム名を取得する
	 */
	public String[] getColumnNames() {
		return new String[] {
				"id",
			};
	}

	/**
	 * カラム名を取得する（JOIN用）
	 */
	public String getColumnNamesForJoin() {
		return ""
			+ "simple_entity.id as id"
			;
	}

	protected ContentValues getContentValuesForInsert(com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entiry) {
		ContentValues values = new ContentValues();
		return values;
	}

	protected ContentValues getContentValuesForUpdate(com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entiry) {
		ContentValues values = getContentValuesForInsert(entiry);
		values.put("id", entiry.getId());
		return values;
	}

	protected com.kurukurupapa.tryandroid.fw.apt.SimpleEntity getEntityFromCursor(Cursor cursor) {
		com.kurukurupapa.tryandroid.fw.apt.SimpleEntity entiry = new com.kurukurupapa.tryandroid.fw.apt.SimpleEntity();
		entiry.setId(cursor.getInt(cursor.getColumnIndexOrThrow("id")));
		return entiry;
	}

}
