package com.kurukurupapa.tryandroidui.draglist;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプター抽象クラス
 */
public abstract class DragListAdapter extends BaseAdapter {
	private int mDraggingPosition = -1;

	public void setDraggingPosition(int draggingPosition) {
		mDraggingPosition = draggingPosition;
	}

	/**
	 * リスト項目のViewを取得する<br>
	 * ドラッグ対象項目かどうかで、getNormalView(), getDraggingView()を呼び分けている。
	 * 子クラスでは、getNormalView()を実装する。もし、getDraggingView()の動作を変えたければ、オーバーライドする。
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		// Viewを使いまわす場合は可視状態を初期化する
		if (convertView != null) {
			convertView.setVisibility(View.VISIBLE);
		}

		// ドラッグ対象項目かどうかによってビューを取得する
		if (isDragging(position)) {
			convertView = getDraggingView(position, convertView, parent);
		} else {
			convertView = getNormalView(position, convertView, parent);
		}
		return convertView;
	}

	/**
	 * 通常の（ドラッグしていない）Viewを取得する
	 */
	protected abstract View getNormalView(int position, View convertView,
			ViewGroup parent);

	/**
	 * ドラッグ対象項目のViewを取得する
	 */
	protected View getDraggingView(int position, View convertView,
			ViewGroup parent) {
		// ドラッグ対象項目は、ListView側で別途描画されるため、
		// オブジェクトだけ用意し、非表示にする。
		View view = getNormalView(position, convertView, parent);
		view.setVisibility(View.INVISIBLE);
		return view;
	}

	/**
	 * ドラッグ対象項目の場合trueを返却する
	 */
	protected boolean isDragging(int position) {
		return position == mDraggingPosition;
	}

	/**
	 * 指定位置の項目についてデータ内容を入れ替える
	 */
	public abstract void swapItems(int position1, int position2);

}
