package com.kurukurupapa.tryandroidui.draglist;


import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプター（リスト項目は１つのテキスト）
 */
public class DragListOneItemAdapter extends DragListAdapter {
	private Activity mActivity;
	private String[] mItems;

	public DragListOneItemAdapter(String[] items, Activity activity) {
		mItems = items;
		mActivity = activity;
	}

	@Override
	public int getCount() {
		return mItems.length;
	}

	@Override
	public Object getItem(int position) {
		return mItems[position];
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = mActivity.getLayoutInflater().inflate(
					android.R.layout.simple_list_item_1, null);
		}
		TextView view = (TextView) convertView;
		view.setText(mItems[position]);
		return super.getView(position, convertView, parent);
	}

	@Override
	public void swapItems(int position1, int position2) {
		String tmp = mItems[position1];
		mItems[position1] = mItems[position2];
		mItems[position2] = tmp;
	}

	@Override
	public long getItemId(int arg0) {
		// TODO 自動生成されたメソッド・スタブ
		return 0;
	}

	@Override
	protected View getNormalView(int position, View convertView,
			ViewGroup parent) {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}

}
