/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.beans.converter;

import java.sql.Timestamp;
import java.util.Date;
import org.seasar.util.beans.Converter;
import org.seasar.util.convert.StringConversionUtil;
import org.seasar.util.convert.TimestampConversionUtil;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.misc.AssertionUtil;

public class TimestampConverter
implements Converter {
    protected String pattern;

    public TimestampConverter(String pattern) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        this.pattern = pattern;
    }

    @Override
    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return TimestampConversionUtil.toSqlTimestamp((Object)value, this.pattern);
    }

    @Override
    public String getAsString(Object value) {
        if (value == null) {
            return null;
        }
        return StringConversionUtil.toString((Date)value, this.pattern);
    }

    @Override
    public boolean isTarget(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return clazz == Timestamp.class;
    }
}

