package com.kurukurupapa.tryandroid.fw.db;

/**
 * DBアクセス基本クラス
 */
public abstract class BaseDao<T> {
	public static final int LIMIT = Integer.MAX_VALUE;
	public static final String LIMIT_STR = String.valueOf(LIMIT);

	/**
	 * テーブル名を取得する。
	 * @return
	 */
	public abstract String getTableName();

	/**
	 * カラム名を取得する
	 */
	public abstract String[] getColumnNames();

	/**
	 * カラム名を取得する（JOIN用）
	 */
	public abstract String getColumnNamesForJoin();

}
