package com.kurukurupapa.tryandroid.fw.util;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;

public class CanvasUtil {

	public static void drawCenterText(Canvas canvas, String str, float centerX,
			float centerY, Paint paint) {
		drawCenterText(canvas, new String[] { str }, centerX, centerY, paint);
	}

	public static void drawCenterText(Canvas canvas, String[] strings,
			float centerX, float centerY, Paint paint) {
		drawCenterText(canvas, strings, centerX, centerY, paint, 0.5f);
	}

	public static void drawCenterText(Canvas canvas, String[] strings,
			float centerX, float centerY, Paint paint, float lineSpaceRare) {

		if (strings == null || strings.length == 0) {
			return;
		}

		// テキストの高さ、Y座標計算
		FontMetrics fontMetrics = paint.getFontMetrics();
		float strHeight = fontMetrics.ascent + fontMetrics.descent;
		float lineSpace = strHeight * lineSpaceRare;
		float y = centerY
				+ ((strHeight + lineSpace) * strings.length - lineSpace) / 2
				- strHeight;

		for (String str : strings) {
			// テキストの幅
			float strWidth = paint.measureText(str);
			// 描画
			canvas.drawText(str, centerX - strWidth / 2, y, paint);
			// Y座標計算
			y -= strHeight + lineSpace;
		}
	}
}
