package com.kurukurupapa.tryandroidui.drag;

import com.kurukurupapa.tryandroidui.R;

import android.app.Activity;
import android.os.Bundle;
import android.widget.ImageView;

/**
 * Viewをドラッグするサンプル
 *
 * 参考<br>
 * Viewを自由に動かす方法 | GE Android Blog<br>
 * http://blog.global-eng.co.jp/android/2011/01/14/viewを自由に動かす方法/<br>
 * Androidでドラッグ・アンド・ドロップ - hidecheckの日記
 * http://d.hatena.ne.jp/hidecheck/20100719/1279552472
 */
public class DragActivity extends Activity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.drag_activity);

		// ドラッグ対象Viewとイベント処理クラスを紐付ける
		ImageView dragView = (ImageView) findViewById(R.id.imageView1);
		DragViewListener listener = new DragViewListener(dragView);
		dragView.setOnTouchListener(listener);
	}

}
