/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.text.DecimalFormatUtil;

public abstract class ShortConversionUtil {
    public static Short toShort(Object o) {
        return ShortConversionUtil.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return ShortConversionUtil.toShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Short.valueOf(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        return ShortConversionUtil.toShort(o.toString());
    }

    private static Short toShort(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return Short.valueOf(DecimalFormatUtil.normalize(s));
    }

    public static short toPrimitiveShort(Object o) {
        return ShortConversionUtil.toPrimitiveShort(o, null);
    }

    public static short toPrimitiveShort(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return ShortConversionUtil.toPrimitiveShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Short.parseShort(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return ShortConversionUtil.toPrimitiveShort(o.toString());
    }

    private static short toPrimitiveShort(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0;
        }
        return Short.parseShort(DecimalFormatUtil.normalize(s));
    }
}

