/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.seasar.util.exception.ClassNotFoundRuntimeException;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CloseableUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class SerializeUtil {
    private static final int BYTE_ARRAY_SIZE = 8192;

    public static Object serialize(Object obj) {
        AssertionUtil.assertArgumentNotNull("obj", obj);
        byte[] binary = SerializeUtil.fromObjectToBinary(obj);
        return SerializeUtil.fromBinaryToObject(binary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromObjectToBinary(Object obj) {
        AssertionUtil.assertArgumentNotNull("obj", obj);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(obj);
            }
            finally {
                oos.close();
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromBinaryToObject(byte[] bytes) {
        Object object;
        AssertionUtil.assertArgumentNotEmpty("bytes", bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                CloseableUtil.close(ois);
                throw throwable;
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundRuntimeException(ex);
            }
        }
        CloseableUtil.close(ois);
        return object;
    }
}

