package com.kurukurupapa.tryandroid.fw.battery;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public abstract class AbstractBatteryChangedReceiver extends BroadcastReceiver {
	protected Context context;

	public AbstractBatteryChangedReceiver(Context context) {
		this.context = context;
	}

	public void register() {
		IntentFilter filter = new IntentFilter();
		filter.addAction(Intent.ACTION_BATTERY_CHANGED);
		context.registerReceiver(this, filter);
		LogUtil.i("Registered battery receiver");
	}

	public void unregister() {
		context.unregisterReceiver(this);
		LogUtil.i("Unregistered battery receiver");
	}

	@Override
	public void onReceive(Context context, Intent intent) {
		if (!intent.getAction().equals(Intent.ACTION_BATTERY_CHANGED)) {
			return;
		}
		LogUtil.called();

		// バッテリー状態測定
		BatteryInfo batteryInfo = new BatteryInfo(intent);

		LogUtil.i("Battery: " + batteryInfo.getPercentageString() + ", "
				+ batteryInfo.getStatusString());

		// 子クラスの呼び出し
		onBatteryChangedReceive(batteryInfo);
	}

	protected abstract void onBatteryChangedReceive(BatteryInfo batteryInfo);

}
