// ----------------------------------------------------------------------
// 動的なlistview（共通定義/処理）
// ----------------------------------------------------------------------
var jslistviewData = {
	data : [ {
		name : "太陽（Sun）",
		comment : "恒星",
	}, {
		name : "水星（Mercury）",
		comment : "太陽から1番目の惑星",
	}, {
		name : "金星（Venus）",
		comment : "太陽から2番目の惑星",
	}, {
		name : "地球（Earth）",
		comment : "太陽から3番目の惑星",
	}, {
		name : "火星（Mars）",
		comment : "太陽から4番目の惑星",
	}, {
		name : "木星（Jupiter）",
		comment : "太陽から5番目の惑星",
	}, {
		name : "土星（Saturn）",
		comment : "太陽から6番目の惑星",
	}, {
		name : "天王星（Uranus）",
		comment : "太陽から7番目の惑星",
	}, {
		name : "海王星（Neptune）",
		comment : "太陽から8番目の惑星",
	}, {
		name : "冥王星（Pluto）",
		comment : "準惑星",
	}, ],
	selectedIndex : null,
};

// ----------------------------------------------------------------------
// 動的なlistview（リスト選択画面）
// ----------------------------------------------------------------------
$("#jslistview").live("pagebeforeshow", function(e, data) {
	// listviewの内容をクリア
	$("#jslistview_ul").empty();
	// listviewへデータを埋め込み
	for (i = 0; i < jslistviewData.data.length; i++) {
		var item = jslistviewData.data[i];
		$("#jslistview_ul").append('<li>' + //
		'<a href="#" onclick="jslistview_onClick(\'' + i + '\');">' + //
		'<p class="wordbreak"><b>' + item.name + '</b><br>' + //
		item.comment + '</p>' + //
		'</li>');
	}
	// listviewの表示を更新
	$("#jslistview_ul").listview("refresh");
});

function jslistview_onClick(index) {
	jslistviewData.selectedIndex = index;
	$.mobile.changePage("#jslistviewresult");
}

// ----------------------------------------------------------------------
// 動的なlistview（結果画面）
// ----------------------------------------------------------------------
$("#jslistviewresult").live("pagebeforeshow", function(e, data) {
	var index = jslistviewData.selectedIndex;
	var item = jslistviewData.data[index];
	$("#jslistviewresult_msg").empty();
	$("#jslistviewresult_msg").append("あなたは「" + item.name + "」を選択しました。");
});
