﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using System.IO;

namespace Kuineator
{
    public partial class Kuineator : Form
    {
        public static string UTF7;
        public static string UTF8;
        public static string UTF16LE;
        public static string UTF16BE;
        public static string SHIFTJIS;
        public static string JIS;
        public static string EUCJP;

        private Tools.PropertyManager property;
        private Tools.PrintingManager printing;

        public Kuineator()
        {
            UTF7 = "utf-7";
            UTF8 = "utf-8";
            UTF16LE = "utf-16";
            UTF16BE = "unicodeFFFE";
            SHIFTJIS = "shift-jis";
            JIS = "iso-2022-jp";
            EUCJP = "euc-jp";
            InitializeComponent();
            Components.LexerPrim.Instance();
            this.property = new Tools.PropertyManager(this.MainDockPanel);
            this.printing = new Tools.PrintingManager();
            switch (this.property.CharacterCode)
            {
                case "utf-7":
                    this.MenuItem01_09_01_Click(null, null);
                    break;
                case "utf-8":
                    this.MenuItem01_09_02_Click(null, null);
                    break;
                case "utf-16":
                    this.MenuItem01_09_03_Click(null, null);
                    break;
                case "unicodeFFFE":
                    this.MenuItem01_09_04_Click(null, null);
                    break;
                case "shift-jis":
                    this.MenuItem01_09_05_Click(null, null);
                    break;
                case "iso-2022-jp":
                    this.MenuItem01_09_06_Click(null, null);
                    break;
                case "euc-jp":
                    this.MenuItem01_09_07_Click(null, null);
                    break;
            }
            this.MenuItem03_01.Checked = this.property.indentVisible;
            this.MenuItem03_02.Checked = this.property.spaceVisible;
            this.MenuItem03_03.Checked = this.property.newlineVisible;
            this.MenuItem03_04.Checked = this.property.Turnable;
            this.MenuItem07_05_01.Checked = this.property.Toollevel;
            this.MenuItem07_05_02.Checked = !(this.property.Toollevel);
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            foreach (DockWindow x in this.MainDockPanel.DockWindows)
            {
                x.Dispose();
            }
        }

        private void MenuItem01_01_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_01_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_02_Click(object sender, EventArgs e)
        {
            FileStream f = Settings.FileControl.getOpenFile();
            if (f != null) Tools.PropertyManager.editmag.AddWindow(f.Name, new StreamReader(f, Encoding.GetEncoding(this.property.CharacterCode)));
            f.Close();
        }

        private void MenuItem01_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_06_Click(object sender, EventArgs e)
        {
            Settings.FileControl.getSaveFile();
        }

        private void MenuItem01_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_09_01_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = true;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = UTF7;
        }

        private void MenuItem01_09_02_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = true;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = UTF8;
        }

        private void MenuItem01_09_03_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = true;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = UTF16LE;
        }

        private void MenuItem01_09_04_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = true;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = UTF16BE;
        }

        private void MenuItem01_09_05_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = true;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = SHIFTJIS;
        }

        private void MenuItem01_09_06_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = true;
            this.MenuItem01_09_07.Checked = false;
            this.property.CharacterCode = JIS;
        }

        private void MenuItem01_09_07_Click(object sender, EventArgs e)
        {
            this.MenuItem01_09_01.Checked = false;
            this.MenuItem01_09_02.Checked = false;
            this.MenuItem01_09_03.Checked = false;
            this.MenuItem01_09_04.Checked = false;
            this.MenuItem01_09_05.Checked = false;
            this.MenuItem01_09_06.Checked = false;
            this.MenuItem01_09_07.Checked = true;
            this.property.CharacterCode = EUCJP;
        }

        private void MenuItem01_09_08_01_Click(object sender, EventArgs e)
        {
            Settings.FileControl.getOpenFile();
        }

        private void MenuItem01_09_08_02_Click(object sender, EventArgs e)
        {
            Settings.FileControl.getOpenFile();
        }

        private void MenuItem01_09_08_03_Click(object sender, EventArgs e)
        {
            Settings.FileControl.getOpenFile();
        }

        private void MenuItem01_09_08_04_Click(object sender, EventArgs e)
        {
            Settings.FileControl.getOpenFile();
        }

        private void MenuItem01_10_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.RemoveWindow();
        }

        private void MenuItem01_11_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_12_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.OtherRemoveWindow();
        }

        private void MenuItem01_13_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AllRemoveWindow();
        }

        private void MenuItem01_14_Click(object sender, EventArgs e)
        {
            Fireball.Syntax.SyntaxDocument doc_set = Tools.PropertyManager.editmag.getDocument();
            Fireball.Syntax.SourceCodePrintDocument doc = new Fireball.Syntax.SourceCodePrintDocument(doc_set);
            if (doc.Document != null)
            {
                printing.doc_set = doc;
                printing.doc_set.DefaultPageSettings = printing.page_set;
                printing.doc_set.PrinterSettings = printing.print_set;
            }
            Settings.PrintControl.printDisplay(printing);
        }

        private void MenuItem01_15_Click(object sender, EventArgs e)
        {
            Fireball.Syntax.SyntaxDocument doc_set = Tools.PropertyManager.editmag.getDocument();
            Fireball.Syntax.SourceCodePrintDocument doc = new Fireball.Syntax.SourceCodePrintDocument(doc_set);
            if (doc.Document != null)
            {
                printing.doc_set = doc;
                printing.doc_set.DefaultPageSettings = printing.page_set;
                printing.doc_set.PrinterSettings = printing.print_set;
            }
            Settings.PrintControl.printPreview(printing);
        }

        private void MenuItem01_16_Click(object sender, EventArgs e)
        {
            Fireball.Syntax.SyntaxDocument doc_set = Tools.PropertyManager.editmag.getDocument();
            Fireball.Syntax.SourceCodePrintDocument doc = new Fireball.Syntax.SourceCodePrintDocument(doc_set);
            if (doc != null)
            {
                printing.doc_set = doc;
                printing.doc_set.DefaultPageSettings = printing.page_set;
                printing.doc_set.PrinterSettings = printing.print_set;
            }
            Settings.PrintControl.printSetup(printing);
        }

        private void MenuItem01_17_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem01_18_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_10_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_11_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_12_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem02_13_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem03_01_Click(object sender, EventArgs e)
        {
            if (this.MenuItem03_01.Checked) this.MenuItem03_01.Checked = false;
            else this.MenuItem03_01.Checked = true;
            this.property.indentVisible = this.MenuItem03_01.Checked;
        }

        private void MenuItem03_02_Click(object sender, EventArgs e)
        {
            if (this.MenuItem03_02.Checked) this.MenuItem03_02.Checked = false;
            else this.MenuItem03_02.Checked = true;
            this.property.spaceVisible = this.MenuItem03_02.Checked;
        }

        private void MenuItem03_03_Click(object sender, EventArgs e)
        {
            if (this.MenuItem03_03.Checked) this.MenuItem03_03.Checked = false;
            else this.MenuItem03_03.Checked = true;
            this.property.newlineVisible = this.MenuItem03_03.Checked;
        }

        private void MenuItem03_04_Click(object sender, EventArgs e)
        {
            if (this.MenuItem03_04.Checked) this.MenuItem03_04.Checked = false;
            else this.MenuItem03_04.Checked = true;
            this.property.Turnable = this.MenuItem03_04.Checked;
        }

        private void MenuItem03_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem03_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem03_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem03_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem03_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_10_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem04_11_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_02_Click(object sender, EventArgs e)
        {
            string[] str = new string[1];
            str[0] = "Kuinプロジェクトファイル(*.knproj)|*.knproj";
            string swap = Settings.FileControl.getOpenFilePath(str);
            if (swap != null)
                new Components.Dialog.ProjectCustomDialog(new Tools.Project(swap)).ShowDialog();
        }

        private void MenuItem05_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem05_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_10_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem06_11_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem07_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem07_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem07_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem07_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem07_05_01_Click(object sender, EventArgs e)
        {
            this.MenuItem07_05_01.Checked = true;
            this.MenuItem07_05_02.Checked = false;
            this.property.Toollevel = true;
        }

        private void MenuItem07_05_02_Click(object sender, EventArgs e)
        {
            this.MenuItem07_05_01.Checked = false;
            this.MenuItem07_05_02.Checked = true;
            this.property.Toollevel = false;
        }

        private void MenuItem08_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_04_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_06_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_07_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_08_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_09_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_10_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_11_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem08_12_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem09_01_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem09_02_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem09_03_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void MenuItem09_04_Click(object sender, EventArgs e)
        {
            new Components.Dialog.VersionDialog().ShowDialog();
        }

        private void MenuItem09_05_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void toolStripButton01_Click(object sender, EventArgs e)
        {
            this.MenuItem01_01_02_Click(null, null);
        }

        private void toolStripButton02_Click(object sender, EventArgs e)
        {
            this.MenuItem01_02_Click(null, null);
        }

        private void toolStripButton03_Click(object sender, EventArgs e)
        {
            this.MenuItem01_05_Click(null, null);
        }

        private void toolStripButton04_Click(object sender, EventArgs e)
        {
            this.MenuItem01_08_Click(null, null);
        }

        private void toolStripButton05_Click(object sender, EventArgs e)
        {
            this.MenuItem01_14_Click(null, null);
        }

        private void toolStripButton06_Click(object sender, EventArgs e)
        {
            this.MenuItem02_01_Click(null, null);
        }

        private void toolStripButton07_Click(object sender, EventArgs e)
        {
            this.MenuItem02_02_Click(null, null);
        }

        private void toolStripButton08_Click(object sender, EventArgs e)
        {
            this.MenuItem02_05_Click(null, null);
        }

        private void toolStripButton09_Click(object sender, EventArgs e)
        {
            this.MenuItem02_03_Click(null, null);
        }

        private void toolStripButton10_Click(object sender, EventArgs e)
        {
            this.MenuItem02_04_Click(null, null);
        }

        private void toolStripButton11_Click(object sender, EventArgs e)
        {
            this.MenuItem04_06_Click(null, null);
        }

        private void toolStripButton12_Click(object sender, EventArgs e)
        {
            this.MenuItem04_07_Click(null, null);
        }

        private void toolStripButton13_Click(object sender, EventArgs e)
        {
            this.MenuItem04_08_Click(null, null);
        }

        private void toolStripButton14_Click(object sender, EventArgs e)
        {
            this.MenuItem04_09_Click(null, null);
        }

        private void toolStripSplitButton_Click(object sender, EventArgs e)
        {
            Tools.PropertyManager.editmag.AddWindow("www", false);
        }

        private void toolStripButton15_Click(object sender, EventArgs e)
        {
            this.MenuItem05_07_Click(null, null);
        }

        private void toolStripButton16_Click(object sender, EventArgs e)
        {
            this.MenuItem05_06_Click(null, null);
        }

        private void toolStripButton17_Click(object sender, EventArgs e)
        {
            this.MenuItem06_01_Click(null, null);
        }

        private void toolStripButton18_Click(object sender, EventArgs e)
        {
            this.MenuItem06_02_Click(null, null);
        }

        private void toolStripButton19_Click(object sender, EventArgs e)
        {
            this.MenuItem06_03_Click(null, null);
        }

    }
}
