﻿using System;
using System.Text.RegularExpressions;
namespace Kuineator.Components
{
    static class LexerPrim
    {
        public static Regex Whitetabline;
        public static Regex Whitetabline2;
        public static Regex BlockName;
        public static Regex Blacket;
        //演算子
        public static Regex NEW;
        public static Regex IS;
        public static Regex IN;
        public static Regex CAST;
        public static Regex SYM;
        //プリミティブ型
        public static Regex PRIM;
        public static Regex LIST;
        public static Regex DICT;
        //命令
        public static Regex R_IMPORT;
        public static String IMPORT;
        public static Regex R_RETURN;
        public static String RETURN;
        public static Regex R_BREAK;
        public static String BREAK;
        public static Regex R_CONTINUE;
        public static String CONTINUE;
        public static Regex R_THROW;
        public static String THROW;
        public static Regex R_ASSERT;
        public static String ASSERT;
        public static Regex R_ALIAS;
        public static String ALIAS;
        public static Regex R_VAR;
        public static String VAR;
        public static Regex R_CONST;
        public static String CONST;
        public static Regex R_DO;
        public static String DO;
        //ブロック
        public static Regex R_ENUM;
        public static String ENUM;
        public static Regex R_BLOCK;
        public static String BLOCK;
        public static Regex R_IF;
        public static String IF;
        public static Regex R_ELSEIF;
        public static String ELSEIF;
        public static Regex R_ELSE;
        public static String ELSE;
        public static Regex R_SWITCH;
        public static String SWITCH;
        public static Regex R_CASE;
        public static String CASE;
        public static Regex R_DEFAULT;
        public static String DEFAULT;
        public static Regex R_WHILE;
        public static String WHILE;
        public static Regex R_FOR;
        public static String FOR;
        public static Regex R_FOREACH;
        public static String FOREACH;
        public static Regex R_IFDEF;
        public static String IFDEF;
        public static Regex R_TRY;
        public static String TRY;
        public static Regex R_CATCH;
        public static String CATCH;
        public static Regex R_FINALLY;
        public static String FINALLY;
        public static Regex R_FUNC;
        public static String FUNC;
        public static Regex R_CLASS;
        public static String CLASS;
        public static Regex R_END;
        public static String END;
        public static String THIS;
        //条件演算子
        public static Regex CONDI;
        //Action
        public static int DELETE;
        public static int INSERT;
        public static int ANOMALY;

        public static void Instance()
        {
            Whitetabline = new Regex(@"^[\s\t]+");
            Whitetabline2 = new Regex(@"^[\s\t]*");
            BlockName = new Regex(@"^[_a-zA-Z][_a-zA-Z0-9]*");
            Blacket = new Regex(@"^\(([^,\(\)]*)(,([^,\(\)]))*\)");
            //演算子
            NEW = new Regex(@"@new");
            IS = new Regex(@"(@is|@nis)");
            IN = new Regex(@"(@in|@nin)");
            CAST =new Regex(@"\$");
            SYM = new Regex(@"(\+|-|!|\^|\*|\/|%|~|=|<>|<|>|<=|>=|&|\||::|:\+|:-|:\*|:\/|:%|:\^|:~)");
            //プリミティブ型
            PRIM = new Regex(@"(int|byte|float|char|bool)");
            LIST = new Regex(@"(list|stack|queue|func)(<(.*)>)?");
            DICT = new Regex(@"dict(<(.*)>)?");
            //命令
            IMPORT = "import";
            //import [name]
            RETURN = "return";
            //return [value]
            BREAK = "break";
            //break [name]
            CONTINUE = "continue";
            //continue [name]
            THROW = "throw";
            //throw [value],[value]
            ASSERT = "assert";
            //assert [term]
            ALIAS = "alias";
            //alias [name]:[type]
            VAR = "var";
            //var [name]:[type](::[value])?
            CONST = "const";
            //const [name]:[type]::[value]
            DO = "do";
            //do [formula]
            //ブロック
            ENUM = "enum";
            //enum [name]
            //end enum
            BLOCK = "block";
            //block [name]
            //end block
            IF = "if";
            //if [name]([term])
            //elif([term])
            //else
            //end if
            ELSEIF = "elif";
            ELSE = "else";
            SWITCH = "switch";
            //switch [name]([name])
            //case([arguments])
            //default
            //end switch
            CASE = "case";
            DEFAULT = "default";
            WHILE = "while";
            //while [name]([term](,skip)?)
            //end while
            FOR = "for";
            //for [name]([value],[value],[value])
            //end for
            FOREACH = "foreach";
            //foreach [name]([arguments])
            IFDEF = "ifdef";
            //ifdef [name](debug|release)
            //end ifdef
            TRY = "try";
            //try [name]
            //catch [arguments]
            //finally
            //end try
            CATCH = "catch";
            FINALLY = "finally";
            FUNC = "func";
            //func [name]([arguments]):[type]
            //end func
            CLASS = "class";
            //class [name]([type])
            //end class
            END = "end";
            THIS = "this";
            //条件演算子
            CONDI = new Regex(@"\?\(([^\(\)]*)\)");
            //Action
            DELETE = 1;
            INSERT = 2;
            ANOMALY = 0;
        }
    }
}
