﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;

namespace Kuineator.Tools
{
    class Project
    {
        private string filepath;
        private string currentpath;
        private string classpath;
        private string compiletarget;
        private string prebuildcommand;
        private string postbuildcommand;
        private List<string> configs;
        private List<string> OutputOptions;
        private List<string> BuildOptions;
        private List<string> IncludeLibraries;
        private List<string> ExternalLibraries;
        private List<string> hiddenPaths;
        private List<string> OtherOptions;
        private List<string> PluginStorages;
        public Project(string path)
        {
            filepath = path;
            currentpath = path.Remove(path.LastIndexOf("\\"));
            configs = new List<string>();
            OutputOptions = new List<string>();
            BuildOptions = new List<string>();
            IncludeLibraries = new List<string>();
            ExternalLibraries = new List<string>();
            hiddenPaths = new List<string>();
            OtherOptions = new List<string>();
            PluginStorages = new List<string>();
            parseProjectFile();
        }

        private void parseProjectFile()
        {
            StreamReader f = null;
            try
            {
                f = new StreamReader(filepath);
                string line;
                Regex re = new Regex(@"<.*>$");
                while ((line = f.ReadLine()) != null)
                {
                    configs.Add(re.Match(line).Value);
                    Console.Write(configs[configs.Count-1] + "\n");
                }
            }
            catch
            {
                return;
            }
            finally
            {
                if (f != null)
                    f.Close();
            }

        }
    }
}
