﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Kyojin.Model;
using Yanesdk.System;

namespace Kyojin
{
    /// <summary>
    /// アプリケーションのエントリポイントを定義するクラス
    /// </summary>
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            FileArchiverZip.PassStatic = KyojinConst.PK + KyojinConst.P2 + KyojinConst.PC;

            FileArchiverZip arcZip = new FileArchiverZip();
            arcZip.ZipExtName = KyojinConst.ZIP_EXT;

            FileSys.Archiver.Add(arcZip);

            using (GameSystem system = new GameSystem())
            {
                system.Run();
            }
        }
    }
}