using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Timer;
using Yanesdk.Draw;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;

namespace Kyojin.Component.Ending
{
    public class Scene04 : Scene02
    {
        #region 萔l

        private const long START_TIME = 152700 + MUSIC_OFFSET_TIME;
        // ÔߎԂłIԂ`FbN
        private const long END_TIME = 196700 + MUSIC_OFFSET_TIME;

        #endregion

        #region otB[h

        private bool pahse4_2Out = false;
        private PhaseDraw phase1_1;
        private PhaseDraw phase1_2;
        private PhaseDraw phase2_1;
        private PhaseDraw phase2_2;
        private PhaseDraw phase3_1;
        private PhaseDraw phase3_2;
        private PhaseDraw phase4_1;
        private PhaseDraw phase4_2;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="timer"></param>
        public Scene04(FixTimer timer)
            : base(timer)
        {
            textureLoader = new TextureLoader();
            textureLoader.IsDefRelativePath = false;
            textureLoader.LoadDefFile("img2/ending/s04/list.txt");
            this.timer = timer;
            SetupTimingData();
        }

        /// ׂẲ摜LbV	
        public override void CacheTexture()
        {
            CacheTextureAll(textureLoader, "img2/ending/s04/list.txt");
        }

        // V[͊JnĂ邩
        public override bool IisStart
        {
            get { return START_TIME <= timer.Time; }
        }

        // V[I
        public override bool IsEnd
        {
            get { return sceneEndFlg || END_TIME <= timer.Time; }
        }

        //// \[X̉
        //public override void Release()
        //{
        //    textureLoader.Dispose();
        //}

        /// ^C~Of[^쐬
        protected override void SetupTimingData()
        {
            const long phase4_1Offset = 88000 + MUSIC_OFFSET_TIME;
            TimingData[] t4_1 = new TimingData[]{
			    new TimingData(65480 + phase4_1Offset, new HitEvent[]{eventCallback1_1}),
			    new TimingData(66820 + phase4_1Offset, new HitEvent[]{eventCallback1_2}),
			    new TimingData(68160 + phase4_1Offset, new HitEvent[]{eventCallback1_3}),
			    new TimingData(69490 + phase4_1Offset, new HitEvent[]{eventCallback1_4}),
			    new TimingData(69650 + phase4_1Offset, new HitEvent[]{eventCallback1_5}),
			    new TimingData(70830 + phase4_1Offset, new HitEvent[]{eventCallback1_6}),
			    new TimingData(72160 + phase4_1Offset, new HitEvent[]{eventCallback1_7}),
			    new TimingData(73490 + phase4_1Offset, new HitEvent[]{eventCallback1_8}),
			    new TimingData(74160 + phase4_1Offset, new HitEvent[]{eventCallback1_9}),
			    new TimingData(74270 + phase4_1Offset, new HitEvent[]{eventCallback1_10}),
			    new TimingData(74650 + phase4_1Offset, new HitEvent[]{eventCallback1_11}),
			    new TimingData(74840 + phase4_1Offset, new HitEvent[]{eventCallback1_12}),
			    new TimingData(74950 + phase4_1Offset, new HitEvent[]{eventCallback1_13}),
		    };
            m_timingData.Add(t4_1);

            TimingData[] t4_2 = new TimingData[]{
			    new TimingData(76150 + phase4_1Offset, new HitEvent[]{eventCallback2_1}),
			    new TimingData(77490 + phase4_1Offset, new HitEvent[]{eventCallback2_2}),
			    new TimingData(78820 + phase4_1Offset, new HitEvent[]{eventCallback2_3}),
			    new TimingData(80190 + phase4_1Offset, new HitEvent[]{eventCallback2_4}),
			    new TimingData(80330 + phase4_1Offset, new HitEvent[]{eventCallback2_5}),
			    new TimingData(81610 + phase4_1Offset, new HitEvent[]{eventCallback2_6}),
			    new TimingData(82820 + phase4_1Offset, new HitEvent[]{eventCallback2_7}),
			    new TimingData(83490 + phase4_1Offset, new HitEvent[]{eventCallback2_8}),
			    new TimingData(84150 + phase4_1Offset, new HitEvent[]{eventCallback2_9}),
			    new TimingData(84800 + phase4_1Offset, new HitEvent[]{eventCallback2_10}),
			    new TimingData(85550 + phase4_1Offset, new HitEvent[]{eventCallback2_11}),
			    new TimingData(85740 + phase4_1Offset, new HitEvent[]{eventCallback2_12}),
			    new TimingData(85830 + phase4_1Offset, new HitEvent[]{eventCallback2_13}),
		    };
            m_timingData.Add(t4_2);

            const long phase4_2Offset = MUSIC_OFFSET_TIME + 109300;
            TimingData[] t4_3 = new TimingData[]{
			    new TimingData(65480 + phase4_2Offset, new HitEvent[]{eventCallback3_1}),
			    new TimingData(66820 + phase4_2Offset, new HitEvent[]{eventCallback3_2}),
			    new TimingData(68160 + phase4_2Offset, new HitEvent[]{eventCallback3_3}),
			    new TimingData(69490 + phase4_2Offset, new HitEvent[]{eventCallback3_4}),
			    new TimingData(69650 + phase4_2Offset, new HitEvent[]{eventCallback3_5}),
			    new TimingData(70830 + phase4_2Offset, new HitEvent[]{eventCallback3_6}),
			    new TimingData(72160 + phase4_2Offset, new HitEvent[]{eventCallback3_7}),
			    new TimingData(73490 + phase4_2Offset, new HitEvent[]{eventCallback3_8}),
			    new TimingData(74160 + phase4_2Offset, new HitEvent[]{eventCallback3_9}),
			    new TimingData(74270 + phase4_2Offset, new HitEvent[]{eventCallback3_10}),
			    new TimingData(74650 + phase4_2Offset, new HitEvent[]{eventCallback3_11}),
			    new TimingData(74840 + phase4_2Offset, new HitEvent[]{eventCallback3_12}),
			    new TimingData(74950 + phase4_2Offset, new HitEvent[]{eventCallback3_13}),
		    };
            m_timingData.Add(t4_3);

            TimingData[] t4_4 = new TimingData[]{
			    new TimingData(76150 + phase4_2Offset, new HitEvent[]{eventCallback4_1}),
			    new TimingData(77490 + phase4_2Offset, new HitEvent[]{eventCallback4_2}),
			    new TimingData(78820 + phase4_2Offset, new HitEvent[]{eventCallback4_3}),
			    new TimingData(80190 + phase4_2Offset, new HitEvent[]{eventCallback4_4}),
			    new TimingData(80330 + phase4_2Offset, new HitEvent[]{eventCallback4_5}),
			    new TimingData(81610 + phase4_2Offset, new HitEvent[]{eventCallback4_6}),
			    new TimingData(82820 + phase4_2Offset, new HitEvent[]{eventCallback4_7}),
			    new TimingData(83490 + phase4_2Offset, new HitEvent[]{eventCallback4_8}),
			    new TimingData(84150 + phase4_2Offset, new HitEvent[]{eventCallback4_9}),
			    new TimingData(84800 + phase4_2Offset, new HitEvent[]{eventCallback4_10}),
			    new TimingData(85550 + phase4_2Offset, new HitEvent[]{eventCallback4_11}),
			    new TimingData(85640 + phase4_2Offset, new HitEvent[]{eventCallback4_12}),
			    new TimingData(85730 + phase4_2Offset, new HitEvent[]{eventCallback4_13}),
		    };
            m_timingData.Add(t4_4);


            phase1_1 = new PhaseDraw(textureLoader, 0);
            phase1_1.FadeStart();
            phase1_2 = new PhaseDraw(textureLoader, 6);
            phase2_1 = new PhaseDraw(textureLoader, 15);
            phase2_2 = new PhaseDraw(textureLoader, 21);
            phase3_1 = new PhaseDraw(textureLoader, 30);
            phase3_2 = new PhaseDraw(textureLoader, 36);
            phase4_1 = new PhaseDraw(textureLoader, 45);
            phase4_2 = new PhaseDraw(textureLoader, 51);
        }

        public override void OnMove(IScreen screen)
        {
		    phase1_1.OnMove(screen);
		    phase1_2.OnMove(screen);
		    phase2_1.OnMove(screen);
		    phase2_2.OnMove(screen);
		    phase3_1.OnMove(screen);
		    phase3_2.OnMove(screen);
		    phase4_1.OnMove(screen);
		    phase4_2.OnMove(screen);
		    foreach (HittingEffect hitEffect in hitEffects) {
			    if (hitEffect != null) {
				    hitEffect.OnMove(screen);
			    }
		    }
    		
		    // tF[h^CĎ
		    if (!pahse4_2Out && timer.Time > (END_TIME - 1000)) {
			    pahse4_2Out = true;
			    phase4_2.FadeEnd();
		    }
        }

        public override void OnDraw(IScreen screen)
        {
            phase1_1.OnDraw(screen);
            phase1_2.OnDraw(screen);
            phase2_1.OnDraw(screen);
            phase2_2.OnDraw(screen);
            phase3_1.OnDraw(screen);
            phase3_2.OnDraw(screen);
            phase4_1.OnDraw(screen);
            phase4_2.OnDraw(screen);
            foreach (HittingEffect hitEffect in hitEffects)
            {
                if (hitEffect != null)
                {
                    hitEffect.OnPaint(screen);
                }
            }
        }


        #region qbgCxg

        /// 1-1
        private bool eventCallback1_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_1.Next(textObj, status, 1, 15, 47, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-2
        private bool eventCallback1_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_1.Next(textObj, status, 2, 15, 115, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 1-3
        private bool eventCallback1_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_1.Next(textObj, status, 3, 15, 217, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-4
        private bool eventCallback1_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_1.Next(textObj, status, 4, 15, 285, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-5
        private bool eventCallback1_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_1.Next(textObj, status, 5, 15, 353, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-6  
        private bool eventCallback1_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase1_1.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.FadeStart();
                phase1_2.Next(textObj, status, 7, 9, 29, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-7
        private bool eventCallback1_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 8, 9, 96, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }

            // ͎Oł̂łł[
            return true;
        }

        /// 1-8
        private bool eventCallback1_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 9, 9, 163, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-9
        private bool eventCallback1_9(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 10, 9, 197, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-10
        private bool eventCallback1_10(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 11, 9, 231, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-11
        private bool eventCallback1_11(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 12, 9, 298, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-12
        private bool eventCallback1_12(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 13, 9, 332, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 1-13
        private bool eventCallback1_13(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase1_2.Next(textObj, status, 14, 9, 366, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        // ========================================================================================== //
        // =================================     PHASE 2 - 2     ==================================== //
        // ========================================================================================== //
        /// 2-1 l
        private bool eventCallback2_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase1_2.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1.FadeStart();
                phase2_1.Next(textObj, status, 16, 11, 132, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-2 
        private bool eventCallback2_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1.Next(textObj, status, 17, 11, 199, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-3 
        private bool eventCallback2_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1.Next(textObj, status, 18, 11, 233, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-4
        private bool eventCallback2_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1.Next(textObj, status, 19, 11, 267, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 2-5@
        private bool eventCallback2_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_1.Next(textObj, status, 20, 11, 301, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        /// 2-6  ɒÉ
        private bool eventCallback2_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase2_1.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.FadeStart();
                phase2_2.Next(textObj, status, 22, 6, 15, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-7
        private bool eventCallback2_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 23, 6, 82, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-8
        private bool eventCallback2_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 24, 6, 149, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-9
        private bool eventCallback2_9(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 25, 6, 183, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-10
        private bool eventCallback2_10(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 26, 6, 217, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-11
        private bool eventCallback2_11(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 27, 6, 251, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 2-12
        private bool eventCallback2_12(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 28, 6, 285, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        /// 2-13
        private bool eventCallback2_13(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase2_2.Next(textObj, status, 29, 6, 319, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        // ========================================================================================== //
        // =================================     PHASE 3 - 1     ==================================== //
        // ========================================================================================== //

        /// 3-1 
        private bool eventCallback3_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase2_2.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1.FadeStart();
                phase3_1.Next(textObj, status, 31, 15, 47, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-2
        private bool eventCallback3_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1.Next(textObj, status, 32, 15, 114, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 3-3
        private bool eventCallback3_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1.Next(textObj, status, 33, 15, 183, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-4
        private bool eventCallback3_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1.Next(textObj, status, 34, 15, 250, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-5
        private bool eventCallback3_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_1.Next(textObj, status, 35, 15, 317, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-6 q
        private bool eventCallback3_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase3_1.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.FadeStart();
                phase3_2.Next(textObj, status, 37, 9, 49, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-7
        private bool eventCallback3_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 38, 9, 118, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }

            // ͎Oł̂łł[
            return true;
        }

        /// 3-8
        private bool eventCallback3_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 39, 9, 185, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-9
        private bool eventCallback3_9(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 40, 9, 219, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-10
        private bool eventCallback3_10(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 41, 9, 253, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-11
        private bool eventCallback3_11(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 42, 9, 287, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-12
        private bool eventCallback3_12(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 43, 9, 321, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 3-13
        private bool eventCallback3_13(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase3_2.Next(textObj, status, 44, 9, 355, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        // ========================================================================================== //
        // =================================     PHASE 2 - 2     ==================================== //
        // ========================================================================================== //
        /// 4-1 U
        private bool eventCallback4_1(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase3_2.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1.FadeStart();
                phase4_1.Next(textObj, status, 46, 11, 49, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-2 
        private bool eventCallback4_2(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1.Next(textObj, status, 47, 11, 109, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-3 
        private bool eventCallback4_3(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1.Next(textObj, status, 48, 11, 169, 20);

                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-4
        private bool eventCallback4_4(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1.Next(textObj, status, 49, 11, 229, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }
        /// 4-5@
        private bool eventCallback4_5(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_1.Next(textObj, status, 50, 11, 289, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        /// 4-6 ͎q
        private bool eventCallback4_6(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {

            // ÕtF[YI点Ă
            phase4_1.FadeEnd();

            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.FadeStart();
                phase4_2.Next(textObj, status, 52, 6, 15, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-7
        private bool eventCallback4_7(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 53, 6, 82, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-8
        private bool eventCallback4_8(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 54, 6, 182, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-9
        private bool eventCallback4_9(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 55, 6, 216, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-10
        private bool eventCallback4_10(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 56, 6, 250, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-11
        private bool eventCallback4_11(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 57, 6, 284, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        /// 4-12
        private bool eventCallback4_12(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                //Log.print("AYAKO t7!! START");
                phase4_2.Next(textObj, status, 58, 6, 318, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }


        /// 4-13
        private bool eventCallback4_13(IScreen screen, TextObj textObj, long hitTime,
            HitStatus status)
        {
            // Xe[^XJEg
            CountHitStatus(status);
            if (IsHitedStatus(status))
            {
                phase4_2.Next(textObj, status, 59, 6, 385, 20);
                hitEffects.Add(CreateHitEffect(textObj));
            }
            // ͎Oł̂łł[
            return true;
        }

        #endregion


    }
}