using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;
using Yamalib.GUI;
using Yanesdk.GUIParts;
using Yamalib.Util;
using Yamalib.Draw;
using Yanesdk.Draw;

namespace Kyojin.Component.Option
{
    public class KeyConfigDialog : TextureDialog
    {
        #region otB[h

        private IKeyInput m_srcKey;
        private int m_selectIndex = 0;
        private List<int> m_buttonNum = new List<int>();

        #endregion

        /// <summary>
        /// _CAO{bNXĕԋp
        /// </summary>
        /// <param name="dlgRes"></param>
        /// <param name="defFilename"></param>
        /// <param name="mouse"></param>
        /// <param name="key"></param>
        /// <param name="prevKeyNo"></param>
        /// <param name="nextKeyNo"></param>
        /// <returns></returns>
        public static new KeyConfigDialog CreateDialogBox(DialogBoxResources dlgRes, string defFilename, ControlContext cc,
            IKeyInput key, int prevKeyNo, int nextKeyNo)
        {
            Properties prop = Properties.GetInstance(defFilename);

            int sx = (int)prop.GetPropertyNum(C_PROP_KEY_SIZEX, 320);
            int sy = (int)prop.GetPropertyNum(C_PROP_KEY_SIZEY, 240);
            string msg = prop.GetProperty(C_PROP_KEY_MESSAGE);
            int mox = (int)prop.GetPropertyNum(C_PROP_KEY_MESSAGE_OX, 0);
            int moy = (int)prop.GetPropertyNum(C_PROP_KEY_MESSAGE_OY, 0);
            string actCol = prop.GetProperty(C_PROP_KEY_BUTTON_ACTIVE); ;
            string nonActCol = prop.GetProperty(C_PROP_KEY_BUTTON_NON_ACTIVE);
            List<string> buttonNm = GetButtonText(prop);
            int titleType = (int)prop.GetPropertyNum(C_PROP_KEY_TITLE_TYPE, 0);
            int dlgAlpha = (int)prop.GetPropertyNum(C_PROP_KEY_DLG_ALPHA, 255);
            prevKeyNo = (int)prop.GetPropertyNum(C_PROP_KEY_TAB_PREV, prevKeyNo);
            nextKeyNo = (int)prop.GetPropertyNum(C_PROP_KEY_TAB_NEXT, nextKeyNo);

            // _CAO{bNX̕\ʒu
            int dx = (int)prop.GetPropertyNum(C_PROP_KEY_POSX, 0);
            int dy = (int)prop.GetPropertyNum(C_PROP_KEY_POSY, 0);
            // ̍W͉Ӗ邩(A)
            int pos_base = (int)prop.GetPropertyNum(C_PROP_KEY_POS_BASE, 0);

            // w肳ꂽ\ʒu͊_
            if (0 != pos_base)
            {
                switch (pos_base)
                {
                    case 1:
                        // 
                        dx -= sx / 2;
                        dy -= sy / 2;
                        break;
                    default:
                        // ȂĂȂ...
                        break;
                }
            }

            // ȂƂ񂩂
            dlgRes.TitleTile = new TileTexture(null, TileTexture.TILE_TYPE.H_LINE3);

            KeyConfigDialog dialog = new KeyConfigDialog();
            dialog.SetDialogBoxResources(dlgRes);

            // KeyGroupŎgpL[ƎgpL[ԍݒ
            dialog.SetKey(key, prevKeyNo, nextKeyNo);
            dialog.SetDialogSize(sx, sy);
            dialog.SetXY(dx, dy);
            dialog.SetXYOffsetType(TextureDialog.POS_OFFSET.LEFT_TOP);
            dialog.SetTitleType((TextureDialog.TITLE)titleType);
            dialog.SetDialogAlpha(dlgAlpha);

            if (0 != msg.Length)
            {
                ITexture t = SetMessageText(dlgRes.MessageFont, msg);
                dialog.SetMessageTexture(t, mox, moy, true);
            }

            int box, boy;

            int i = 0;
            foreach (string btLabel in buttonNm)
            {
                GetButtonXY(prop, i, out box, out boy);
                FontButton bt = CreateButton(cc,
                                    dlgRes.ButtonLabelFontLoader,
                                    dlgRes.ButtonLabelFontLoaderNo,
                                    btLabel, actCol, nonActCol, dlgRes.CursorTile);
                dialog.AddButton(bt, cc, dx + box, dy + boy);
                if (0 == i)
                {
                    bt.IsForceActive = true;
                }
                ++i;
            }

            dialog.SrcKey = key;

            return dialog;
        }

        public IKeyInput SrcKey
        {
            get { return m_srcKey; }
            set { m_srcKey = value; }
        }

        /// ړ
        public new void OnPaint(IScreen scr, ControlContext cc, int x, int y)
        {
            base.OnPaint(scr, cc, x, y);

            /// IĂ牽Ȃ
            if (IsFinish())
            {
                return;
            }

            int buttonNum = m_srcKey.ButtonNum;
            bool hit = false;
            for (int i = 0; i < buttonNum; ++i)
            {
                if (m_srcKey.IsPush(i))
                {

                    if (IsRegKey(i))
                    {
                        // łɓo^ĂL[
                        //Log.print("KeyConfigDialog#OnMove : already registrated! : %s", i);
                        continue;
                    }

                    hit = true;
                    m_buttonNum.Add(i);
                    break;
                }
            }

            if (hit)
            {
                FontButton bt = GetButton()[m_selectIndex].Parts as FontButton;
                bt.IsForceActive = false;
                ++m_selectIndex;
                if (GetButton().Count > m_selectIndex)
                {
                    bt = GetButton()[m_selectIndex].Parts as FontButton;
                    bt.IsForceActive = true;
                }
            }

        }

        /// ԂԂɖ߂܂
        public void Reset()
        {
            m_selectIndex = 0;
            m_buttonNum.Clear();
        }

        /// ݒ肳ꂽ{^ID擾
        public List<int> GetKeyButtonIDs()
        {
            return this.m_buttonNum;
        }

        /// I
        public bool IsFinish()
        {
            return m_buttonNum.Count == GetButton().Count;
        }

        /// łɓo^ĂL[ԍH
        private bool IsRegKey(int btNo)
        {
            foreach (int no in m_buttonNum)
            {
                if (no == btNo)
                {
                    return true;
                }
            }
            return false;
        }


        /// {^𐶐
        private static FontButton CreateButton(ControlContext cc, FontLoader fl, int fontno,
                    string text, string colorOn, string colorOff, TileTexture bgTex)
        {
            FontButton bt = new FontButton(fl, fontno);
            bt.OnInit(cc);
            bt.SetText(text);
            bt.SetColor(YanesdkUtil.ToColor4ub(colorOn), YanesdkUtil.ToColor4ub(colorOff));
            bt.OnClick += null;
            return bt;
        }


    }
}
