using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Draw;
using Yanesdk.Ytl;
using Yamalib.Model;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Util;
using System.Diagnostics;
using Yamalib.Scenario;
using Yamalib.Scenario.YaneScript;

namespace Kyojin.Component.Scenario
{

    /// <summary>
    /// wi\R}h
    /// </summary>
    public class KyojinBgCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_BG_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;

        private static readonly int BG_NO = 1;
        private static readonly int EFFECT_NO = 2;
        private static readonly int EFFECT_SPEED = 3;
        private static readonly int WAIT_FLG = 4;

        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private int imgNo = INVALID_BG_VALUE;
        private int effectNo = INVALID_EFFECT_NO;
        private int effectSpeed;
        private bool waitFlg;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinBgCommandHandler()
        {
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            imgNo = TagUtil.GetPramInt(tagParam, BG_NO, INVALID_BG_VALUE);
            //effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            // eNN `̕
            string effectNoStr = TagUtil.GetPram(tagParam, EFFECT_NO, null);
            if (null == effectNoStr)
            {
                effectNo = INVALID_EFFECT_NO;
            }
            else
            {

                try
                {
                    effectNo = Convert.ToInt32(effectNoStr.Substring(1));
                }
                catch (Exception)
                {
                    Debug.Assert(false, "ȔwiGtFNgԍw肳ꂽF" + effectNoStr);
                    effectNo = 0;
                }

                // lł̓GtFNgԍ 1 n܂邽߂P炷
                effectNo -= 1;
            }

            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            //waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);
            waitFlg = TagUtil.GetPramInt(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG ? 1 : 0) == 1;

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Excecuting(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (INVALID_BG_VALUE == imgNo)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// wi\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;


            model.BgImgMgr.BgImgNo = imgNo;
            model.BgImgMgr.SetEffect(effectNo, 0, TransBltter.PAHSE_MAX, effectSpeed);

            if (waitFlg)
            {
                model.ScenarioState.BgEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// s
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Excecuting(IScenarioModel model)
        {
            if (model.BgImgMgr.IsEffecting)
            {
                return YanesdkResult.NoError;
            }

            model.ScenarioState.BgEffectWaitFlg = false;

            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }



    /// <summary>
    /// LN^[\R}h
    /// </summary>
    public class KyojinCharaInCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 3;

        private static readonly int CHARACTER_ID = 1;
        private static readonly int PRESET_POS = 2;
        private static readonly int SLIDE_VALUE = 3;
        private static readonly int EFFECT_NO = 4;
        private static readonly int EFFECT_SPEED = 5;
        private static readonly int COLOR = 6;
        private static readonly int WAIT_FLG = 7;
        private static readonly int REPLACE_CHARACTER_ID = 8;

        private static readonly int INVALID_SLIDE_VALUE = 0;
        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly String DEFAULT_COLOR = "FFFFFFFF";
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private String characterId;
        private String presetPosition;
        private int slideOffsetValue;
        private int effectNo;
        private int effectSpeed;
        private String color;
        private bool waitFlg;
        private String replaceCharacterId;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinCharaInCommandHandler()
        {
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            characterId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);
            presetPosition = TagUtil.GetPram(tagParam, PRESET_POS, null);
            slideOffsetValue = TagUtil.GetPramInt(tagParam, SLIDE_VALUE, INVALID_SLIDE_VALUE);

            //effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            // eNN `̕
            string effectNoStr = TagUtil.GetPram(tagParam, EFFECT_NO, null);
            if (null == effectNoStr)
            {
                effectNo = INVALID_EFFECT_NO;
            }
            else
            {
                effectNo = Convert.ToInt32(effectNoStr.Substring(1)); ;
                // lł̓GtFNgԍ 1 n܂邽߂P炷
                effectNo -= 1;
            }

            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            color = TagUtil.GetPram(tagParam, COLOR, DEFAULT_COLOR);
            //waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);
            waitFlg = TagUtil.GetPramInt(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG ? 1 : 0) == 1;
            replaceCharacterId = TagUtil.GetPram(tagParam, REPLACE_CHARACTER_ID, null);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == characterId || null == presetPosition)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;

            Character character = null;
            Console.WriteLine("charain : new {0}, replace {1}", characterId, replaceCharacterId);
            if (null != replaceCharacterId)
            {
                // u
                // AVKLN^[̂قłΏĂ
                Character newCharacter = model.CharacterImgMgr.GetCharacterImage(characterId) as Character;
                if (null != newCharacter)
                {
                    newCharacter.Reset();
                }
                character = model.CharacterImgMgr.GetCharacterImage(replaceCharacterId) as Character;
            }
            else
            {
                // VK
                // ̃LN^[d݂ȂƂۏ؂
                character = model.CharacterImgMgr.GetCharacterImage(characterId) as Character;
                // tF[hAEgɎ擾ÃCX^X擾Ă邱ƂɂȂ̂ŁAÔߏ
                if (null != character)
                {
                    character.Reset();
                }
                character = model.CharacterImgMgr.GetNewCharacterImage(characterId) as Character;
            }

            if (null == character)
            {
                Debug.Assert(null != character, "`̃LN^[ID : " + characterId);
                return YanesdkResult.InvalidParameter;
            }

            // ʒu
            character.PresetPos = Character.ToPresetPos(this.presetPosition);

            // GtFNg
            if (INVALID_EFFECT_NO != effectNo)
            {
                if (null != replaceCharacterId)
                {
                    if (IsCharaPoseChange(replaceCharacterId, characterId))
                    {
                        // |[YύX
                        character.SetEffectReplace(characterId, effectNo, effectSpeed, effectNo, effectSpeed);
                    }
                    else
                    {
                        // \ύX
                        character.SetEffectReplace(characterId, 22, effectSpeed, 23, calcAlphaStep(effectSpeed));
                    }
                }
                else
                {
                    character.SetEffect(effectNo, 0, TransBltter.PAHSE_MAX, effectSpeed);
                }
            }
            // LN^[J[
            character.Color = YanesdkUtil.ToColor4ub(color);
            // XCh
            if (INVALID_SLIDE_VALUE != slideOffsetValue)
            {
                character.SetSlide(slideOffsetValue, 1);
            }

            if (waitFlg)
            {
                model.ScenarioState.CharacterEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            Character[] characters = ((YaneCharacterManager)model.CharacterImgMgr).CharacterContainer;
            foreach (Character chara in characters)
            {
                if (chara.IsEffecting)
                {
                    return YanesdkResult.NoError;
                }
            }
            model.ScenarioState.CharacterEffectWaitFlg = false;
            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        /// IDF|[YύXꂽԋp
        /// LN^[ʎq(a-z,A-Z){LN^[|[Yʎq(1-9)P{\ʎq(1-9)Q
        private static bool IsCharaPoseChange(string charNow, string charPre)
        {
            // LႤ̂ł΁AׂĈႤ͂
            if (GetCharaIDName(charNow) != GetCharaIDName(charPre))
            {
                return true;
            }
            string nowNum = GetCharaIDNumber(charNow);
            string preNum = GetCharaIDNumber(charPre);

            // |[Yʎqʂł邩H
            return nowNum.ToCharArray()[0] != preNum.ToCharArray()[0];
        }

        /// LN^[IDIDԍԋp
        private static string GetCharaIDNumber(string charId)
        {
            StringBuilder numBuffer = new StringBuilder();
            foreach (char c in charId.ToCharArray())
            {
                if (!char.IsNumber(c))
                {
                    continue;
                }
                numBuffer.Append(c);
            }
            return numBuffer.ToString();
        }

        /// LN^[IDIDʎqԋp
        private static string GetCharaIDName(string charId)
        {
            StringBuilder numBuffer = new StringBuilder();
            foreach (char c in charId.ToCharArray())
            {
                if (char.IsNumber(c))
                {
                    break;
                }
                numBuffer.Append(c);
            }
            return numBuffer.ToString();
        }


        /// w肵XebvŁARootCounter𓮍삳ƂɁAŏI[ɒB邩ԋp
        private static int calcAlphaStep(int step)
        {
            if (0 == step)
            {
                step = 1;
            }
            int result;
            if (0 > step)
            {
                result = (255 * (step + 1)) + step;
                return result;
            }
            else
            {
                result = 255 / step;
                return (255 % step) == 0 ? result : result + 1;
            }
        }

        #endregion
    }


    /// <summary>
    /// LN^[\R}h
    /// </summary>
    public class KyojinCharaOutCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 3;

        private static readonly int CHARACTER_ID = 1;
        private static readonly int SLIDE_VALUE = 2;
        private static readonly int EFFECT_NO = 3;
        private static readonly int EFFECT_SPEED = 4;
        private static readonly int COLOR = 5;
        private static readonly int WAIT_FLG = 6;

        private static readonly int INVALID_SLIDE_VALUE = 0;
        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly String DEFAULT_COLOR = "FFFFFFFF";
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private String characterId;
        private int slideOffsetValue;
        private int effectNo;
        private int effectSpeed;
        private String color;
        private bool waitFlg;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinCharaOutCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                Debug.Assert(false);
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            characterId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);
            slideOffsetValue = TagUtil.GetPramInt(tagParam, SLIDE_VALUE, INVALID_SLIDE_VALUE);
            //effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            // eNN `̕
            string effectNoStr = TagUtil.GetPram(tagParam, EFFECT_NO, null);
            if (null == effectNoStr)
            {
                effectNo = INVALID_EFFECT_NO;
            }
            else
            {
                effectNo = Convert.ToInt32(effectNoStr.Substring(1));
                // lł̓GtFNgԍ 1 n܂邽߂P炷
                effectNo -= 1;
            }

            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            color = TagUtil.GetPram(tagParam, COLOR, DEFAULT_COLOR);

            //waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);
            waitFlg = TagUtil.GetPramInt(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG ? 1 : 0) == 1;

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == characterId)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;

            Character character = model.CharacterImgMgr.GetCharacterImage(characterId) as Character;

            Console.WriteLine("charaout : {0}", characterId);
            if (null == character)
            {
                Debug.Assert(false, "LN^[擾łȂ" + characterId);
                return YanesdkResult.PreconditionError;
            }

            // GtFNg
            if (INVALID_EFFECT_NO != effectNo)
            {
                character.SetEffect(effectNo, TransBltter.PAHSE_MAX, 0, effectSpeed);
            }
            else
            {
                // 
                character.Reset();
            }
            // LN^[J[
            character.Color = YanesdkUtil.ToColor4ub(color);
            // XCh
            if (INVALID_SLIDE_VALUE != slideOffsetValue)
            {
                character.SetSlide(slideOffsetValue, 1);
            }

            if (waitFlg)
            {
                model.ScenarioState.CharacterEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            Character[] characters = ((YaneCharacterManager)model.CharacterImgMgr).CharacterContainer;
            foreach (Character chara in characters)
            {
                if (chara.IsEffecting)
                {
                    return YanesdkResult.NoError;
                }
            }
            model.ScenarioState.CharacterEffectWaitFlg = false;
            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }


    /// <summary>
    /// {CXĐR}h
    /// </summary>
    public class KyojinVoicePlayCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_VOICE_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int VOICE_NO_INDEX = 1;
        private static readonly int VOICE_VOLUME = 2;
        private static readonly int VOICE_FADE_TIME = 3;

        #endregion


        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private string voiceID = null;
        private int voiceNo = INVALID_VOICE_VALUE;
        private float voiceVolume = 1.0f;
        private int fadeTime = INVALID_VOICE_VALUE;
        private Dictionary<string, int> voiceNoMap;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinVoicePlayCommandHandler(Dictionary<string, int> voiceNoMap)
        {
            this.voiceNoMap = voiceNoMap;
        }

        /// <summary>
        /// lł̓{CXwIDɂčsĂB
        /// ]IDƃ{CXNOƂ̃}bsOsKvB
        /// ̃}bsOɎgpID -> VOICE_NO ̃}bv 
        /// </summary>
        public Dictionary<string, int> VoiceNoMap
        {
            get { return voiceNoMap; }
            set { voiceNoMap = value; }
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            voiceID = TagUtil.GetPram(tagParam, VOICE_NO_INDEX, null);
            if (null == voiceID || !VoiceNoMap.ContainsKey(voiceID))
            {
                execState = CommandState.DONE;
                Yamalib.Logger.CommonLogWriter.Write("ScriptTagWarning - `̃{CXID:" + voiceID);
                return YanesdkResult.InvalidParameter;
            }

            voiceNo = VoiceNoMap[voiceID];
            voiceVolume = TagUtil.GetPramInt(tagParam, VOICE_VOLUME, Sdl.SDL.MIX_MAX_VOLUME) / (float)Sdl.SDL.MIX_MAX_VOLUME; ;
            fadeTime = TagUtil.GetPramInt(tagParam, VOICE_FADE_TIME, 0);
            if (0 == fadeTime)
            {
                fadeTime = INVALID_VOICE_VALUE;
            }

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu̐ݒ擾
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}hǉ
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (voiceNo == INVALID_VOICE_VALUE)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// SEĐ
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            // {CX͉sɍsĂ͂Ȃ
            // ̂ +1 邱ƂōĐʒû␳Ă
            // ܂ǂȂ
            if (model.ShowTextCount < ExecPosition + 1)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_VOICE_VALUE == fadeTime)
            {
                result = model.VoiceMgr.PlayVoice(voiceNo, voiceVolume);
            }
            else
            {
                result = model.VoiceMgr.PlayVoiceFade(voiceNo, voiceVolume, fadeTime);
            }

            execState = CommandState.DONE;

            if (YanesdkResult.NoError != result)
            {
                Yamalib.Logger.CommonLogWriter.Write("VoicePlayError : " + result.ToString());
            }

            return result;
        }

        #endregion
    }

    /// <summary>
    /// ʃV[ւ̑JڃR}h
    /// </summary>
    public class KyojinNextSceneCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 1;
        private static readonly int CHARACTER_ID = 1;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private string sceneId;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinNextSceneCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// ݒ肳ĂV[IDԋp
        /// </summary>
        public string SceneId
        {
            get { return sceneId; }
            set { sceneId = value; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            SceneId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == SceneId)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;
            if (CommandProsser != null)
            {
                result = CommandProsser(this, model);
            }
            execState = CommandState.DONE;

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            return YanesdkResult.NoError;
        }

        #endregion
    }


    /// <summary>
    /// ʃV[ւ̑JڃR}h
    /// </summary>
    public class SelectCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int CHARACTER_ID = 1;
        private static readonly int SCENE_ID = 2;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private string sceneId;
        private string choices;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public SelectCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// ݒ肳ĂV[IDԋp
        /// </summary>
        public string SceneId
        {
            get { return sceneId; }
            set { sceneId = value; }
        }

        /// <summary>
        /// I}̕
        /// </summary>
        public string Choices
        {
            get { return choices; }
            set { choices = value; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            SceneId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);
            Choices = TagUtil.GetPram(tagParam, SCENE_ID, null);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == SceneId || Choices == null)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;
            if (CommandProsser != null)
            {
                result = CommandProsser(this, model);
            }
            execState = CommandState.DONE;

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            return YanesdkResult.NoError;
        }

        #endregion
    }



}
