using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Util;
using Yanesdk.Draw;
using Yanesdk.GUIParts;
using Yanesdk.Input;
using Yamalib.GUI;
using Yamalib.Input;

namespace Kyojin.Component.Scenario
{
    //public class MenuItem
    //{
    //    public TextureGUIControl.Control GUIControl
    //    {
    //        Get { return control; }
    //        Set { control = value; }
    //    }

    //    public virtual void OnMove(Screen screen)
    //    {
    //    }

    //    public virtual void OnDraw(Screen screen) {
    //    }


    //}

    public class PartialMenuItem
    {

        private TextureGUIControl.Control control;
        public TextureGUIControl.Control GUIControl
        {
            get { return control; }
            set
            {
                control = value;
                if (null != control)
                {
                    originalX = control.X;
                    originalY = control.Y;
                }
            }
        }

        /// ړ
        public void OnMove(IScreen screen)
        {
            if (!m_offset.IsEnd)
            {
                m_offset++;

                control.X = originalX + m_offset.Value();
                control.Y = originalY;
                //control.setXYOffset(m_offset.Value(), 0);
                if (m_offset.IsEnd)
                {
                    m_show = false;
                    m_hide = false;
                }
            }

            //base.OnMove(screen);
        }

        /// ړH
        public bool IsMoving()
        {
            return !this.m_offset.IsEnd;
        }
        /// \
        public bool IsShow()
        {
            return this.m_show;
        }
        /// \H
        public bool IsHide()
        {
            return this.m_hide;
        }

        /// `[ŏ
        public void HideNow()
        {
            Hide();
            control.X = originalX + m_offset.EndValue;
            control.Y = originalY;
            //control.setXYOffset(m_offset.EndValue, 0);
            m_show = m_hide = false;
        }

        /// Xebv
        public void SetHideStep(int step_)
        {
            m_hideStep = step_;
            m_offset.StepValue = m_hideStep;
        }

        /// \
        public void Show()
        {
            if (m_show && IsMoving())
            {
                return;
            }

            m_show = true;
            m_hide = false;

            int ox = control.X - originalX;
            //control.getXYOffset(ox, oy);
            m_offset.Set(ox, 0, m_hideStep);
        }

        /// \
        public void Hide()
        {
            if (m_hide && IsMoving())
            {
                return;
            }

            m_hide = true;
            m_show = false;

            int ox = control.X - originalX;
            m_offset.Set(ox, 640 - originalX, m_hideStep);
        }

        /// RXgN^
        public PartialMenuItem()
            : base()
        {
            m_offset = new InteriorCounter();
            m_offset.Set(0, 0, DEFAULT_SPEED);
            m_hideStep = DEFAULT_SPEED;
        }


        private int originalX;
        private int originalY;
        private const int DEFAULT_SPEED = 60;
        private bool m_show;
        private bool m_hide;
        private int m_hideStep;
        private InteriorCounter m_offset;
    }


    public class PartialMenuBar : ITextureGUI
    {
        #region 萔l

        public enum eHideType : int { TOP = 0, LEFT, BOTTOM, RIGHT, FADE };

        #endregion

        #region otB[h

        private IMouseInput mouse;
        private eHideType eType;
        private bool m_autoHide;
        private int x;
        private int y;
        private RootCounterS m_alpha;

        private TextureGUIControl.Control m_indicator;
        private FreeLineCounter m_offset;
        //	InteriorCounter m_offset;
        private int m_hideStep;
        private int m_hideWait;
        private int m_indOx;
        private int m_indOy;
        private bool visible = true;
        private List<PartialMenuItem> m_items;
        private ControlContext ctrlContext;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public PartialMenuBar()
        {
            m_autoHide = true;
            x = y = 0;
            m_alpha = new RootCounterS(255, 255, 0);
            m_hideStep = 1;
            m_offset = new FreeLineCounter(new InteriorCounter());
            eType = eHideType.RIGHT;
            m_items = new List<PartialMenuItem>();
            m_hideStep = 60;
        }

        #region ITextureGUI o

        public void OnInit(ControlContext cc)
        {
            ctrlContext = cc;
            FocusableGUIParam param = ctrlContext.Param as FocusableGUIParam;
            if (null != param)
            {
                mouse = param.Mouse;
            }
        }

        public void OnPaint(IScreen scr, ControlContext cc, int x, int y)
        {
            OnMove(scr);
            OnDraw(scr);
        }

        public bool Visible
        {
            get { return visible; }
            set { visible = value; }
        }

        #endregion


        /// {ʒu̐ݒ
        public void SetPos(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// `[NCWP[^{^ݒ肷
        public void SetIndicator(TextureGUIControl.Control bt_, int ox_, int oy_)
        {
            m_indicator = bt_;

            m_offset.Set(0, ox_, m_hideStep);
            m_indOx = ox_;
            m_indOy = oy_;
        }

        /// j[{^̒ǉ
        public void AddItem(PartialMenuItem bt_)
        {
            bt_.SetHideStep(m_hideStep);
            m_items.Add(bt_);
        }

        /// j[ACe̎擾
        public List<PartialMenuItem> GetItems()
        {
            return this.m_items;
        }

        /// j[{^j܂
        public void ClearItems()
        {
            m_items.Clear();
        }

        /// I[gB̐ݒ
        public void SetAutoHide(bool b_, int type_, int step, int waitTime)
        {
            m_autoHide = b_;
            m_hideWait = waitTime;
            eType = (eHideType)type_;
            SetHideStep(step);
        }

        /// 鑬x̐ݒ
        public void SetHideStep(int step_)
        {
            m_hideStep = step_;
            foreach (PartialMenuItem item in m_items)
            {
                item.SetHideStep(m_hideStep);
            }
        }

        /// j[o[Ƀ}EXĂ邩
        public bool IsInBar()
        {
            foreach (PartialMenuItem item in m_items)
            {
                FocusableTextureButton bt = item.GUIControl.Parts as FocusableTextureButton;
                if (bt.IsHover)
                {
                    return true;
                }
            }

            FocusableTextureButton indicatorBt = m_indicator.Parts as FocusableTextureButton;
            if (indicatorBt != null)
            {
                return indicatorBt.IsHover;
            }

            return false;
        }

        /// j[\܂
        public void Show()
        {
            PartialMenuItem it = m_items[0];
            bool b = it.IsShow();

            foreach (PartialMenuItem item in m_items)
            {
                item.Show();
            }

            if (b != it.IsShow())
            {
                //int ox, oy;
                //m_indicator.getXYOffset(ox, oy);
                //m_offset.Set(ox, 0, m_hideStep);
            }
        }

        /// j[B܂
        public void Hide()
        {
            PartialMenuItem it = m_items[0];
            bool b = it.IsHide();

            foreach (PartialMenuItem item in m_items)
            {
                item.Hide();
            }

            if (b != it.IsHide())
            {
                //int ox, oy;
                //m_indicator.getXYOffset(ox, oy);
                //m_offset.Set(ox, m_indOx, m_hideStep);
            }
        }

        public bool IsShow()
        {
            foreach (PartialMenuItem item in m_items)
            {
                if (item.IsMoving() || !item.IsShow())
                {
                    return false;
                }
            }
            return true;
        }

        public bool IsHide()
        {
            foreach (PartialMenuItem item in m_items)
            {
                if (item.IsMoving() || !item.IsHide())
                {
                    return false;
                }
            }
            return true;
        }


        /// Ƀj[B܂
        public void HideNow()
        {
            PartialMenuItem it = (PartialMenuItem)m_items[0];
            bool b = it.IsHide();

            foreach (PartialMenuItem item in m_items)
            {
                item.HideNow();
            }

            if (b != it.IsHide())
            {
                //int ox, oy;
                //m_indicator.getXYOffset(ox, oy);
                //m_offset.Set(ox, m_indOx, m_hideStep);
            }
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            m_alpha++;

            foreach (PartialMenuItem item in m_items)
            {
                item.OnMove(screen);
            }

            m_offset.Inc();

            // lΉ CWP[^͓Ȃ
            //		m_indicator.setXYOffset( m_offset.Get(), 0 );

            PartialMenuItem aItem = m_items[0];
            bool aShow = aItem.IsShow();
            bool aHide = aItem.IsHide();

            //m_indicator.OnMove(screen);
            FocusableTextureButton indicatorBt = m_indicator.Parts as FocusableTextureButton;

            if (m_autoHide)
            {
                if (!aShow && indicatorBt.IsHover)
                {
                    Show();
                }
                if (!IsInBar())
                {
                    Hide();
                }
            }
            else
            {
                // {^
                if (indicatorBt.IsDown)
                {
                    Hide();
                }
            }
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {
            //            m_indicator.OnDraw(screen);
            m_indicator.Parts.OnPaint(screen, ctrlContext, m_indicator.X, m_indicator.Y);

            foreach (PartialMenuItem item in m_items)
            {
                item.GUIControl.Parts.OnPaint(screen, ctrlContext, item.GUIControl.X, item.GUIControl.Y);
                //item.OnDraw(screen);
            }

        }

    }


}
