using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yamalib.Input;
using Yanesdk.Draw;
using Kyojin.Component.MusicRoom;
using Yanesdk.Sound;
using Yamalib.GUI;
using Yanesdk.GUIParts;
using Yanesdk.Input;
using Yamalib.Util;

namespace Kyojin.Scene.MusicRoom
{
    class MusicRoomScene : TaskBase, IDisposable
    {
        #region 萔l

        #endregion

        #region otB[h

        private GameSystem m_gSys;
        private bool init;
        private IMouseInput m_mouse;

        private MainParts m_mainCtl;	//!< vC[
        private PlayList m_playList;	//!< vCXg
        private TitleParts m_title;			//!< ^Cg
        private Description m_desc;		//!< 

        private int m_playNo;

        private TextureLoader m_tlTitle;	//!< y^Cg摜
        private TextureLoader m_tlBg;		//!< wi摜


        #endregion

        public MusicRoomScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
        }


        #region IDisposable o

        public void Dispose()
        {
            m_mainCtl = null;
            m_playList = null;
            m_title = null;
            m_desc = null;
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnMove(GameSystem gameSystem)
        {
            if (!init)
            {
                OnInit();
                m_mainCtl.OnMove(m_gSys.Screen);
                m_mainCtl.SetVolume(m_gSys.OptionInfo.BGMVolume);
                init = true;
            }

            m_mouse.Update();
            m_gSys.Key.Update();

            // ړ
            m_mainCtl.OnMove(m_gSys.Screen);
            m_title.OnMove(m_gSys.Screen);
            m_desc.OnMove(m_gSys.Screen);
            m_playList.OnMove(m_gSys.Screen);

            // vCXgŃNGXgI
            if (m_playList.IsNewSelected())
            {
                m_mainCtl.SetPlayNum(m_playList.GetSelectedNum());
            }
            else
            {
                m_playList.SetSelect(m_mainCtl.GetPlayNum());
            }

            int no = m_mainCtl.GetLastPlayNo();

            if (no != m_playNo)
            {
                m_title.SetTexture(m_tlTitle.GetTexture(no));
                m_desc.SetDescNo(no);
                m_playNo = no;
            }

            // IvH
            if (m_mainCtl.IsExitReq())
            {
                ReturnTask();
                return 0;
            }

            return 1;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {
            if (!init)
            {
                // Rg[͕KonMoveɌĂяoƂۏ؂Ȃ
                return;
            }
            m_gSys.Screen.Clear();

            m_playList.OnDraw(m_gSys.Screen);
            m_title.OnDraw(m_gSys.Screen);
            m_desc.OnDraw(m_gSys.Screen);
            m_mainCtl.OnDraw(m_gSys.Screen);
        }

        #region Jo

        /// Lq
        private void OnInit()
        {
            // uhnj
            m_gSys.Screen.BlendSrcAlpha();

            m_mouse = m_gSys.KeyDecolateMouse;

            // \[Xǂݍ
            m_tlTitle = m_gSys.SmartTextureLoader.LoadDefFile("img2/music/title/img.lst", false);
            m_tlBg = m_gSys.SmartTextureLoader.LoadDefFile("img2/music/bg/img.lst", false);
            SoundLoader bgmloader = m_gSys.SmartSoundLoader.LoadDefFile("img2/music/sound.lst", false);

            m_mainCtl = new MainParts(m_mouse, m_gSys.MouseOriginal, m_gSys.Key, m_gSys.SmartTextureLoader, m_gSys.SmartSoundLoader,
                YanesdkUtil.GetElementNum("img2/music/sound.lst"));
            m_mainCtl.SetSoundLoader(bgmloader);
            m_mainCtl.SetInputDevice(m_gSys.Key, m_mouse);


            ControlContext ctrlContext = new ControlContext();
            ctrlContext.MouseInput = ((NullableMouseInput)m_gSys.Mouse).GetOriginal() as MouseInput;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);

            SimpleListBoxItem.FontRepository.SetLoader(m_gSys.CommonFontLoader, 1);
            SimpleListBoxItem.FontRepository.Max = 1000;
            m_playList = new PlayList(m_mouse, ctrlContext);

            m_title = new TitleParts(m_gSys.Mouse);
            m_title.SetTexture(m_tlTitle.GetTexture(0));

            // 
            m_desc = new Description(m_mouse, m_gSys.CommonFontLoader, KyojinConst.SAVE_TEXT_FONT_NO, KyojinConst.SCENARIO_RUBI_FONT_NO);
            //m_desc.DrawShadow(false);
        }

        /// IĖ߂
        private void ReturnTask()
        {
            // ĂԂƂ̃^XNDispose
            m_gSys.SceneController.ReturnScene();

            // ̃^XN̂ł͂Ȃ񂾂AȂ炵ĂȂƓ{邾낤Ȃ
            if (!m_gSys.CommonBgmLoader.GetSound(0).IsPlaying())
            {
                m_gSys.CommonBgmLoader.GetSound(0).Loop = -1;
                m_gSys.CommonBgmLoader.GetSound(0).Volume = 0.2f;
                m_gSys.CommonBgmLoader.PlayBGM(0);
            }
        }

        #endregion

    }
}
