﻿using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.GUIParts;
using Yanesdk.Draw;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.Sound;
using System.Diagnostics;
using Yamalib.Util;
using Yamalib;
using Kyojin;
using Yamalib.Input;
using Yamalib.GUI;
using Yamalib.Yanesdkext.Draw;
using Yanesdk.Input;

namespace Kyojin.Scene.Title
{
    /// <summary>
    /// スタートメニューのシーン
    /// </summary>
    class TitleScene : TaskBase, IDisposable
    {
        /// メニュー切り替え固有値
        private const int MENU_OFFSET_X = 200;
        private const int MENU_SWITCH_STEP = 8;
        private const int MENU_OUT_INTERVAL = 20;

        /// メインボタンID
        private enum MAIN_BUTTON_ID : int { START = 0, CONTINUE, OPTION, EXIT, EXTRA };
        /// 拡張ボタンID
        private enum EXTRA_BUTTON_ID : int { MUSIC = 0, ENDING, RETURN };

        private static readonly Point[] MENU_POS = new Point[] {
            new Point(420,49),
            new Point(420,89),
            new Point(420,129),
            new Point(420,169),
            new Point(420,209)
        };

        /// タイトル文字画像の描画位置
        private const int TITLE_POS_X = 0;
        private const int TITLE_POS_Y = 32;
        /// 背景の描画矩形
        private static readonly Rect BG_RECT = new Rect(0, 32, 640, 400);
        /// 説明文を表示する位置
        private const int CAPTION_POS_X = 130;
        private const int CAPTION_POS_Y = 400;
        /// copyright の描画位置
        private const int COPY_POS_X = 451;
        private const int COPY_POS_Y = 372;
        /// ダイアルの描画中心位置
        private const int DIAL_POS_X = 646;
        private const int DIAL_POS_Y = 131;
        private const int DIAL_OUT_POS_OFFSET = 500;

        /** ダイヤルユニークキーＩＤ */
        private const string LC_DID_START = "START";
        private const string LC_DID_CONTINUE = "CONTINUE";
        private const string LC_DID_OPTION = "OPTION";
        private const string LC_DID_EXIT = "EXIT";
        private const string LC_DID_MUSIC = "MUSIC";


        private GameSystem m_gSys;
        private bool m_init;
        private IMouseInput m_mouse;
        //private bool m_destroyTask;	//!< タスク終了フラグ
        private bool m_mainMenu;	    //!< 今表示しているのはメインメニューか
        private bool m_switingMenu;	//!< メニュー切り替え中か？
        private bool m_afterIn;		    //!< スライドイン中
        private int m_lastSelect;	    //!< 最後に選択されたメニューを保持しておき、それをアクティブにする

        private List<TextureGUIControl.Control> m_menuCtrls;
        private List<TextureGUIControl.Control> m_mainCtrls = new List<TextureGUIControl.Control>();
        private List<TextureGUIControl.Control> m_extraCtrls = new List<TextureGUIControl.Control>();

        private FocusableTextureGUIControl activeTextureGuiCtrl;
        private FocusableTextureGUIControl textureGuiCtrlMain = new FocusableTextureGUIControl();
        private FocusableTextureGUIControl textureGuiCtrlExtra = new FocusableTextureGUIControl();
        private ControlContext ctrlContext;

        private ITexture m_imgBg;
        private ITexture m_imgFrame;
        private ITexture m_imgTitle;
        private ITexture m_imgCopyright;
        private TextureLoader m_tlCaption;

        private List<ICounter> m_offsetCounter = new List<ICounter>();
        private List<ICounter> m_mainOxCounter = new List<ICounter>();
        private List<ICounter> m_extraOxCounter = new List<ICounter>();

        private TitleDial m_dial;
        private ICounter m_dialx = new FreeLineCounter(new RootCounterS());
        private ICounter m_dialy = new FreeLineCounter(new RootCounterS());
        //private ICounter m_bgAlpha;
        private ICounter m_titlePhase = new RootCounterS(0, 255, 2);
        private ICounter m_moveStartCount = new InteriorCounter();

        private bool m_intoFlg = true;
        private bool m_toExitFlg;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="system">このアプリ共有で使用するGameSystemインスタンス</param>
        public TitleScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
        }

        /// <summary>
        /// リソースの破棄を行う
        /// </summary>
        public void Dispose()
        {
            m_menuCtrls = null;
            m_mainCtrls = null;
            m_extraCtrls = null;
            activeTextureGuiCtrl = null;
            textureGuiCtrlMain = null;
            textureGuiCtrlExtra = null;
            ctrlContext = null;

            m_offsetCounter = null;
            m_mainOxCounter = null;
            m_extraOxCounter = null;
            m_moveStartCount = null;
            m_titlePhase = null;
            YanesdkUtil.TextureSafeRelease(m_imgBg);
            YanesdkUtil.TextureSafeRelease(m_imgFrame);
            YanesdkUtil.TextureSafeRelease(m_imgTitle);
            YanesdkUtil.TextureSafeRelease(m_imgCopyright);
            m_tlCaption = null;
            m_dial = null;
            m_dialx = null;
            m_dialy = null;
            m_tlCaption = null;
        }

        /// <summary>
        /// タスクの動作
        /// </summary>
        /// <param name="o">ここではGameSystemのインスタンスが渡されることが想定される</param>
        /// <returns>常に１が返却される</returns>
        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            OnMove(gameSystem);
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 移動処理
        /// </summary>
        /// <param name="gameSystem">共通で使用するGameSystemのインスタンス</param>
        private void OnMove(GameSystem gameSystem)
        {
            if (!m_init)
            {
                OnInit();
                m_init = true;
            }

            m_gSys.Key.Update();
            m_gSys.KeyDecolateMouse.Update();
            m_gSys.CommonSeLoader.UpdateSE();

            if (m_intoFlg)
            {
                // 画面イン処理
                m_dialx.Inc();
                m_dialy.Inc();
                if (m_dialx.IsEnd && m_dialy.IsEnd)
                {
                    m_intoFlg = false;
                }
            }
            else if (m_toExitFlg)
            {
                // 画面アウト処理

            }
            else
            {
                activeTextureGuiCtrl.OnMoveFocus();

                // ボタン動作
                OnMoveMenu();

                m_titlePhase.Inc();
            }

            // ダイヤル移動計算
            m_dial.OnMove(gameSystem.Screen);
        }

        /// ボタンの位置を初期化する
        private static void InitPos(List<TextureGUIControl.Control> buttons, List<ICounter> counters)
        {
            int i = 0;
            foreach (ICounter c in counters)
            {
                buttons[i].X = (int)MENU_POS[i].X + c.Value();
                buttons[i].Y = (int)MENU_POS[i].Y;
            }
        }
        /// 全て終端に達したか
        private static bool IsEndAll(List<ICounter> counters)
        {
            foreach (ICounter c in counters)
            {
                if (!c.IsEnd)
                {
                    return false;
                }
            }
            return true;
        }

        private void OnMoveMenu()
        {

            if (m_switingMenu)
            {

                // スタートカウンター
                m_moveStartCount.Inc();

                if (!m_mainMenu)
                {
                    // main -> extra
                    if (!m_afterIn)
                    {
                        int i = 0;
                        // スライドアウト開始
                        foreach (ICounter c in m_mainOxCounter)
                        {
                            if (m_moveStartCount.Value() < i)
                            {
                                break;
                            }
                            c.Inc();
                            m_mainCtrls[i].X = (int)MENU_POS[i].X + c.Value();
                            m_mainCtrls[i].Y = (int)MENU_POS[i].Y;
                            ++i;
                        }
                        // スライドアウト終了か
                        bool outMain = IsEndAll(m_mainOxCounter);

                        // 拡張メニューをスライドインさせる
                        if (outMain)
                        {
                            // メインメニューでアクティブにしていたのを戻す
                            ButtonActive(0, false);

                            m_menuCtrls = m_extraCtrls;
                            activeTextureGuiCtrl = textureGuiCtrlExtra;
                            m_offsetCounter = m_extraOxCounter;

                            SetKeyGroup(m_menuCtrls);

                            m_afterIn = true;

                            InitPos(m_menuCtrls, m_offsetCounter);
                            // 拡張メニューを強制アクティブ

                            ButtonActive(0, true);

                        }
                    }
                    else
                    {
                        int i = 0;
                        foreach (ICounter c in m_extraOxCounter)
                        {
                            if (m_moveStartCount.Value() < i)
                            {
                                break;
                            }
                            c.Inc();
                            m_menuCtrls[i].X = (int)MENU_POS[i].X + c.Value();
                            m_menuCtrls[i].Y = (int)MENU_POS[i].Y;
                            ++i;
                        }
                        // スライドアウト終了か
                        bool inExtra = IsEndAll(m_extraOxCounter);
                        if (inExtra)
                        {
                            activeTextureGuiCtrl.Focus(0);
                            m_afterIn = false;
                            m_switingMenu = false;
                        }
                    }
                }
                else
                {
                    // extra -> main
                    if (!m_afterIn)
                    {
                        // スライドアウト開始
                        int i = 0;
                        foreach (ICounter c in m_extraOxCounter)
                        {
                            if (m_moveStartCount.Value() < i)
                            {
                                break;
                            }
                            c.Inc();
                            m_menuCtrls[i].X = (int)MENU_POS[i].X + c.Value();
                            m_menuCtrls[i].Y = (int)MENU_POS[i].Y;
                            ++i;
                        }
                        // スライドアウト終了か
                        bool outMain = IsEndAll(m_extraOxCounter);

                        // 拡張メニューをスライドインさせる
                        if (outMain)
                        {
                            // メニューでアクティブにしていたのを戻す
                            ButtonActive(0, false);

                            m_menuCtrls = m_mainCtrls;
                            activeTextureGuiCtrl = textureGuiCtrlMain;
                            m_offsetCounter = m_mainOxCounter;

                            SetKeyGroup(m_menuCtrls);
                            
                            m_afterIn = true;

                            // メインメニューを強制アクティブ
                            ButtonActive(0, true);
                        }
                    }
                    else
                    {
                        int i = 0;
                        foreach (ICounter c in m_mainOxCounter)
                        {
                            if (m_moveStartCount.Value() < i)
                            {
                                break;
                            }
                            c.Inc();
                            m_menuCtrls[i].X = (int)MENU_POS[i].X + c.Value();
                            m_menuCtrls[i].Y = (int)MENU_POS[i].Y;
                            ++i;
                        }
                        // スライドアウト終了か
                        bool inExtra = IsEndAll(m_mainOxCounter);
                        if (inExtra)
                        {
                            activeTextureGuiCtrl.Focus(0);
                            m_afterIn = false;
                            m_switingMenu = false;
                            //Log.print("####  EXTRA IN");
                        }
                    }
                }
            }
            // 切り替え中は入力を受け付けない
            if (!m_switingMenu)
            {
                OnMoveMenuSimple(m_gSys.Screen);
            }
        }

        /// ボタンを動作させる
        private void OnMoveMenuSimple(IScreen screen)
        {
            int i = 0;
            foreach (TextureGUIControl.Control ctrl in m_menuCtrls)
            {
                if (m_switingMenu)
                {
                    break;
                }
                FocusableTextureButton bt = ctrl.Parts as FocusableTextureButton;
                if (bt.IsHover)
                {
                    ButtonActive(i, false);
                    m_dial.TurnTo(GetDialID(i));
                    // keyGroupの内部移動
                    // これにより、Keyであれマウスであれ、今選択されいるところに
                    // keyGroupインデックスがあることになる
                    activeTextureGuiCtrl.SetSelectNo(i);
                }
                ++i;
            }
        }

        /// <summary>
        /// 描画処理
        /// </summary>
        /// <param name="gameSystem">共通で使用するGameSystemのインスタンス</param>
        private void OnPaint(GameSystem gameSystem)
        {
            gameSystem.Screen.SetColor(255, 255, 255, 255);
            // 画面消去
            gameSystem.Screen.SetClearColor(255, 255, 255);
            gameSystem.Screen.Clear();
            gameSystem.Screen.BlendSrcAlpha();
            gameSystem.Screen.SetClearColor(0, 0, 0);

            // 背景描画
            gameSystem.Screen.Blt(m_imgBg, (int)BG_RECT.Left, (int)BG_RECT.Top, BG_RECT);

            // ダイヤルの描画
            m_dial.SetXY(m_dialx.Value(), m_dialy.Value());
            m_dial.OnDraw(gameSystem.Screen);

            // タイトル描画	
            TransBltter.Blt(21, gameSystem.Screen, m_imgTitle, TITLE_POS_X, TITLE_POS_Y, m_titlePhase.Value());

            // copyright描画
            gameSystem.Screen.Blt(m_imgCopyright, COPY_POS_X, COPY_POS_Y);

            // ボタン描画
            activeTextureGuiCtrl.OnPaint(gameSystem.Screen);

            // 説明文の表示
            gameSystem.Screen.Blt(m_tlCaption.GetTexture(GetCaptionNo()), CAPTION_POS_X, CAPTION_POS_Y);
        }

        /// <summary>
        ///  表示すべき説明画像のインデックス番号を取得する	
        /// </summary>
        /// <returns></returns>
        private int GetCaptionNo()
        {
            if (m_switingMenu)
            {
                return m_mainMenu ? (int)MAIN_BUTTON_ID.EXTRA + (int)EXTRA_BUTTON_ID.RETURN + 1 : (int)MAIN_BUTTON_ID.EXTRA;
            }
            else
            {
                return m_mainMenu ? m_lastSelect : (int)MAIN_BUTTON_ID.EXTRA + 1 + m_lastSelect;
            }
        }


        /// 初期化処理
        private void OnInit()
        {
            m_mainMenu = true;
            m_mouse = m_gSys.KeyDecolateMouse;

            // BGM再生
            if (!m_gSys.CommonBgmLoader.IsPlaying(0))
            {
                m_gSys.CommonBgmLoader.PlayBGM(0);
            }
            m_gSys.CommonBgmLoader.GetSound(0).Volume = m_gSys.OptionInfo.BGMVolume / 100.0f;

            m_imgBg = YamalibConst.CreateTexture("img/title/bg_a.png");
            m_imgFrame = YamalibConst.CreateTexture("img/title/t_cov.png");
            m_imgTitle = YamalibConst.CreateTexture("img/title/t_logo.png");
            m_imgCopyright = YamalibConst.CreateTexture("img/title/t_copy.png");

            InitMenuButton();
            activeTextureGuiCtrl = textureGuiCtrlMain;
            m_menuCtrls = m_mainCtrls;

            // デフォルト選択を行う
            if (IsSaveExist())
            {
                ButtonActive((int)MAIN_BUTTON_ID.CONTINUE, true);
            }
            else
            {
                ButtonActive((int)MAIN_BUTTON_ID.START, true);
            }

            // キャプションのローダ
            m_tlCaption = m_gSys.SmartTextureLoader.LoadDefFile("img/title/caption.lst");

            // ダイアルの準備
            SetDial();

            m_gSys.Screen.SetClearColor(255, 255, 255, 255);

            // keygroup
            SetKeyGroup(m_mainCtrls);

            if (IsSaveExist())
            {
                activeTextureGuiCtrl.Focus(1);
            }
            else
            {
                activeTextureGuiCtrl.Focus(0);
            }

            Reset();
        }


        /// 対象のボタンをアクティブに、他を元に戻す
        private void ButtonActive(int index, bool force)
        {
            if (index < 0)
            {
                return;
            }
            if (m_lastSelect != index || force)
            {
                List<TextureGUIControl.Control> theCtrls = m_menuCtrls;

                if (0 <= m_lastSelect && m_lastSelect < theCtrls.Count)
                {
                    // 今アクティブになっているものを元に戻す
                    FocusableTextureButton bt = GetControl(theCtrls, m_lastSelect).Parts as FocusableTextureButton;
                    bt.LoaderOffset -= 1;
                    if (bt.LoaderOffset < 0)
                    {
                        bt.LoaderOffset = 0;
                    }
                }
                // 今アクティブのものをONにする
                FocusableTextureButton btt = GetControl(theCtrls, index).Parts as FocusableTextureButton;
                btt.LoaderOffset += 1;

                m_lastSelect = index;

                // keyGroupも移動
                activeTextureGuiCtrl.SetSelectNo(index);
            }
        }

        private static TextureGUIControl.Control GetControl(List<TextureGUIControl.Control> theCtrls, int index)
        {
            int i = 0;
            foreach (TextureGUIControl.Control ctrl in theCtrls)
            {
                if (index == i++)
                {
                    return ctrl;
                }
            }
            return null;
        }

        private bool IsSaveExist()
        {
            // TODO
            return true;
        }

        /// シナリオを読んだかどうかを返却する
        private bool IsScenarioRead(KyojinConst.ScenarioID scenarioID)
        {
            return m_gSys.UserInfo.IsRead((int)scenarioID);
        }

        /// メニューボタンを初期化します
        private void InitMenuButton()
        {

            // コントロールの準備
            ctrlContext = new ControlContext();
            ctrlContext.MouseInput = m_gSys.MouseOriginal;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);
            textureGuiCtrlMain.OnInit(ctrlContext);
            textureGuiCtrlExtra.OnInit(ctrlContext);

            string mainButtonDefFile = "img/title/menu_bt_main.lst";
            bool readAll = IsScenarioRead(KyojinConst.ScenarioID.KYOJIN03);

            for (int i = 0; i <= (int)MAIN_BUTTON_ID.EXTRA; ++i)
            {

                if ((int)MAIN_BUTTON_ID.EXTRA == i && !readAll)
                {
                    break;
                }
                FocusableTextureButton bt = new FocusableTextureButton(mainButtonDefFile, false);
                // イメージのオフセット
                bt.LoaderOffset = i * 4;
                bt.OnClick += GetMainButtonEvent(i);
                TextureGUIControl.Control ctrl = new TextureGUIControl.Control(bt, (int)MENU_POS[i].X, (int)MENU_POS[i].Y);
                textureGuiCtrlMain.AddControl(ctrl);
                m_mainCtrls.Add(ctrl);

                ICounter counter = new RootCounterS();
                counter.Set(0, MENU_OFFSET_X, MENU_SWITCH_STEP);
                m_mainOxCounter.Add(counter);
            }

            if (readAll)
            {
                string extraButtonDefFile = "img/title/menu_bt_extra.lst";
                for (int i = 0; i <= (int)EXTRA_BUTTON_ID.RETURN; ++i)
                {

                    FocusableTextureButton bt = new FocusableTextureButton(extraButtonDefFile, false);
                    // イメージのオフセット
                    bt.LoaderOffset = i * 4;
                    bt.OnClick += GetExtraButtonEvent(i);
                    TextureGUIControl.Control ctrl = new TextureGUIControl.Control(bt, (int)MENU_POS[i].X + MENU_OFFSET_X, (int)MENU_POS[i].Y);
                    textureGuiCtrlExtra.AddControl(ctrl);
                    m_extraCtrls.Add(ctrl);

                    ICounter counter = new RootCounterS();
                    counter.Set(0, MENU_OFFSET_X, MENU_SWITCH_STEP);
                    m_extraOxCounter.Add(counter);
                }
            }

        }

        /// <summary>
        /// リセット
        /// </summary>
        private void Reset()
        {
            m_toExitFlg = false;
            m_intoFlg = true;
            m_dialx.Set(DIAL_POS_X + DIAL_OUT_POS_OFFSET, DIAL_POS_X, 4);
            m_dialy.Set(DIAL_POS_Y + DIAL_OUT_POS_OFFSET, DIAL_POS_Y, 4);
            m_titlePhase.Reset();
        }

        /// 右回りさせるか
        private static bool IsRightTurn(IMouseInput mouse, IKeyInput key)
        {
            return mouse.IsPush(MouseInput.Button.Left) || key.IsPush(4);
        }

        /// 左回りさせるか
        private static bool IsLeftTurn(IMouseInput mouse, IKeyInput key)
        {
            return mouse.IsPush(MouseInput.Button.Left) || key.IsPush(3);
        }

        /// <summary>
        /// ボタンに対応したデリゲートを返却する
        /// </summary>
        /// <param name="buttonId"></param>
        /// <returns></returns>
        private Yanesdk.GUIParts.TextureButton.MouseEvent GetMainButtonEvent(int buttonId)
        {
            // メインメニュー
            switch ((MAIN_BUTTON_ID)buttonId)
            {
                case MAIN_BUTTON_ID.START:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        // 選択画面へ遷移
                        m_gSys.SceneController.CallScene(Scenes.Selector);
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                case MAIN_BUTTON_ID.CONTINUE:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        if (IsSaveExist())
                        {
                            // 選択画面へ遷移
                            m_gSys.FromTitleScene = true;
                            m_gSys.SceneController.CallScene(Scenes.SeveLoad);
                            m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                        }
                        else
                        {
                            m_gSys.PlaySENegative();
                        }
                    };
                case MAIN_BUTTON_ID.OPTION:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        // 選択画面へ遷移
                        m_gSys.SceneController.CallScene(Scenes.OptionSetting);
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                case MAIN_BUTTON_ID.EXTRA:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_mainMenu = false;
                        m_switingMenu = true;
                        SetUpMainSlideOut();
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                case MAIN_BUTTON_ID.EXIT:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        // 終了
                        m_gSys.TaskController.Terminate();
                    };
                default:
                    Debug.Assert(false);
                    return null;
            }
        }

        /// <summary>
        /// ボタンに対応したデリゲートを返却する
        /// </summary>
        /// <param name="buttonId"></param>
        /// <returns></returns>
        private Yanesdk.GUIParts.TextureButton.MouseEvent GetExtraButtonEvent(int buttonId)
        {
            switch ((EXTRA_BUTTON_ID)buttonId)
            {
                case EXTRA_BUTTON_ID.MUSIC:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        // 選択画面へ遷移
                        m_gSys.SceneController.CallScene(Scenes.MusicRoom);
                        m_gSys.CommonBgmLoader.StopBGMFade(1000);
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                case EXTRA_BUTTON_ID.ENDING:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        // 選択画面へ遷移
                        m_gSys.SceneController.CallScene(Scenes.EndingOption);
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                case EXTRA_BUTTON_ID.RETURN:
                    return delegate(IScreen scr, ControlContext cc)
                    {
                        m_mainMenu = true;
                        m_switingMenu = true;
                        SetUpExtraSlideOut();
                        m_gSys.PlaySystemSE((int)GameSystem.SYS_SE.CLICK_TITLE_ACTIVE);
                    };
                default:
                    Debug.Assert(false);
                    return null;
            }
        }


        /// ダイヤルの設定を行う
        private void SetDial()
        {
            m_dial = new TitleDial();
            ITexture t = YamalibConst.CreateTexture("img/title/dial_item/null.png");

            // 回転ダミー用として入れておく
            m_dial.AddItemName(t, LC_DID_START);
            m_dial.AddItemName(t, LC_DID_CONTINUE);
            m_dial.AddItemName(t, LC_DID_OPTION);
            m_dial.AddItemName(t, LC_DID_EXIT);

            // その他
            // TODO 評価版用
            if (m_gSys.UserInfo.IsReadKyojin())
            {
                m_dial.AddItemName(t, LC_DID_OPTION);
                m_dial.AddItemName(t, LC_DID_OPTION);
            }

            ITexture t3 = YamalibConst.CreateTexture("img/title/t_op.png");
            m_dial.SetDialTexture(t3);
            m_dial.SetXY(DIAL_POS_X, DIAL_POS_Y);
        }

        private int GetDialID(int line)
        {
            if (!m_mainMenu)
            {
                return (int)MAIN_BUTTON_ID.EXTRA - 1 + line;
            }
            return line;
        }

        private void SetUpMainSlideOut()
        {
            m_moveStartCount.Set(0, (int)MAIN_BUTTON_ID.EXTRA, MENU_OUT_INTERVAL);
            for (int i = 0; i < m_mainOxCounter.Count; i++)
            {
                m_mainOxCounter[i].Set(0, MENU_OFFSET_X, MENU_SWITCH_STEP);
            }
            for (int i = 0; i < m_extraOxCounter.Count; i++)
            {
                m_extraOxCounter[i].Set(MENU_OFFSET_X, 0, MENU_SWITCH_STEP);
            }
        }

        private void SetUpExtraSlideOut()
        {
            m_moveStartCount.Set(0, (int)MAIN_BUTTON_ID.EXTRA, MENU_OUT_INTERVAL);
            for (int i = 0; i < m_extraOxCounter.Count; i++)
            {
                m_extraOxCounter[i].Set(0, MENU_OFFSET_X, MENU_SWITCH_STEP);
            }
            for (int i = 0; i < m_mainOxCounter.Count; i++)
            {
                m_mainOxCounter[i].Set(MENU_OFFSET_X, 0, MENU_SWITCH_STEP);
            }
        }

        /// <summary>
        /// 指定したコントロールをキーグループに登録する
        /// </summary>
        /// <param name="ctrls"></param>
        private void SetKeyGroup(List<TextureGUIControl.Control> ctrls)
        {
            activeTextureGuiCtrl.ClearFocusGUI();
            foreach (TextureGUIControl.Control ctrl in ctrls)
            {
                FocusableTextureButton bt = ctrl.Parts as FocusableTextureButton;
                activeTextureGuiCtrl.AddFocusGUI(bt);
            }
        }


    }
}