using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;

namespace Yamalib.Draw
{
    public static class DrawAssist
    {
        public class Context
        {

            #region otB[h

            private Size m_originalSize;
            private int m_rad = 0;
            private int m_radBaseX;
            private int m_radBaseY;
            private bool m_enableRad = false;
            private float m_rate = 1.0f;
            private bool m_enableRate = false;
            private int m_offsetType;
            private Rect m_srcRect;
            private bool m_enableSrcRect = false;
            private Rect m_dstRect;
            private bool m_enableDstRect = false;

            #endregion

            /// RXgN^
            // OriginalSize ͑z肷IWĩTCY
            // ̃TCY{̃TCYƑz肵āȂ̕`IvVs
            public Context(Size originalSize)
            {
                this.m_originalSize = originalSize;
            }

            /// TCYARate Zsic͈ێĂ̂ƂAxɃTCYo܂B
            public float GetSizeToRate(ITexture texture)
            {
                return this.m_originalSize.Cx / texture.Width;
            }

            /// 擾̂(̎QƂύX肵Ȃ
            public Size OriginalSize()
            {
                return this.m_originalSize;
            }

            /// gk
            public float Rate()
            {
                return this.m_rate;
            }
            public float Rate(float r)
            {
                return this.m_rate = r;
            }
            public bool EnableRate()
            {
                return this.m_enableRate;
            }
            public bool EnableRate(bool b)
            {
                return this.m_enableRate = b;
            }

            /// gkŕ`悷Ƃ́AʒũItZbg^Cv
            /**
             * 
             * base͓]摜ǂ̓_(x,y)ɗ邩w肵܂B<BR>
             *	0	 : B		1 : ӂ̒_@2:E<BR>
             *	3	 : ӂ̒_	4 : 摜S	5:Eӂ̒_<BR>
             *	6	 : B@	7 : ӂ̒_	8:E<BR>
             */
            public int OffsetType()
            {
                return m_offsetType;
            }
            public int OffsetType(int type)
            {
                return m_offsetType = type;
            }

            /// ]
            public int Rad()
            {
                return m_rad;
            }
            public int RadBx()
            {
                return this.m_radBaseX;
            }
            public int RadBy()
            {
                return this.m_radBaseY;
            }
            public void SetRad(int rad_, int bx_, int by_)
            {
                m_rad = rad_;
                m_radBaseX = bx_;
                m_radBaseY = by_;
            }
            /// ]LɂA]A]`͖܂
            public bool EnableRad()
            {
                return this.m_enableRad;
            }
            public bool EnableRad(bool b)
            {
                return this.m_enableRad = b;
            }

            /// ]`̐ݒ
            public Rect SrcRect()
            {
                return this.m_srcRect;
            }
            public Rect SrcRect(Rect rect)
            {
                return this.m_srcRect = rect;
            }
            public bool EnableSrcRect()
            {
                return this.m_enableSrcRect;
            }
            public bool EnableSrcRect(bool b)
            {
                return this.m_enableSrcRect = b;
            }

            /// ]`̐ݒ
            public Rect DstRect()
            {
                return this.m_dstRect;
            }
            public Rect DstRect(Rect rect)
            {
                return this.m_dstRect = rect;
            }
            public bool EnableDstRect()
            {
                return this.m_enableDstRect;
            }
            public bool EnableDstRect(bool b)
            {
                return this.m_enableDstRect = b;
            }


        }

        public static Context SCREEN_SIZE;	// Ƃ肠wip 640 * 480

        /// ÓIRXgN^
        static DrawAssist()
        {
            Size size = new Size(640, 480);
            SCREEN_SIZE = new Context(size);
        }

        /// ReNXgɂĕ`s
        public static void Blt(IScreen screen, ITexture texture, int x, int y, Context context)
        {
            Size size = new Size(0,0);
            Rect srcRect = new Rect();
            Rect dstRect = new Rect();

            if (context.EnableSrcRect())
            {
                Rect orgRect = context.SrcRect();
                if (!(orgRect == null))
                {
                    float xRate = (texture.Width / (float)context.OriginalSize().Cx);
                    float yRate = (texture.Height / (float)context.OriginalSize().Cy);
                    srcRect.Left = orgRect.Left * xRate;
                    srcRect.Right = orgRect.Right * xRate;
                    srcRect.Top = orgRect.Top * yRate;
                    srcRect.Bottom = orgRect.Bottom * yRate;
                    size.SetSize(
                        (int)(srcRect.Width * xRate),
                        (int)(srcRect.Height * yRate));
                }
            }

            if (context.EnableRad())
            {
                //-- ]
                float rate = 1.0f;
                // g嗦̊Z
                if (context.EnableRate())
                {
                    rate = (context.OriginalSize().Cx * context.Rate())
                            / texture.Width;
                }
                else
                {
                    rate = context.GetSizeToRate(texture);
                }
                screen.BltRotate(texture, x, y, context.Rad(), rate, context.OffsetType());
            }
            else if (context.EnableRate())
            {
                //-- gk
                if (context.EnableSrcRect() && !(context.SrcRect() == null))
                {
                    size.Cx = (int)(context.SrcRect().Width * context.Rate());
                    size.Cy = (int)(context.SrcRect().Height * context.Rate());

                }
                else
                {
                    size.SetSize((int)(context.OriginalSize().Cx * context.Rate()),
                          (int)(context.OriginalSize().Cy * context.Rate()));
                }

                screen.Blt(texture, x, y,
                        context.EnableSrcRect() ? srcRect : null, size);

            }
            else
            {
                if (context.EnableSrcRect())
                {
                    screen.Blt(texture, x, y, srcRect, size);
                }
                else
                {
                    // ʏ`
                    screen.Blt(texture, x, y, null, context.OriginalSize());
                }
            }
        }
    }
}
