using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Yanesdk.Math;
using Yanesdk.Ytl;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Timer;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// iJj킷NX
    /// </summary>
    public class DropObject : TaskBase
    {
        /// <summary>
        /// IuWFNg̑
        /// </summary>
        public class DropObjectInfo
        {
            public int x, y, alpha;
            public float depth = 1.0f;		//!< s

            /// ݒ
            public void Set(int x, int y, int alpha, float depth)
            {
                this.x = x;
                this.y = y;
                this.alpha = alpha;
                this.depth = depth;
            }
            public DropObjectInfo()
            {
            }

            /// ݒRXgN^
            public DropObjectInfo(int x, int y, int alpha, float depth)
            {
                Set(x, y, alpha, depth);
            }
        }

        #region otB[h

        private static ObjectPool<DropObjectInfo> sip;		//!< IuWFNg`l
        private static Surface alphaFilter;
        private static int filter_ox;
        private static int filter_oy;

        private readonly SinTable st = SinTable.Instance;
        private readonly Rand rand = new Rand();
        private bool alive = false;
        private ITexture snow;
        private float x, y;				//!< `ʒu
        private int alpha = 128;				//!< `惿l
        private float dropspeed = 1.0f;	//!< x
        private float depth = 1.0f;		//!< [
        private float[] amplitude;	//!< U̔z
        private readonly List<float> count = new List<float>();		//!< ݂̊px
        private float[] anglespeed;	//!< Ůpx
        private int weight;			//!< ̂̏d
        private float x_rand = 1.5f;	//!< UɉZ郉_

        private DropObjectManager manager;

        #endregion

        /// <summary>
        /// ÓIRXgN^
        /// </summary>
        static DropObject()
        {
            sip = new ObjectPool<DropObjectInfo>();
            sip.Max = (500);

            for (int i = 0; i < sip.Max; i++)
            {
                sip.Stack[i] = new DropObjectInfo();
            }
        }

        /// At@tB^̐ݒ
        public static void SetAlphaFilter(Surface surface, int ox, int oy)
        {
            alphaFilter = surface;
            filter_ox = ox;
            filter_oy = oy;
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        public DropObject()
            : base()
        {
            rand.Randomize();
        }

        /// <summary>
        /// Ă邩ǂ
        /// </summary>
        public bool IsAlive
        {
            get { return alive; }
        }

        public override int Task(object o)
        {
            if (!alive)
            {
                return 1;
            }
            IScreen screen = o as IScreen;
            screen.BlendAddColorAlpha();

            // pz̗vfׂ͂ēł
            //assert(count.length == anglespeed.length && count.length == amplitude.length);

            for (int i = 0; i < count.Count; ++i)
            {
                count[i] += anglespeed[i];

                if (count[i] > 512) count[i] = 0.0f;

                float ox = amplitude[i] * 128;
                float rx = 0.0f;
                if (x_rand != 0)
                {
                    rx = rand.GetRand((int)(x_rand * 128)) / 128.0f;
                }
                x += st.Sin((int)count[i], (int)(ox * depth)) / 128.0f;	// U
                x += rx - x_rand / 2.0f;		// _
            }

            y += dropspeed * depth;		// 

            if (y > screen.Height)
            {
                // E
                // ܂^XNĂ̓_
                Kill();
                return 1;
            }

            screen.SetColor(255, 255, 255,
                (int)(alpha * GetFilteredAlhaRate((int)x, (int)y)));
            screen.BltRotate(snow, (int)x, (int)y, 0, depth, 4);

            return 0;
        }

        /// J̃X^_[hȐݒ
        public void SetRain()
        {
            float[] amp = new float[] { 0.0f };
            float[] angle = new float[] { 0.0f };

            SetDropSpeed(10.0f);
            SetDepth((rand.GetRand(10) + 5) / 10.0f);
            SetRadAttribute(angle, amp);
            SetRandX(0);
        }

        /// ̃X^_[hȐݒ
        public void SetSnow()
        {
            SetDropSpeed(1.0f);
            SetDepth((rand.GetRand(10) + 5) / 10.0f);
            SetRandX(0.0f);

            float[] amp = new float[] { 0.2f, 0.1f, 0.1f };
            float[] angle = new float[] { 3.5f, 1.0f, 0.5f };
            SetRadAttribute(angle, amp);
        }

        public void Kill()
        {
            if (alive)
            {
                alive = false;
                manager.GetPool().PushForced(this);
            }
        }
        /// ʒu̐ݒ
        public void InitPos()
        {
            rand.Randomize();
            int x = rand.GetRand(640);
            if (dropspeed > 0.0f)
            {
                SetXY(x, 0);
            }
            else
            {
                SetXY(x, 480);
            }
            alive = true;
        }
        /// eNX`̃Zbg
        public void SetTexture(ITexture t) { snow = t; }

        /// xid͊֌WȂΒlj
        public void SetDropSpeed(float f) { dropspeed = f; }
        /// `扜sƂȂg僌[g
        public void SetDepth(float f) { depth = f; }
        public float GetDepth() { return depth; }

        /// `ʒu̐ݒ
        public void SetXY(float x, float y) { this.x = x; this.y = y; }
        public void GetXY(out float x, out float y) { x = this.x; y = this.y; }

        /// pxAU̐ݒ(g`̍lƂĕ\)
        public void SetRadAttribute(float[] angleSpeed_, float[] amplitude_)
        {
            anglespeed = angleSpeed_;
            amplitude = amplitude_;

            //  JE^̏
            count.Clear();
            for (int i = 0; i < angleSpeed_.Length; ++i)
            {
                count.Add(rand.GetRand(512));
            }
        }

        /// IuWFNg̏dݒigpj
        public void SetWeight(int n) { weight = n; }
        /// U_̐ݒ
        public void SetRandX(float f) { x_rand = f; }

        /// }l[W̎QƂZbg
        public void SetManager(DropObjectManager v)
        {
            manager = v;
        }

        private static unsafe float GetFilteredAlhaRate(int x, int y)
        {
            if (alphaFilter == null)
            {
                return 1.0f;
            }
            int width = (int)alphaFilter.Width;
            int height = (int)alphaFilter.Height;
            // At@L32bitf[^
            Sdl.SDL.SDL_Color* pixels = (Sdl.SDL.SDL_Color*)alphaFilter.Pixels;
            return pixels[(y * width + x)].unused / 255.0f;
        }
    }


    /// <summary>
    /// ǗNX
    /// </summary>
    public class DropObjectManager : IDisposable
    {
        #region otB[h

        private readonly ObjectPool<DropObject> pool;	//!< IuWFNgv[
        private readonly TaskController controller;	//!< ^XNRg[
        private readonly Rand rand;	// _
        private TextureLoader tl;		// eNX`̃[_
        private float generate = 0.5345f;	//!< t[Ԃɐ̐iԊu͂Ȃ̂œKȒ[Ă
        private float generatecount = 0.0f;	//!< ̐
        private GameTimer timer;
        private int stopTime = -1;
        private bool snow;
        private bool rain;

        #endregion

        // ^XÑIuWFNgv[
        public DropObjectManager()
        {
            controller = new TaskController();
            pool = new ObjectPool<DropObject>();
            rand = new Rand();
            tl = new TextureLoader();
            tl.IsDefRelativePath = false;
            tl.LoadDefFile("img/ending/dropobj_img.txt");
        }

        #region IDisposable o

        public void Dispose()
        {
            YamalibUtility.Dispose(tl);
            YamalibUtility.Dispose(pool);
        }

        #endregion

        /// 
        public void Init(int n)
        {
            pool.Max = (800);
            for (int i = 0; i < pool.Max; i++)
            {
                DropObject s = new DropObject();
                if (snow)
                {
                    s.SetTexture(tl.GetTexture(0));
                    s.SetSnow();
                }
                else if (rain)
                {
                    s.SetTexture(tl.GetTexture(1));
                    s.SetRain();
                }
                s.SetXY(rand.GetRand(640), rand.GetRand(480));
                s.SetManager(this);

                pool.Stack[i] = s;

            }

            for (int i = 0; i < n; ++i)
            {
                DropObject s = pool.Pop();
                if (s != null)
                {
                    controller.AddTask(s, 0);
                }
            }
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {

            float adGen = generate;
            if (stopTime != -1)
            {
                if (timer.Time >= stopTime)
                {
                    adGen = 0;
                }
                else
                {
                    adGen = adGen - (((float)timer.Time / (float)stopTime) * adGen);
                }
            }

            generatecount += adGen;
            if (generatecount > 1.0f)
            {
                for (int i = 0; i < (int)generatecount; ++i)
                {
                    DropObject s = pool.PopForced();
                    if (s == null)
                    {
                        //Log.printWarn("poolfull!");
                        break;
                    }
                    if (snow)
                    {
                        s.SetSnow();
                        s.InitPos();
                    }
                    else if (rain)
                    {
                        s.SetRain();
                        s.InitPos();
                    }
                    else
                    {
                        // TO DO
                    }

                    controller.AddTask(s, 0);
                }
                // ͐
                generatecount = generatecount - (int)generatecount;
            }

            controller.CallTask(screen);
        }

        /// At@tB^̐ݒ
        public void SetAlphaFilter(Surface surface, int offsetx, int offsety)
        {
            DropObject.SetAlphaFilter(surface, offsetx, offsety);
        }

        /// ĂяoAVKIuWFNg𐶐Ȃ
        public void Stop(int n/*=-1*/)
        {
            timer = new GameTimer();
            timer.Reset();
            stopTime = n;
        }

        /// `IH
        public bool IsFinish()
        {
            return false;
        }

        /// IuWFNgv[擾ifobO
        public ObjectPool<DropObject> GetPool() { return pool; }

        /// Ĵyݒ
        public void PresetRain()
        {
            rain = true;
            snow = false;
            generate = 5.5345f;
        }

        /// ̂yݒ
        public void PresetSnow()
        {
            snow = true;
            rain = false;
            generate = 0.5345f;
        }
    }

}
