using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Math;

namespace Yamalib.Draw.Effect
{

    /// <summary>
    /// tbVCeLXg̊{@\ƃC^[tF[X񋟂܂
    /// </summary>
    public abstract class FlashInObjectBase
    {
        #region 萔l

        protected static int FLASH_TIME = 8;
        protected const int RAND_SIZE = 100;
        protected const int TEXT_MOVE = -10;
        protected const int TEXT_FLASH_ALPHA = 10;

        #endregion

        #region tB[ho
        protected static readonly Rand rand = new Rand();
        protected bool finish;	//!< ݒ肳ꂽ`悪

        protected readonly List<RootCounterS> counters = new List<RootCounterS>();	//!< ړJE^
        protected readonly List<int> posy = new List<int>();				//!< \yl

        private ITexture flash;	//!< ^̃eNX`

        private ITexture textFlash;	//!< eLXgp̔tbV摜

        protected RootCounterS alphaBG;
        protected RootCounterS alpha;	//!< At@l
        protected int alphaStep = 2;

        protected bool pluse;

        protected int showCount;	//!< \Ă镶̐

        protected int counter;

        protected int speedCounter;
        protected int speed;		//!< \x

        #endregion

        public abstract void OnMove(IScreen screen);

        public abstract void OnDraw(IScreen screen);

        /// <summary>
        /// ʑŜtbVĂ邩
        /// </summary>
        public bool IsNowFlashBG
        {
            get { return counter <= FLASH_TIME; }
        }

        /// <summary>
        /// I
        /// </summary>
        public bool IsFinish
        {
            get { return finish; }
        }

        /// <summary>
        /// eLXgJo[tbV摜
        /// TCYɂȂꍇAgk
        /// </summary>
        public ITexture WhiteTexture
        {
            get { return textFlash; }
            set { textFlash = value; }
        }

        /// <summary>
        /// Oɔwi^̃eNX`o^Ă
        /// </summary>
        public ITexture WhileTextureBG
        {
            get { return flash; }
            set { flash = value; }
        }

        /// <summary>
        /// eLXg\x̐ݒ
        /// </summary>
        public int ShowSpeed
        {
            get { return speed; }
            set { speed = value; }
        }

        /// <summary>
        /// Zbg
        /// </summary>
        public virtual void Reset()
        {
            counters.Clear();
            posy.Clear();
        }

    }

    /// <summary>
    /// 񂩂琶eNX`ŃtbVCeLXg܂
    /// </summary>
    public class FlashInText : FlashInObjectBase
    {
        #region 萔l


        #endregion

        #region tB[ho

        private bool init = false;	//!< tO
        private FontRepository fr;	//!< 
        private Textures tv;	//!< 󂯎
        private readonly List<string> texts = new List<string>();	//!< \

        #endregion

        public FlashInText()
            : base()
        {
            fr = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);
            alpha = new RootCounterS();
            alphaBG = new RootCounterS();
            speed = 30;
            counter = 0;
        }

        /// <summary>
        /// O FontLoader 킹Ă
        /// </summary>
        public FontRepository FontRepository
        {
            get { return fr; }
            set { fr = value; }
        }

        /// <summary>
        /// eLXg̒ǉ
        /// </summary>
        /// <param name="str"></param>
        public void AddText(string str)
        {
            if (str != null)
                texts.Add(str);
        }


        /// <summary>
        /// Zbg
        /// </summary>
        public override void Reset()
        {
            base.Reset();
            init = false;
        }

        /// <summary>
        /// OɃeNX`𐶐
        /// </summary>
        public void Update()
        {
            OnInit();
            init = true;
        }

        /// <summary>
        /// ̏
        /// </summary>
        /// <param name="screen"></param>
        public override void OnMove(IScreen screen)
        {
            if (finish) return;

            if (!init)
            {
                OnInit();
                init = true;
            }

            counter++;

            if (alpha.IsEnd)
            {
                speedCounter--;
                if (speedCounter == 0)
                {
                    speedCounter = speed;
                    counter = 0;
                    alpha.Set(255, 0, TEXT_FLASH_ALPHA);

                    if (showCount + 1 == texts.Count)
                    {
                        finish = true;
                    }
                    else
                    {
                        showCount++;
                    }
                }
            }

            if (counter > FLASH_TIME)
            {
                alphaBG++;
                alpha++;

                // ړ
                int i = 0;
                foreach (RootCounterS c in counters)
                {
                    if (i == showCount + 1) break;
                    c++;
                    ++i;
                }
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            int i;
            int sx = screen.Width;
            int sy = screen.Height;

            if ((counter < FLASH_TIME) && !finish)
            {
                Color4ub color = YanesdkUtil.GetNowScreenColor(screen);
                screen.SetColor(255, 255, 255, 255);
                screen.DrawPolygon(
                    0, 0,
                    sx, 0,
                    sx, sy,
                    0, sy);
                screen.SetColor(color);
                return;
            }
            else
            {
                if (!alphaBG.IsEnd)
                {
                    screen.SetColor(255, 255, 255, alphaBG.Value());
                    screen.Blt(WhileTextureBG, 0, 0);
                }
            }

            if ((counter > FLASH_TIME) || finish)
            {
                screen.SetColor(255, 255, 255, 255);
                for (i = 0; i <= showCount; ++i)
                {
                    tv = fr.GetTexture(texts[i], 0);
                    screen.Blt(tv, counters[i].Value(), posy[i]);
                }

                // eLXgJo[tbV
                if (!alpha.IsEnd && !finish)
                {
                    int ty = (int)tv.Height;
                    screen.SetColor(255, 255, 255, alpha.Value());
                    screen.DrawPolygon(
                        0, posy[showCount],
                        sx, posy[showCount],
                        sx, posy[showCount] + ty,
                        0, posy[showCount] + ty);
                }
            }
        }

        #region Jo

        /// 
        private void OnInit()
        {
            posy.Clear();
            counters.Clear();
            alpha.Set(255, 0, TEXT_FLASH_ALPHA);
            alphaBG.Set(0, 255, 12);

            speedCounter = speed;
            int textNum = texts.Count;

            int offsety = 100;
            for (int i = 0; i < textNum; ++i)
            {
                posy.Add(offsety);
                offsety += (280 / textNum);

                // textureTCY𒲂ׂăZ^O
                tv = FontRepository.GetTexture(texts[i], 0);
                int pos = 320 - ((int)tv.Width / 2);
                pluse = !pluse;
                RootCounterS counter = new RootCounterS();
                if (pluse)
                {
                    counter.Set(pos, int.MaxValue, TEXT_MOVE);
                }
                else
                {
                    counter.Set(pos, int.MinValue, TEXT_MOVE);
                }
                counters.Add(counter);
            }
        }

        #endregion

    }
}
