using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Util;
using Yanesdk.Draw;
using System.Diagnostics;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// ʃt[`s܂
    /// </summary>
    public class ScreenFrame
    {
        #region 萔l

        /** Vl}XR[vIWiAXyNg */
        public const float LC_HEIGHT_RATE = 1.0f;
        public const float LC_WIDTH_RATE = 2.35f;
        /** ʃt[^Cv̗ */
        public enum SCREEN_TYPE
        {
            NONE, 	// Ȃ
            CHINEMA_SCOPE,	// Vl}XR[v 1 * 2.35
        };

        #endregion

        #region tB[ho

        private SCREEN_TYPE screenType;

        private float height_rate;
        private float width_rate;
        private RootCounter counter;
        // GtFNgH
        private bool effecting;
        // ~H
        private bool wait;

        // g`悷邩
        private int frameSize;

        // XN[I[v}jAōsH
        private bool openManual;
        private int closeWait;
        private RootCounter waitCounter;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ScreenFrame()
        {
            ScreenType = SCREEN_TYPE.CHINEMA_SCOPE;
            SetAspectRate(1.0f, 1.8f);
            counter = new RootCounter();
            waitCounter = new RootCounter();
        }

        /// <summary>
        /// XN[^Cvw
        /// </summary>
        public SCREEN_TYPE ScreenType
        {
            get { return screenType; }
            set { screenType = value; }
        }

        /// <summary>
        /// t[TCY
        /// </summary>
        public int FrameSize
        {
            get { return frameSize; }
            set { frameSize = value; }
        }

        /// <summary>
        /// ~Ԃǂ
        /// </summary>
        public bool IsWait
        {
            get { return wait; }
        }

        /// <summary>
        /// ʂ̃AXyNgݒ肵܂
        /// </summary>
        /// <param name="h"></param>
        /// <param name="w"></param>
        public void SetAspectRate(float h, float w)
        {
            height_rate = h;
            width_rate = w;
        }

        /// <summary>
        /// ꂽXN[I[v
        /// </summary>
        public void ScreenOpen()
        {
            wait = false;
            openManual = false;
        }

        /// <summary>
        /// OpenbZ[W蓮ő邩H
        /// bZ[W܂ŕ܂
        /// </summary>
        /// <param name="b"></param>
        public void SetOpenManual(bool b)
        {
            openManual = b;
        }

        /// <summary>
        ///  J̃Xs[h
        /// </summary>
        /// <param name="speed"></param>
        /// <param name="closeWait"></param>
        public void SetCloseOpenSpeed(int speed, int closeWait)
        {
            counter.StepValue = speed;
            // ܂܂̒~
            this.closeWait = closeWait;
        }

        /// <summary>
        /// J̕`
        /// </summary>
        /// <param name="screen"></param>
        public void DrawCloseOpen(IScreen screen)
        {
            // ʃTCY̎擾
            int width = screen.Width;
            int height = screen.Height;
            // IWiJ[̎擾
            Color4ub color = YanesdkUtil.GetNowScreenColor(screen);

            screen.SetColor(0, 0, 0, 255);

            if (!effecting)
            {
                // 
                counter.EndValue = height / 2;
                counter.ReverseFlg = true;
                waitCounter.EndValue = closeWait;

                // JnʒuC
                if (SCREEN_TYPE.CHINEMA_SCOPE == screenType)
                {
                    float heightRate = height_rate / width_rate;
                    int drawHeight = height - (int)(height * heightRate);
                    counter.opAssign(drawHeight / 2);
                }
                effecting = true;
            }

            if (counter.IsLapAroundI)
            {
            }
            else
            {
                int pos = counter.Value();
                // 㕔`̈̓hԂ
                screen.DrawPolygon(
                    0, 0,
                    width, 0,
                    width, pos,
                    0, pos);

                // `̈̓hԂ
                screen.DrawPolygon(
                    0, (height - pos),
                    width, (height - pos),
                    width, height,
                    0, height);

                if (wait)
                {
                    if (!openManual)
                    {
                        waitCounter.incS();
                        if (waitCounter.IsLapAround)
                        {
                            wait = false;
                        }
                    }
                }
                else
                {
                    // JE^[
                    counter.Inc();
                    if (counter.ReverseFlg && (0 != closeWait || openManual) && !waitCounter.IsLapAround)
                    {
                        wait = true;
                    }
                }
            }
            screen.SetColor(color);
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            switch (screenType)
            {
                case SCREEN_TYPE.NONE:
                    break;
                case SCREEN_TYPE.CHINEMA_SCOPE:
                    DrawChinemaSope(screen);
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }
        }

        #region Jo

        /// <summary>
        /// Vl}XR[vɂ܂(1 * 2.35)
        /// </summary>
        /// <param name="scren"></param>
        protected void DrawChinemaSope(IScreen screen)
        {
            // ʃTCY̎擾
            int width = screen.Width;
            int height = screen.Height;
            float heightRate = height_rate / width_rate;
            int drawHeight = height - (int)(height * heightRate);
            // IWiJ[̎擾
            Color4ub color = YanesdkUtil.GetNowScreenColor(screen);

            // hԂ
            screen.SetColor(0, 0, 0, 255);

            // 㕔`̈̓hԂ
            screen.DrawPolygon(
                0, 0,
                width, 0,
                width, (drawHeight / 2),
                0, (drawHeight / 2));

            // `̈̓hԂ
            screen.DrawPolygon(
                0, (height - (drawHeight / 2)),
                width, (height - (drawHeight / 2)),
                width, height,
                0, height);

            if (FrameSize > 0)
            {
                // hԂ
                screen.SetColor(255, 255, 255, 255);

                // 㕔`̈̓hԂ
                screen.DrawPolygon(
                    0, (drawHeight / 2) - FrameSize,
                    width, (drawHeight / 2) - FrameSize,
                    width, (drawHeight / 2),
                    0, (drawHeight / 2));

                // `̈̓hԂ
                screen.DrawPolygon(
                    0, (height - (drawHeight / 2)),
                    width, (height - (drawHeight / 2)),
                    width, (height - (drawHeight / 2)) + FrameSize,
                    0, (height - (drawHeight / 2)) + FrameSize);
            }

            // Fɖ߂
            screen.SetColor(color);
        }

        #endregion
    }
}
